/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import myencyclopedia.common.config.DirItem;
import myencyclopedia.common.config.Item;
import myencyclopedia.common.config.XMLConfigFile;
import myencyclopedia.common.utils.FileCopyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStage
extends Stage {
    private Button okBtn;
    private GridPane majorGridPane;
    private GridPane optionalGridPane;
    private int majorRowIdx = 0;
    private int optionalRowIdx = 0;
    private XMLConfigFile xmlConfig;
    private Map<Item, TextField> map = new HashMap<Item, TextField>();
    private String errorMsg = null;
    private static final Logger logger = LoggerFactory.getLogger(ConfigStage.class);
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-common");
    private ResourceBundle rbXml;

    public ConfigStage(XMLConfigFile config, String title, ResourceBundle rbXML) {
        this.xmlConfig = config;
        this.rbXml = rbXML;
        this.initModality(Modality.APPLICATION_MODAL);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                System.exit(0);
            }
        });
        this.okBtn = new Button(rb.getString("CONFIG_STAGE_INSTALL"));
        this.okBtn.setOnAction(e -> {
            for (Item item : this.map.keySet()) {
                File f;
                if (item instanceof DirItem && !(f = new File(this.map.get(item).getText())).exists() && !f.mkdirs()) {
                    this.errorMsg = rb.getString("CONFIG_STAGE_ERR_MSG_CANNOT_CREATE_DIR") + f.toString();
                    break;
                }
                config.setNodeValue(item.path, this.map.get(item).getText());
            }
            this.hide();
        });
        this.majorGridPane = new GridPane();
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints(100.0);
        ColumnConstraints column3 = new ColumnConstraints();
        column3.setHgrow(Priority.ALWAYS);
        column3.setFillWidth(true);
        this.majorGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        this.majorGridPane.setHgap(10.0);
        this.majorGridPane.setVgap(10.0);
        TitledPane optionalPane = new TitledPane();
        optionalPane.setText(rb.getString("CONFIG_STAGE_OPTIONAL"));
        ColumnConstraints columnO1 = new ColumnConstraints();
        ColumnConstraints columnO2 = new ColumnConstraints(100.0);
        ColumnConstraints columnO3 = new ColumnConstraints();
        columnO3.setHgrow(Priority.ALWAYS);
        columnO3.setFillWidth(true);
        this.optionalGridPane = new GridPane();
        this.optionalGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnO1, columnO2, columnO3});
        this.optionalGridPane.setHgap(10.0);
        this.optionalGridPane.setVgap(10.0);
        optionalPane.setContent((Node)this.optionalGridPane);
        Path path = Paths.get(".", new String[0]);
        Text txt = new Text(rb.getString("CONFIG_STAGE_CURRENT_FOLDER") + path.toAbsolutePath().normalize().toString());
        this.majorGridPane.add((Node)txt, 0, this.majorRowIdx, 3, 1);
        ++this.majorRowIdx;
        for (Item item : config.getItems()) {
            if (!(item instanceof DirItem)) continue;
            DirItem dirItem = (DirItem)item;
            this.addDir(dirItem);
        }
        for (Item item : config.getItems()) {
            if (!item.major || !(item instanceof DirItem)) continue;
            this.map.get(item).setText(item.defaultValue);
        }
        VBox box = new VBox();
        box.getChildren().add((Object)this.majorGridPane);
        if (this.optionalRowIdx > 0) {
            box.getChildren().add((Object)optionalPane);
        }
        box.getChildren().add((Object)this.okBtn);
        Scene scene = new Scene((Parent)box, 450.0, -1.0);
        optionalPane.setExpanded(true);
        this.setScene(scene);
        this.setTitle(title);
    }

    public static void copyHelp(String productName) {
        try {
            ClassLoader cl = ConfigStage.class.getClassLoader();
            String fileName = "manual_" + productName + ".html";
            URL url = cl.getResource(fileName);
            if (url == null) {
                logger.error("No manual file " + productName);
                return;
            }
            FileCopyUtil.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(new File(fileName)));
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public Dir addDir(final DirItem item) {
        Text txt = new Text(this.rbXml.getString(item.title));
        GridPane gridPane = item.major ? this.majorGridPane : this.optionalGridPane;
        int rowIdx = item.major ? this.majorRowIdx : this.optionalRowIdx;
        gridPane.add((Node)txt, 0, rowIdx);
        final TextField input = new TextField();
        if (item.major) {
            input.textProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    for (Item it : ConfigStage.this.map.keySet()) {
                        if (it.major || !(it instanceof DirItem) || !it.defaultValue.contains("%" + item.title + "%")) continue;
                        TextField field = (TextField)ConfigStage.this.map.get(it);
                        field.setText(it.defaultValue.replace("%" + item.title + "%", input.getText()));
                    }
                }
            });
        }
        this.map.put((Item)item, input);
        Button btn = new Button("...");
        gridPane.add((Node)btn, 1, rowIdx);
        gridPane.add((Node)input, 2, rowIdx);
        btn.setOnAction(new EventHandler(){

            public void handle(Event event) {
                DirectoryChooser dirChooser = new DirectoryChooser();
                File folder = dirChooser.showDialog((Window)ConfigStage.this);
                if (folder != null) {
                    try {
                        input.setText(folder.getCanonicalPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (item.major) {
            ++this.majorRowIdx;
        } else {
            ++this.optionalRowIdx;
        }
        return new Dir();
    }

    public void done() {
        this.majorGridPane.add((Node)this.okBtn, 1, this.majorRowIdx);
    }

    public class Dir {
    }
}

