/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import myencyclopedia.common.gui.FxOptionPane;
import myencyclopedia.common.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchUtils {
    private static final Logger logger = LoggerFactory.getLogger(LaunchUtils.class);

    public static void exploreFolderAndSelectFile(String filePath) {
        try {
            switch (OSUtils.detectOS()) {
                case WINDOWS: {
                    Runtime.getRuntime().exec("explorer /select," + filePath);
                    break;
                }
                case LINUX: {
                    Runtime.getRuntime().exec("xdg-open '" + filePath + "'");
                }
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }

    public static void exploreFolder(String folderPath) {
        try {
            switch (OSUtils.detectOS()) {
                case WINDOWS: {
                    Runtime.getRuntime().exec("explorer " + folderPath);
                    break;
                }
                case LINUX: {
                    Runtime.getRuntime().exec("xdg-open '" + folderPath + "'");
                }
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }

    public static void openFileWithDefaultApp(String filePath) {
        try {
            switch (OSUtils.detectOS()) {
                case WINDOWS: {
                    filePath = filePath.replaceAll("/", "\\\\");
                    Runtime.getRuntime().exec("cmd /c \"" + filePath + "\"");
                    break;
                }
                case LINUX: {
                    Runtime.getRuntime().exec("xdg-open '" + filePath + "'");
                }
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }

    public static void browsePage(String url) {
        try {
            switch (OSUtils.detectOS()) {
                case WINDOWS: {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break;
                }
                case LINUX: {
                    Runtime.getRuntime().exec("xdg-open '" + url + "'");
                }
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }

    public static void openFileWithDefaultApp(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            LaunchUtils.exploreFolder(path.toString());
            return;
        }
        try {
            switch (OSUtils.detectOS()) {
                case WINDOWS: {
                    Runtime.getRuntime().exec(new String[]{"cmd", "/c", path.toString()});
                    break;
                }
                case LINUX: {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", path.toString()});
                    break;
                }
                case MAC: {
                    Runtime.getRuntime().exec(new String[]{"open", path.toString()});
                }
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }

    public static void openFileWithDesktop(Path path) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(path.toFile());
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            FxOptionPane.showErrorDialog(null, ex, "Error");
        }
    }
}

