/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionModel;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class OrderUtil<T> {
    private ObservableList<T> items;
    private Button btnTop;
    private Button btnUp;
    private Button btnDown;
    private Button btnBottom;
    private SelectionModel selectionModel;

    public OrderUtil(ObservableList<T> items, SelectionModel selectionModel) {
        this.items = items;
        this.selectionModel = selectionModel;
        this.btnTop = new Button("<<");
        this.btnTop.setOnAction(e -> {
            int newIdx = this.gotoTop(selectionModel.getSelectedIndex());
            selectionModel.select(newIdx);
        });
        this.btnUp = new Button("<");
        this.btnUp.setOnAction(e -> {
            int newIdx = this.goUp(selectionModel.getSelectedIndex());
            selectionModel.select(newIdx);
        });
        this.btnDown = new Button(">");
        this.btnDown.setOnAction(e -> {
            int newIdx = this.goDown(selectionModel.getSelectedIndex());
            selectionModel.select(newIdx);
        });
        this.btnBottom = new Button(">>");
        this.btnBottom.setOnAction(e -> {
            int newIdx = this.gotoButtom(selectionModel.getSelectedIndex());
            selectionModel.select(newIdx);
        });
    }

    public Pane createButtonPane(boolean isVertical) {
        if (isVertical) {
            VBox box = new VBox();
            this.btnTop.setMaxWidth(Double.MAX_VALUE);
            this.btnUp.setMaxWidth(Double.MAX_VALUE);
            this.btnDown.setMaxWidth(Double.MAX_VALUE);
            this.btnBottom.setMaxWidth(Double.MAX_VALUE);
            box.getChildren().addAll((Object[])new Node[]{this.btnTop, this.btnUp, this.btnDown, this.btnBottom});
            return box;
        }
        HBox box = new HBox();
        box.getChildren().addAll((Object[])new Node[]{this.btnTop, this.btnUp, this.btnDown, this.btnBottom});
        return box;
    }

    public int gotoTop(int rowIndex) {
        if (rowIndex <= 0 || rowIndex >= this.items.size()) {
            return -1;
        }
        Object affectedItem = this.items.remove(rowIndex);
        this.items.add(0, affectedItem);
        return 0;
    }

    public int gotoButtom(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.items.size() - 1) {
            return -1;
        }
        Object affectedItem = this.items.remove(rowIndex);
        this.items.add(affectedItem);
        return this.items.size() - 1;
    }

    public int goUp(int rowIndex) {
        if (rowIndex <= 0 || rowIndex >= this.items.size()) {
            return -1;
        }
        Object affectedItem = this.items.remove(rowIndex);
        this.items.add(rowIndex - 1, affectedItem);
        return rowIndex - 1;
    }

    public int goDown(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.items.size() - 1) {
            return -1;
        }
        Object affectedItem = this.items.remove(rowIndex);
        this.items.add(rowIndex + 1, affectedItem);
        return rowIndex + 1;
    }
}

