
bl_info = {
    "name": "MedusaNodes",
    "description": "",
    "author": "Boulbayam, Nodes: Kupunia",
    "version": (1, 0, 4),
    "blender": (3, 3, 0),
    "location": "Node Editors > Sidebar",
    "category": "MedusaNodes",
}

import bpy

#Auto-updater module
from . import addon_updater_ops


from bpy.props import (
    CollectionProperty,
    IntProperty,
    BoolProperty,
    StringProperty,
    PointerProperty,
    EnumProperty,
)
from .medusaNodes import *


classes = (
    SCENE_PT_MedusaNodesSaveOptions,
    SCENE_PT_MedusaNodesSaveOptionsIS,
    RENDER_PG_bn_image_settings,
    SCENE_PT_MedusaNodesPrefs,
    MedusaNodesPaintMode,
    MedusaNodesInvokeMaskMenu,
    medusaNodesAddInputGroup,
    MedusaNodesMainDuplGroomFunc,
    MedusaNodesOrder,
    MedusaNodesEditMaskGroup,
    MedusaNodesDeleteGroup,
    MedusaNodesMuteLink,
    MedusaNodesCopyInputLinks,
    MedusaNodesPasteInputLinks,
    MedusaNodesCopyInputNodes,
    MedusaNodesPasteInputNodes,
    MedusaNodesCreateMatAtt,
    MedusaNodesRenameMatAtt,
    MedusaNodesRemoveMatAtt,
    MedusaNodeTreeMaskGroupMenu,
    MedusaNodesCreateGuiCurve,
    MedusaNodesAddExsGuiCurve,
    MedusaNodesResInhGuidCurve,
    MedusaNodeTreeGuidesMenu,
    MedusaNodesGuides,
    MedusaNodesNodeProp_Expand,
    MedusaNodesSculptToggle,
    MedusaNodesHide,
    MedusaNodesDisable,
    MedusaNodesDupDeformer,
    MedusaNodesDeleteDeformer,
    MedusaNodesResDeformer,
    MedusaNodeTreeOptionsMenu,
    MedusaNodesAddNode,
    MedusaNodesHideViewport,
    MedusaNodeTreeDeformersMenu,
    MedusaNodesSaveOptions,
    MedusaNodesTree,
    MedusaNodesTreeItem,
    MedusaNodesTreeItem_Expand,
    MedusaNodesAddTemplates,
    MEDUSANODES_UL_TreeItem,
    MedusaNodesMainNewGroom,
    MedusaNodesMainDuplGroom,
    MedusaNodesMainDelGroom,
    MedusaNodesMainNewGroomFunc,
    MedusaNodeTreeOptionsDupMenu,
    MedusaNodes_OP_DuplciateDeformerDConnections,
    MedusaNodes_OP_DuplciateDeformerIConnections,
    
    SCENE_PT_MedusaNodesMain_Viewport,
    # SCENE_PT_MedusaNodesMainRiggingView,
    SCENE_PT_MedusaNodesMainRenVieView,
    SCENE_PT_MedusaNodesMainRenVie_curvesView,
    SCENE_PT_MedusaNodesMainRenVie_viewport_displayView,

    SCENE_PT_MedusaNodesMain,
    # SCENE_PT_MedusaNodesMainRigging,
    SCENE_PT_MedusaNodesMainRenVie,
    SCENE_PT_MedusaNodesMainRenVie_curves,
    SCENE_PT_MedusaNodesMainRenVie_viewport_display,
    

    SCENE_PT_MedusaNodesHierarchy_Viewport,
    SCENE_PT_MedusaNodesHierarchy
)

# Rules for the existing guides picker
def poll(self, obj):
    return obj.type == 'CURVES' and "guidecurves" in obj.name.lower()

def register():
    # for pcoll in preview_collections.values():
    #     bpy.utils.previews.remove(pcoll)
    # preview_collections.clear()
    # pcoll = bpy.utils.previews.new()
    # my_icons_dir = os.path.join(assetPath, "icons")
    # pcoll.load("temp1", os.path.join(my_icons_dir, "temp1.png"), 'IMAGE')
    # pcoll.load("temp2", os.path.join(my_icons_dir, "temp2.png"), 'IMAGE')
    # pcoll.load("temp3", os.path.join(my_icons_dir, "temp3.png"), 'IMAGE')
    # pcoll.load("temp4", os.path.join(my_icons_dir, "temp4.png"), 'IMAGE')
    # pcoll.load("temp5", os.path.join(my_icons_dir, "temp5.png"), 'IMAGE')
    # preview_collections["main"] = pcoll


    #Auto-updater register
    try:
        addon_updater_ops.register(bl_info)
    except:
        pass
    ###################################

    for cls in classes:
        bpy.utils.register_class(cls)
    bpy.types.Scene.medusaGuidePicker = PointerProperty(
            name = "Guides",
            type=bpy.types.Object,
            poll=poll)
    bpy.types.Scene.medusaNodesSaveOptions = PointerProperty(type=MedusaNodesSaveOptions)
    bpy.types.Scene.medusaNodes = CollectionProperty(type=MedusaNodesTree)

    bpy.types.Scene.newGroomName = StringProperty(
        name="",
        description="Groom Name",
        default = "Groom01"
    )
    
    bpy.types.Scene.newGroomPartName= StringProperty(
        name="",
        description="Groom Part Name",
        default = "Part01"
    )
    bpy.types.Scene.medusaNodesTree = CollectionProperty(type=MedusaNodesTreeItem)
    bpy.types.Scene.medusaNodesTree_index = IntProperty(default=-1)
    bpy.types.Scene.medusaNodesActiveOb = StringProperty(default="")
    bpy.types.Scene.medusaNodesActiveNodeTree = StringProperty(default="")
    bpy.types.Scene.medusaNodesActiveNode = CollectionProperty(type=MedusaNodesTreeItem)
    
    for hand in bpy.app.handlers.depsgraph_update_post:
        if nodesUpdate.__name__ == hand.__name__:
            bpy.app.handlers.depsgraph_update_post.remove(hand)
    
    for hand in bpy.app.handlers.save_post:
        if blendFileSaved.__name__ == hand.__name__:
            bpy.app.handlers.save_post.remove(hand)

    bpy.app.handlers.depsgraph_update_post.append(nodesUpdate)
    bpy.app.handlers.save_post.append(blendFileSaved)

def unregister():
    # for pcoll in preview_collections.values():
    #     bpy.utils.previews.remove(pcoll)
    # preview_collections.clear()
    for cls in reversed(classes):
        bpy.utils.unregister_class(cls)
    for hand in bpy.app.handlers.depsgraph_update_post:
        if nodesUpdate.__name__ == hand.__name__:
            bpy.app.handlers.depsgraph_update_post.remove(hand)
    for hand in bpy.app.handlers.save_post:
        if blendFileSaved.__name__ == hand.__name__:
            bpy.app.handlers.save_post.remove(hand)
    addon_updater_ops.unregister()
