import bpy
import os
from bpy.types import PropertyGroup
from bpy.app.translations import pgettext_iface as iface_
import bpy.utils.previews
import re
from collections import defaultdict
from bl_ui.properties_render import draw_curves_settings
import textwrap
import datetime
from bpy.app.handlers import persistent
import json
#Auto-updater module
from . import addon_updater_ops



from bpy.props import (
    CollectionProperty,
    IntProperty,
    BoolProperty,
    StringProperty,
    PointerProperty,
    EnumProperty,
    FloatProperty
)

bl_info = {
    "name": "MedusaNodes",
    "description": "",
    "author": "Boulbayam",
    "version": (1, 0, 4),
    "blender": (3, 3, 0),
    "location": "Node Editors > Sidebar",
    "category": "MedusaNodes",
}

activeNodeGroupName = ""
activeNodeGroupSocket = ""

treeOldList = {}
treeOldCpt = -1
preview_collections = {}
paintModeLstOb = None

sculptModeLstOb = None
sculptMode = False

attrbData = []

script_file = os.path.realpath(__file__)
directory = os.path.dirname(script_file)
assetPath = os.path.join(directory,"medusaNodesAsset")
jsonProfile = os.path.join(directory,"curve_mask_profile.json")
#Icon path added - Irakli
iconPath = os.path.join(assetPath, "icons")
addDeformerMenuIconPath = os.path.join(iconPath, "add_deformer_menu")


pcoll = bpy.utils.previews.new()

for entry in os.scandir(addDeformerMenuIconPath):
    if entry.name.endswith(".png"):
        name = os.path.splitext(entry.name)[0]
        pcoll.load(name, entry.path, "IMAGE")
for entry in os.scandir(iconPath):
    if entry.name.endswith(".png"):
        name = os.path.splitext(entry.name)[0]
        pcoll.load(name, entry.path, "IMAGE")
#--------------------------------------------------------------------


def addMedusaNode(nodeGroup,nodeNameToAdd):
    blendFile = os.path.join(assetPath, "medusaNodes.blend")
    with bpy.data.libraries.load(blendFile) as (data_from, data_to):
        nodeInScene = None
        nodeToAdd = None
        if "mask group" not in nodeNameToAdd.lower():
            nodeInScene = bpy.data.node_groups.get(nodeNameToAdd)
            nodeToAdd = nodeInScene
        if nodeInScene is None:
            data_to.node_groups = [nodeNameToAdd]

        if "Visualizer" in nodeNameToAdd:
            matsImport = []
            for mat in data_from.materials:
                if mat not in bpy.data.materials:
                    matsImport.append(mat)
            data_to.materials = matsImport
    if nodeToAdd is None:
        nodeToAdd = data_to.node_groups[0]

    grp = None
    if nodeToAdd:
        nodeTreeInScene = nodeToAdd
        if nodeTreeInScene:
            matnum = re.search(".\d\d\d$", nodeTreeInScene.name)
            if matnum:
                index = int(matnum.group(0).replace(".",""))
                nodeTreeInScene.name = nodeTreeInScene.name.replace(matnum.group(0)," "+str(index))
            grp = nodeGroup.nodes.new("GeometryNodeGroup")
            grp.node_tree = nodeTreeInScene
            grp.label = nodeNameToAdd.replace("MN ","")
            grp.width = 250
            if "visualizer" in nodeTreeInScene.name.lower():
                for mat in bpy.data.materials:
                    if "guide" in nodeTreeInScene.name.lower():
                        if "_guidecurves_ r" in mat.name.lower():
                            grp.inputs["Hair Roots Material"].default_value = mat
                        elif "_guidecurves_r" in mat.name.lower():
                            grp.inputs["Hair Roots Material"].default_value = mat
                        elif "_guidecurves" in mat.name.lower():
                            grp.inputs["Hair Material"].default_value = mat
                    else:
                        if "_hairs" in mat.name.lower():
                            grp.inputs["Hair Material"].default_value = mat
            for input in grp.inputs:
                #ramp Irakli
                if "ramp" in input.name.lower():
                    if not input.is_linked:
                        groupNode = addMedusaNode(nodeGroup,"MN Ramp Mask Group")
                        nodeGroup.links.new(input,groupNode.outputs[0])
                        align2Nodes(groupNode,grp)
                #----------------------------------------------------------------
                if "profile" in input.name.lower():
                    if not input.is_linked:
                        groupNode = addMedusaNode(nodeGroup,"MN Curve Mask Group")
                        nodeGroup.links.new(input,groupNode.outputs[0])
                        align2Nodes(groupNode,grp)

                        with open(jsonProfile, 'r') as f:
                            profileData = json.load(f)
                        for json_key in profileData:
                            if grp.node_tree.name in json_key:
                                if input.name in profileData[json_key]:
                                    for snode in groupNode.node_tree.nodes:
                                        if snode.type == "CURVE_FLOAT":
                                            m = snode.mapping
                                            while len(m.curves[0].points)>2:
                                                p = m.curves[0].points[0]
                                                m.curves[0].points.remove(p)
                                            data = profileData[json_key][input.name]
                                            if len(data) > 1:
                                                m.curves[0].points[0].location.x = data[0][0]
                                                m.curves[0].points[0].location.y = data[0][1]
                                                for i in range(1,len(data)-1):
                                                    point = data[i]
                                                    p = m.curves[0].points.new(point[0],point[1])
                                                m.curves[0].points[-1].location.x = data[-1][0]
                                                m.curves[0].points[-1].location.y = data[-1][1]
                                            m.update()
    return grp

class MedusaNodesAddNode(bpy.types.Operator):
    bl_idname = "medusanodes.add_node"
    bl_label = ""
    bl_options = {'UNDO'}

    nodeName : StringProperty(default="")
    
    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        allitemsLists = context.scene.medusaNodes
        
        alreadyExi = False
        for item in item_list:
            geoNodes0 = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
            activeNode0 = geoNodes0.node_group.nodes[item.name]
            if "mn guide" in activeNode0.node_tree.name.lower():
                alreadyExi = True
                break
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            nextItemF = None
                            if "mn visual" in activeNode.node_tree.name.lower():
                                nextIndex = item_index + 1
                            else:
                                nextIndex = item_index - 1
                            if not item.expanded and item.childCount > 0 and "mn visual" in activeNode.node_tree.name.lower():
                                for i in range(0,len(allitemsLists)):
                                    nextItem = allitemsLists[i]
                                    if nextItem.nodeTreeName == item.nodeTreeName and nextItem.objectName == item.objectName and nextItem.name != activeNode.name:
                                        nextNode = geoNodes.node_group.nodes[nextItem.name]
                                        
                                        if nextIndex > item_index:
                                            if "mn visual" not in nextNode.node_tree.name.lower():
                                                nextItemF = nextItem
                                                break
                                        else:
                                            nextItemF = nextItem
                                            break
                            else:
                                for i in range(nextIndex,len(item_list)):
                                    nextItem = item_list[i]
                                    if nextItem.nodeTreeName == item.nodeTreeName and nextItem.objectName == item.objectName and nextItem.name != activeNode.name:
                                        nextNode = geoNodes.node_group.nodes[nextItem.name]
                                        
                                        if nextIndex > item_index:
                                            if "mn visual" not in nextNode.node_tree.name.lower():
                                                nextItemF = nextItem
                                                break
                                        else:
                                            nextItemF = nextItem
                                            break

                            nodeLinks = geoNodes.node_group.links
                            newNode = addMedusaNode(geoNodes.node_group,self.nodeName)
                            if nextItemF:
                                nextNode = geoNodes.node_group.nodes[nextItemF.name]
                                if newNode:
                                    if nextIndex > item_index:
                                        if nextNode.location.x > (activeNode.location.x + newNode.width):
                                            nextNode.location.x = nextNode.location.x  - newNode.width/2
                                            activeNode.location.x = activeNode.location.x  + newNode.width/2
                                        newNode.location.x = (activeNode.location.x - nextNode.location.x)
                                        newNode.location.y = (nextNode.location.y + activeNode.location.y)
                                        for output in newNode.outputs:
                                            for input in activeNode.inputs:
                                                if output.name == input.name:
                                                    if input.node != output.node:
                                                        nodeLinks.new(input,output)
                                        
                                        for input in newNode.inputs:
                                            emiGeo = 0
                                            for output in nextNode.outputs:
                                                if output.name == input.name:
                                                    if "emitter geometry" in input.name.lower():
                                                        emiGeo = 1
                                                    if input.node != output.node:
                                                        nodeLinks.new(input,output)
                                            if "emitter geometry" in input.name.lower() and emiGeo == 0:
                                                nodeHier = followLinks(activeNode)
                                                for node in reversed(nodeHier):
                                                    for out in node.outputs:
                                                        if "emitter geometry" in out.name.lower():
                                                            if input.node != out.node:
                                                                nodeLinks.new(input,out)
                                                                break
                                    else:
                                        if nextNode.location.x > (activeNode.location.x + newNode.width):
                                            nextNode.location.x = nextNode.location.x   +newNode.width/2
                                            activeNode.location.x = activeNode.location.x - newNode.width/2
                                        newNode.location.x = (nextNode.location.x - activeNode.location.x)
                                        newNode.location.y = (nextNode.location.y + activeNode.location.y)
                                        for input in newNode.inputs:
                                            emiGeo = 0
                                            for output in activeNode.outputs:
                                                if output.name == input.name:
                                                    if "emitter geometry" in input.name.lower():
                                                        emiGeo = 1
                                                    if input.node != output.node:
                                                        nodeLinks.new(input,output)
                                            if "emitter geometry" in input.name.lower() and emiGeo == 0:
                                                nodeHier = followLinks(activeNode)
                                                for node in reversed(nodeHier):
                                                    for out in node.outputs:
                                                        if "emitter geometry" in out.name.lower():
                                                            if input.node != out.node:
                                                                nodeLinks.new(input,out)
                                                                break
                                        for output in newNode.outputs:
                                            for input in nextNode.inputs:
                                                if output.name == input.name:
                                                    if input.node != output.node:
                                                        nodeLinks.new(input,output)
                            else:
                                if newNode:
                                    newNode.location.x = activeNode.location.x - 250
                                    for output in newNode.outputs:
                                        for input in activeNode.inputs:
                                            if output.name == input.name:
                                                if input.node != output.node:
                                                    nodeLinks.new(input,output)
                            
                            SetupNodeData()
                            if newNode and not alreadyExi and "mn guide" in newNode.node_tree.name.lower():
                                try:
                                    if "mn visual" in activeNode.node_tree.name.lower():
                                        
                                        ind = nextIndex
                                        if not item.expanded:
                                            for i in range(0,len(allitemsLists)):
                                                indexIte = allitemsLists[i]
                                                if indexIte.name == newNode.name:
                                                    ind = indexIte.selfIndex
                                        bpy.ops.medusanodes.guides_menu(index=ind, guideItems='0')
                                    else:
                                        bpy.ops.medusanodes.guides_menu(index=bpy.context.scene.medusaNodesTree_index, guideItems='0')
                                except:
                                    pass

        return {'FINISHED'}

def align2Nodes(nodeA,nodeB):
    y_locs = nodeA.location.y - nodeA.dimensions.y
    nodeB.location.y = y_locs

def deselectNodes(geoNodes):
    for node in geoNodes.node_group.nodes:
        node.select= False

def deleteSelectedNodes(geoNodes):
    for node in geoNodes.node_group.nodes:
        if node.select == True:
            try:
                geoNodes.node_group.nodes.remove(node)
            except:
                pass

def getSelectedNodes(geoNodes):
    selectedNodes = []
    for node in geoNodes.node_group.nodes:
        if node.select == True:
            selectedNodes.append(node)
    return selectedNodes

def duplicateConnections(geoNodes,node):
    deselectNodes(geoNodes)
    allNodes = followLinks(node,inp=None)
    finNodes = []
    for nodeS in allNodes:
        if nodeS not in finNodes:
            if nodeS.outputs[0].name.lower() != "splines" and nodeS.outputs[0].name.lower() != "hairs":
                finNodes.append(nodeS)
                nodeS.select = True
            elif nodeS == node:
                finNodes.append(node)
                node.select = True
        for subNode in allNodes[nodeS]:
            if subNode not in finNodes:
                if subNode.outputs[0].name.lower() != "splines" and subNode.outputs[0].name.lower() != "hairs":
                    finNodes.append(subNode)
                    subNode.select = True
    finNodes = getSelectedNodes(geoNodes)

    if bpy.context.area.type == "VIEW_3D":
        bpy.ops.screen.userpref_show("INVOKE_DEFAULT")
        addedArea = bpy.context.window_manager.windows[-1].screen.areas[0]
        addedArea.type = "NODE_EDITOR"
        addedArea.spaces.active.tree_type = 'GeometryNodeTree'
        bpy.context.view_layer.update()
        bpy.ops.wm.redraw_timer(type='DRAW_WIN_SWAP', iterations=1)

        for area in bpy.context.screen.areas:
            if area.type == 'NODE_EDITOR' and area.spaces[0].tree_type == 'GeometryNodeTree':
                with bpy.context.temp_override(window=bpy.context.window,area=area,region=[region for region in area.regions if region.type == 'WINDOW'][0]):
                    bpy.ops.node.duplicate_move()
                break
        if addedArea:
            bpy.ops.wm.window_close()
            addedArea = None
    else:
        bpy.ops.node.duplicate_move()
    duplicNodes = getSelectedNodes(geoNodes)
    for nodeIndex in range(0,len(duplicNodes)):
        deselectNodes(geoNodes)
        nodeDu = duplicNodes[nodeIndex]
        r = re.sub('.*?([0-9]*)$',r'\1',nodeDu.label)
        
        if r:
            nodeDu.label = nodeDu.label.replace(r,str(int(r)+1).zfill(2))
        else:
            if nodeDu.label == "":
                if nodeDu.type == "GROUP":
                    nodeDu.label = nodeDu.node_tree.name.lower() + "01"
            else:
                nodeDu.label = nodeDu.label + "01"
        
        nodeOri = finNodes[nodeIndex]
        if nodeDu.type == nodeOri.type:
            align2Nodes(nodeOri,nodeDu)
        
        if nodeDu.type == "GROUP":
            if nodeDu.node_tree.name.lower() == node.node_tree.name.lower():
                for out in node.outputs:
                    if out.name.lower() in ["splines","guide curves","emitter geometry"]:
                        if out.is_linked:
                            for link in out.links:
                                geoNodes.node_group.links.new(nodeDu.outputs[out.name],link.to_socket)
                            geoNodes.node_group.links.new(nodeDu.inputs[out.name],out)
            if "mask" in nodeDu.node_tree.name.lower():
                nodeDu.node_tree = nodeDu.node_tree.copy()

def inheritConnections(geoNodes,node):
    deselectNodes(geoNodes)
    duplicatedInhherNodes = []
    node.select = True
    if bpy.context.area.type == "VIEW_3D":
        bpy.ops.screen.userpref_show("INVOKE_DEFAULT")
        addedArea = bpy.context.window_manager.windows[-1].screen.areas[0]
        addedArea.type = "NODE_EDITOR"
        addedArea.spaces.active.tree_type = 'GeometryNodeTree'
        bpy.context.view_layer.update()
        bpy.ops.wm.redraw_timer(type='DRAW_WIN_SWAP', iterations=1)
        for area in bpy.context.screen.areas:
            if area.type == 'NODE_EDITOR' and area.spaces[0].tree_type == 'GeometryNodeTree':
                with bpy.context.temp_override(window=bpy.context.window,area=area,region=[region for region in area.regions if region.type == 'WINDOW'][0]):
                    node.select = True
                    bpy.ops.node.duplicate_move(NODE_OT_duplicate={"keep_inputs":True})
                    duplicatedInhherNodes = getSelectedNodes(geoNodes)
                break
        if addedArea:
            bpy.ops.wm.window_close()
            addedArea = None
    else:
        bpy.ops.node.duplicate_move(NODE_OT_duplicate={"keep_inputs":True})
        duplicatedInhherNodes = getSelectedNodes(geoNodes)
    for nodeIndex in range(0,len(duplicatedInhherNodes)):
        nodeDu = duplicatedInhherNodes[nodeIndex]
        r = re.sub('.*?([0-9]*)$',r'\1',nodeDu.label)
        if r:
            nodeDu.label = nodeDu.label.replace(r,str(int(r)+1).zfill(2))
        else:
            nodeDu.label = nodeDu.label + "01"
        if nodeDu.type == "GROUP":
            if nodeDu.node_tree.name.lower() == node.node_tree.name.lower():
                for out in node.outputs:
                    if out.name.lower() in ["splines","guide curves","emitter geometry"]:
                        if out.is_linked:
                            for link in out.links:
                                geoNodes.node_group.links.new(nodeDu.outputs[out.name],link.to_socket)
                            geoNodes.node_group.links.new(nodeDu.inputs[out.name],out)
    align2Nodes(node,getSelectedNodes(geoNodes)[-1])


class MedusaNodes_OP_DuplciateDeformerDConnections(bpy.types.Operator):
    bl_label='Duplicate Connections'
    bl_idname='medusanodes.duplicate_deformer_dupli'
    bl_options = {'UNDO'}

    def execute(self, context):
        activeNode = bpy.context.scene.medusaNodesTree[bpy.context.scene.medusaNodesTree_index]
        geoNodes = bpy.data.objects[activeNode.objectName].modifiers[activeNode.nodeTreeName]
        node = geoNodes.node_group.nodes[activeNode.name]
        duplicateConnections(geoNodes,node)
        
        return {'FINISHED'}

class MedusaNodes_OP_DuplciateDeformerIConnections(bpy.types.Operator):
    bl_label='Inherit Connections'
    bl_idname='medusanodes.duplicate_deformer_inh'
    bl_options = {'UNDO'}

    def execute(self, context):
        activeNode = bpy.context.scene.medusaNodesTree[bpy.context.scene.medusaNodesTree_index]
        geoNodes = bpy.data.objects[activeNode.objectName].modifiers[activeNode.nodeTreeName]
        node = geoNodes.node_group.nodes[activeNode.name]
        inheritConnections(geoNodes,node)
        
        return {'FINISHED'}

class MedusaNodesDupDeformer(bpy.types.Operator):
    bl_idname = "medusanodes.dup_deformer"
    bl_label = "Duplicate Deformer"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        bpy.ops.medusanodes.duplicate_deformer("INVOKE_DEFAULT")
        return {'FINISHED'}

class MedusaNodesResDeformer(bpy.types.Operator):
    bl_idname = "medusanodes.reset_deformer"
    bl_label = "Reset Deformer"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        item_index = bpy.context.scene.medusaNodesTree_index
        item_list = bpy.context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            activeNode = item_list[item_index]
            geoNodes = bpy.data.objects[activeNode.objectName].modifiers[activeNode.nodeTreeName]
            node = geoNodes.node_group.nodes[activeNode.name]
            node_tree = node.id_data
                
            if node.type == "GROUP":
                for input,nt_input in zip(node.inputs,node.node_tree.inputs):
                    if hasattr(input, "default_value") and input.type != "MATERIAL" and not input.is_linked:
                        input.default_value = nt_input.default_value
        return {'FINISHED'}

class MedusaNodesDeleteDeformer(bpy.types.Operator):
    bl_idname = "medusanodes.delete_deformer"
    bl_label = "Delete Deformer"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            if "mn visual" not in activeNode.node_tree.name.lower() and "mn spline" not in activeNode.node_tree.name.lower():
                                nodesOutConnectWith = {}
                                nodesInpConnectWith = {}
                                for out in activeNode.outputs:
                                    if out.is_linked:
                                        for link in out.links:
                                            node = link.to_node
                                            if node.type == "GROUP":
                                                nodesOutConnectWith[link.from_socket]=link.to_socket
                                for inp in activeNode.inputs:
                                    if inp.is_linked:
                                        for link in inp.links:
                                            node = link.from_node
                                            nodesInpConnectWith[link.to_socket]=link.from_socket
                                processed = []
                                for conx in nodesOutConnectWith:
                                    for conxi in nodesInpConnectWith:
                                        if conxi.name == conx.name:
                                            geoNodes.node_group.links.new(nodesInpConnectWith[conxi],nodesOutConnectWith[conx])
                                            processed.append(nodesInpConnectWith[conxi])
                                            processed.append(nodesOutConnectWith[conx])

                                for conx in nodesInpConnectWith:
                                    if nodesInpConnectWith[conx] not in processed:
                                        if(len(nodesInpConnectWith[conx].links)) == 1:
                                            if nodesInpConnectWith[conx].node.type != "GROUP":
                                                geoNodes.node_group.nodes.remove(nodesInpConnectWith[conx].node)
                                            else:
                                                if "mask group" in nodesInpConnectWith[conx].node.node_tree.name.lower() and "mn " in nodesInpConnectWith[conx].node.node_tree.name.lower():
                                                    geoNodes.node_group.nodes.remove(nodesInpConnectWith[conx].node)
                                                elif "mn" not in nodesInpConnectWith[conx].node.node_tree.name.lower():
                                                    geoNodes.node_group.nodes.remove(nodesInpConnectWith[conx].node)
                                geoNodes.node_group.nodes.remove(activeNode)
                                SetupNodeData()


        return {'FINISHED'}

class MedusaNodeTreeDeformersMenu(bpy.types.Menu):
    bl_label = "Deformers"
    bl_idname= "MEDUSANODE_MT_deformers_menu"

    def draw(self, context):
        layout = self.layout
        layout.label(text="Deformers",icon="NODE")
        layout.operator("medusanodes.add_node",text="Noise",icon_value=pcoll["noise"].icon_id).nodeName = "MN Noise"
        layout.operator("medusanodes.add_node",text="Curl", icon_value=pcoll["curl"].icon_id).nodeName = "MN Curl"
        layout.operator("medusanodes.add_node",text="Clump", icon_value=pcoll["clump"].icon_id).nodeName = "MN Clump"
        layout.operator("medusanodes.add_node",text="Trim", icon_value=pcoll["trim"].icon_id).nodeName = "MN Trim"
        layout.operator("medusanodes.add_node",text="Guide", icon_value=pcoll["guide"].icon_id).nodeName = "MN Guide"
        layout.operator("medusanodes.add_node",text="Braid",icon_value=pcoll["braid"].icon_id).nodeName = "MN Braid"
        layout.operator("medusanodes.add_node",text="Children",icon_value=pcoll["children"].icon_id).nodeName = "MN Children"

def setupGuide(hairOb,guideOb,scalpOb):
    guideOb.modifiers.clear()
    nodMod = guideOb.modifiers.new("MedusaNodes","NODES")
    nodeModTree = bpy.data.node_groups.get(guideOb.name)
    if nodeModTree:
        bpy.data.node_groups.remove(nodeModTree)
    nodeModTree = bpy.data.node_groups.new(guideOb.name,"GeometryNodeTree")
    nodMod.node_group = nodeModTree

    splineGenNode = addMedusaNode(nodeModTree,"MN Generator")
    VisualNode = addMedusaNode(nodeModTree,"MN Visualizer Guide")

    if splineGenNode and VisualNode:
        # seed value - Irakli
        splineGenNode.inputs["Seed"].default_value = 1
        # density value schould be lower on guide modifier
        splineGenNode.inputs["Density"].default_value = 10
        # Disable Generate
        VisualNode.inputs[0].default_value = False
        groupInput = nodeModTree.nodes.new("NodeGroupInput")
        groupInput.location.x = -200
        groupOutput = nodeModTree.nodes.new("NodeGroupOutput")
        groupOutput.location.x = 700
        objectInfo = nodeModTree.nodes.new("GeometryNodeObjectInfo")
        objectInfo.location.x = -150
        objectInfo.location.y = -100
        objectInfo.inputs[0].default_value = scalpOb
        splineGenNode.location.x = 100
        VisualNode.location.x = 400

        nodeModTree.links.new(splineGenNode.inputs["Splines"],groupInput.outputs[0])
        nodeModTree.links.new(splineGenNode.inputs["Emitter Geometry"],objectInfo.outputs["Geometry"])
        nodeModTree.links.new(VisualNode.inputs["Splines"],splineGenNode.outputs["Splines"])
        nodeModTree.links.new(VisualNode.inputs["Emitter Geometry"],splineGenNode.outputs["Emitter Geometry"])
        nodeModTree.links.new(groupOutput.inputs[0],VisualNode.outputs["Hairs"])
        nodeModTree.links.new(objectInfo.inputs[0],groupInput.outputs[1])
        nodeModTree.inputs[1].name = "Emitter Object"
        groupInput.outputs[1].name = "Emitter Object"
        for gInp in nodMod.node_group.inputs:
            if gInp.name.lower() == "emitter object":
                nodMod[gInp.identifier] = scalpOb
        mat = VisualNode.inputs[14].default_value
        matRoots = VisualNode.inputs[15].default_value

        if mat:
            mat.name = guideOb.name
        if matRoots:
            matRoots.name = guideOb.name+"_Roots"
        guideOb.data.materials.append(mat)
        guideOb.data.materials.append(matRoots)

        hSplineNode = None
        for node in hairOb.modifiers.active.node_group.nodes:
            if node.type == "GROUP":
                if "generator" in node.node_tree.name.lower():
                    hSplineNode = node
                    break
        if hSplineNode:
            d = splineGenNode.inputs["Control Points Count"].driver_add("default_value")
            var1 = d.driver.variables.new()
            var1.name = "AVERAGE"
            var1.targets[0].id_type = 'NODETREE'
            var1.targets[0].id = hairOb.modifiers.active.node_group
            var1.targets[0].data_path = 'nodes["'+hSplineNode.name+'"].inputs["Control Points Count"].default_value'
            d.driver.expression = var1.name

def setupHairOb(hairOb,scalpOb,hairNodeData):
    hairOb.modifiers.clear()
    nodMod = hairOb.modifiers.new("MedusaNodes","NODES")
    nodeModTree = bpy.data.node_groups.get(hairOb.name)
    if nodeModTree:
        bpy.data.node_groups.remove(nodeModTree)
    nodeModTree = bpy.data.node_groups.new(hairOb.name,"GeometryNodeTree")
    nodMod.node_group = nodeModTree

    splineGenNode = addMedusaNode(nodeModTree,"MN Generator")
    VisualNode = addMedusaNode(nodeModTree,"MN Visualizer")

    for inp in hairNodeData:
        for nodeInp in splineGenNode.inputs:
            if nodeInp.name.lower() == inp.lower():
                nodeInp.default_value = hairNodeData[inp]
                break

    if splineGenNode and VisualNode:
        groupInput = nodeModTree.nodes.new("NodeGroupInput")
        groupInput.location.x = -200
        groupOutput = nodeModTree.nodes.new("NodeGroupOutput")
        groupOutput.location.x = 700
        objectInfo = nodeModTree.nodes.new("GeometryNodeObjectInfo")
        objectInfo.location.x = -150
        objectInfo.location.y = -100
        objectInfo.inputs[0].default_value = scalpOb
        splineGenNode.location.x = 100
        VisualNode.location.x = 400

        nodeModTree.links.new(splineGenNode.inputs["Splines"],groupInput.outputs[0])
        nodeModTree.links.new(splineGenNode.inputs["Emitter Geometry"],objectInfo.outputs["Geometry"])
        nodeModTree.links.new(VisualNode.inputs["Splines"],splineGenNode.outputs["Splines"])
        nodeModTree.links.new(VisualNode.inputs["Emitter Geometry"],splineGenNode.outputs["Emitter Geometry"])
        nodeModTree.links.new(groupOutput.inputs[0],VisualNode.outputs["Hairs"])
        nodeModTree.links.new(objectInfo.inputs[0],groupInput.outputs[1])
        nodeModTree.inputs[1].name = "Emitter Object"
        groupInput.outputs[1].name = "Emitter Object"
        for gInp in nodMod.node_group.inputs:
            if gInp.name.lower() == "emitter object":
                nodMod[gInp.identifier] = scalpOb
        
        mat = VisualNode.inputs[14].default_value
        VisualNode.inputs[15].default_value = None
        if mat:
            mat.name = hairOb.name
        hairOb.data.materials.append(mat)
        hairOb["MedusaGroom"] = True

def createGuidCurve(hairObject,scalpOb):
    bpy.ops.object.select_all(action="DESELECT")
    bpy.context.view_layer.objects.active = scalpOb
    scalpOb.select_set(True)
    bpy.ops.object.curves_empty_hair_add(align='WORLD', scale=(1, 1, 1))
    guideOb = bpy.context.object
    for col in hairObject.users_collection:
        try:
            col.objects.link(guideOb)
        except Exception as E:
            pass
    guideOb.name  = hairObject.name.replace("_Hairs","_GuideCurves").replace("_Hair","_GuideCurves")
    if "_GuideCurves" not in guideOb.name:
        guideOb.name = guideOb.name + "_GuideCurves"

    setupGuide(hairObject,guideOb,scalpOb)
    
    return guideOb

class MedusaNodesCreateGuiCurve(bpy.types.Operator):
    bl_idname = "medusanodes.create_guide_curves"
    bl_label = "Create Guide Curves"
    bl_options = {'UNDO'}

    index : IntProperty(default=0)
    
    def execute(self, context):
        item_index = self.index
        item_list = context.scene.medusaNodesTree
        allitemsLists = context.scene.medusaNodes
        if len(item_list)>item_index:
            item = item_list[item_index]
        else:
            item = allitemsLists[item_index]
        if item.objectName in bpy.data.objects:
            if len(bpy.data.objects[item.objectName].modifiers)>0:
                geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                if geoNodes:
                    if geoNodes.type == 'NODES':
                        activeNode = geoNodes.node_group.nodes[item.name]
                        nodeLinks = geoNodes.node_group.links
                        for gInp in geoNodes.node_group.inputs:
                            if gInp.name.lower() == "emitter object" or gInp.name.lower() == "emitter geometry":
                                scalpOb = geoNodes[gInp.identifier]
                                if scalpOb:
                                    hairOb = bpy.data.objects[item.objectName]
                                    guideOb = createGuidCurve(hairOb,scalpOb)
                                    bpy.ops.object.select_all(action="DESELECT")
                                    bpy.context.view_layer.objects.active = hairOb
                                    hairOb.select_set(True)
                                    objectInfo = None
                                    for node in geoNodes.node_group.nodes:
                                        if node.type == "OBJECT_INFO" and node.name == activeNode.name+"_ObjectInfo":
                                            objectInfo = node
                                    for node in geoNodes.node_group.nodes:
                                        if node.type == "GROUP_INPUT":
                                            nodeCreated = False
                                            if objectInfo is None:
                                                nodeCreated = True
                                                objectInfo = geoNodes.node_group.nodes.new("GeometryNodeObjectInfo")
                                                objectInfo.name = activeNode.name+"_ObjectInfo"
                                                objectInfo.location.x = node.location.x
                                                objectInfo.location.y = node.location.y
                                                node.location.x = node.location.x - 200
                                                lstInd = len(node.outputs)-1
                                                nodeLinks.new(objectInfo.inputs[0],node.outputs[lstInd])
                                                geoNodes.node_group.inputs[lstInd].name = "Guide Curves"
                                                node.outputs[lstInd].name = "Guide Curves"
                                            for gInp in geoNodes.node_group.inputs:
                                                if gInp.name.lower() == "guide curves":
                                                    geoNodes[gInp.identifier] = guideOb
                                            
                                            for input in activeNode.inputs:
                                                if input.name.lower() == "guide curves":
                                                    nodeLinks.new(input,objectInfo.outputs["Geometry"])
                                                    break
                                            break
                                break
        return {'FINISHED'}

class MedusaNodesAddExsGuiCurve(bpy.types.Operator):
    bl_idname = "medusanodes.add_existing_guides"
    bl_label = "Use Existing Guides"
    bl_options = {'UNDO'}

    index : IntProperty(default=0)

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        if context.scene.medusaGuidePicker:
            for mod in context.object.modifiers:
                if mod.type == "NODES" and mod.name == "MedusaNodes":
                    item_index = self.index
                    item_list = context.scene.medusaNodesTree
                    allitemsLists = context.scene.medusaNodes
                    if len(item_list)>item_index:
                        item = item_list[item_index]
                    else:
                        item = allitemsLists[item_index]
                    activeNode = mod.node_group.nodes[item.name]
                    objectInfo = None
                    for node in mod.node_group.nodes:
                        if node.type == "OBJECT_INFO" and node.name == activeNode.name+"_ObjectInfo":
                            objectInfo = node
                    for node in mod.node_group.nodes:
                        if node.type == "GROUP_INPUT":
                            nodeCreated = False
                            if objectInfo is None:
                                nodeCreated = True
                                objectInfo = mod.node_group.nodes.new("GeometryNodeObjectInfo")
                                objectInfo.name = activeNode.name+"_ObjectInfo"
                                objectInfo.location.x = node.location.x
                                objectInfo.location.y = node.location.y
                                lstInd = len(node.outputs)-1
                                mod.node_group.links.new(objectInfo.inputs[0],node.outputs[lstInd])
                                mod.node_group.inputs[lstInd].name = "Guide Curves"
                                node.outputs[lstInd].name = "Guide Curves"
                            for gInp in mod.node_group.inputs:
                                if gInp.name.lower() == "guide curves":
                                    mod[gInp.identifier] = context.scene.medusaGuidePicker
                            
                            for input in activeNode.inputs:
                                if input.name.lower() == "guide curves":
                                    mod.node_group.links.new(input,objectInfo.outputs["Geometry"])
                                    break
                            break
                    nodesUpdate(context.scene)
                    break
        return {'FINISHED'}

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self)

    def draw(self, context):
        row = self.layout
        row.prop(context.scene,"medusaGuidePicker")

class MedusaNodesResInhGuidCurve(bpy.types.Operator):
    bl_idname = "medusanodes.inherit_guide_curves"
    bl_label = "Inherit Guide Curves"
    bl_options = {'UNDO'}

    index : IntProperty(default=0)
    
    def execute(self, context):
        item_index = self.index
        item_list = context.scene.medusaNodesTree
        item = item_list[item_index]
        if item.objectName in bpy.data.objects:
            if len(bpy.data.objects[item.objectName].modifiers)>0:
                geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                if geoNodes:
                    if geoNodes.type == 'NODES':
                        activeNode = geoNodes.node_group.nodes[item.name]
                        allNodes = followLinks(activeNode,inp=None)

                        for node in reversed(allNodes):
                            for subNode in allNodes[node]:
                                if subNode.type == "GROUP":
                                    for out in subNode.outputs:
                                        if out.name.lower() == "guide curves":
                                            geoNodes.node_group.links.new(activeNode.inputs["Guide Curves"],out)
                                            break
        return {'FINISHED'}

class MedusaNodeTreeGuidesMenu(bpy.types.Operator):
    bl_label = "Guides"
    bl_idname= "medusanodes.guides_menu"
    bl_options = {'UNDO'}

    index : IntProperty(default=0)

    enum_items = (('0','Create Guide Curves','0'),
                    ('1','Add Existing Curve','1'),
                    ('2','Inherit Guide Curves','2'))
    guideItems : bpy.props.EnumProperty(items=enum_items)
    
    def execute(self, context):
        if(int(self.guideItems)==0):
            bpy.ops.medusanodes.create_guide_curves(index=self.index)
        elif(int(self.guideItems)==1):
            bpy.ops.medusanodes.add_existing_guides("INVOKE_DEFAULT",index=self.index)
        elif(int(self.guideItems)==2):
            bpy.ops.medusanodes.inherit_guide_curves(index=self.index)
        return{'FINISHED'}

class MedusaNodesCopyInputLinks(bpy.types.Operator):
    bl_idname = "medusanodes.copy_input_links"
    bl_label = "Copy Input Link"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        print("Copy Input Link !")
        return {'FINISHED'}

class MedusaNodesPasteInputLinks(bpy.types.Operator):
    bl_idname = "medusanodes.paste_input_links"
    bl_label = "Paste Input Link"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        print("Paste Input Link !")
        return {'FINISHED'}

class MedusaNodesCopyInputNodes(bpy.types.Operator):
    bl_idname = "medusanodes.copy_input_nodes"
    bl_label = "Copy Input Nodes"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        print("Copy Input Nodes !")
        return {'FINISHED'}

class MedusaNodesPasteInputNodes(bpy.types.Operator):
    bl_idname = "medusanodes.paste_input_nodes"
    bl_label = "Paste Input Link"
    bl_options = {'UNDO'}
    
    def execute(self, context):
        print("Paste Input Link !")
        return {'FINISHED'}

class MedusaNodesCreateMatAtt(bpy.types.Operator):
    bl_idname = "medusanodes.create_material_attrr"
    bl_label = "Create Material Attribute"
    bl_options = {'UNDO'}

    def attChanged(self,context):
        global attrbData
        if len(attrbData)>0:
            atrrSocket = attrbData[1]
            geoNodes = attrbData[2]

            attrbData[0].attribute_name = self.matAtrribute
            atrrSocket.name = self.matAtrribute
            geoNodes[atrrSocket.identifier+'_attribute_name']  = self.matAtrribute

            item_index = context.scene.medusaNodesTree_index
            item_list = context.scene.medusaNodesTree
            if len(item_list)>item_index and item_index != -1:
                item = item_list[item_index]
                if item.objectName in bpy.data.objects:
                    if len(bpy.data.objects[item.objectName].modifiers)>0:
                        geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                        if geoNodes:
                            if geoNodes.type == 'NODES':
                                activeNode = geoNodes.node_group.nodes[item.name]
                                if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                    linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                    from_socket = linkSocket.from_socket
                                    from_socket["attributeName"] = self.matAtrribute
                                    from_socket["attributeOutNodeSock"] = self.matAtrribute

            attrbData = []

    matAtrribute : StringProperty(
        name="Attribute name",
        description="Attribute name",
        default = "",
        update=attChanged
    )

    def draw(self, context):
        layout = self.layout
        layout.use_property_decorate = False
        layout.label(text='Create Material Attribute')
        row = layout.row()
        row.prop(self, 'matAtrribute')
    
    def execute(self, context):
        return {'FINISHED'}
    
    def invoke(self,context,event):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            fromNode = None
                            if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                from_socket = linkSocket.from_socket
                                fromNode = linkSocket.from_node
                                
                                attriName = ""
                                if fromNode.type == "GROUP":
                                    attriName = fromNode.node_tree.name
                                else:
                                    attriName = fromNode.name

                                nodeOutput = None
                                nodeVisu   = None

                                for node in geoNodes.node_group.nodes:
                                    if node.type == "GROUP_OUTPUT":
                                        nodeOutput = node
                                    elif node.type == "GROUP":
                                        if "mn visualizer" in node.node_tree.name.lower():
                                            nodeVisu = node

                                if nodeOutput and nodeVisu:
                                    mat = nodeVisu.inputs[14].default_value
                                    if mat:
                                        y = 0
                                        for shadeNode in mat.node_tree.nodes:
                                            if shadeNode.type == "ATTRIBUTE":
                                                if attriName in shadeNode.attribute_name:
                                                    y = y + 1
                                        if y > 0:
                                            attriName = attriName + " " + str(y)
                                    try:
                                        atrrSocket = geoNodes.node_group.outputs.new(from_socket.bl_idname,attriName)
                                        geoNodes[atrrSocket.identifier+'_attribute_name'] = attriName
                                        geoNodes.node_group.links.new(from_socket,nodeOutput.inputs[-2])
                                    except:
                                        pass

                                    if mat:
                                        oldX = 0
                                        for shadeNode in mat.node_tree.nodes:
                                            if shadeNode.location.x < oldX:
                                                oldX = shadeNode.location.x
                                        attrShadeNode = mat.node_tree.nodes.new("ShaderNodeAttribute")
                                        attrShadeNode.attribute_name = attriName
                                        attrShadeNode.location.x = oldX - 150
                                    from_socket["attributeName"] = attriName
                                    from_socket["attributeShaderNode"] = attrShadeNode.name
                                    from_socket["attributeOutNodeSock"] = atrrSocket.name
                                    self.matAtrribute = attriName
                                    global attrbData
                                    attrbData.append(attrShadeNode)
                                    attrbData.append(atrrSocket)
                                    attrbData.append(geoNodes)
        
        return context.window_manager.invoke_popup(self)

class MedusaNodesRenameMatAtt(bpy.types.Operator):
    bl_idname = "medusanodes.rename_material_attrr"
    bl_label = "Rename Material Attribute"
    bl_options = {'UNDO'}

    def attChanged(self,context):
        global attrbData
        if len(attrbData)>0:
            atrrSocket = attrbData[1]
            geoNodes = attrbData[2]
            attrbData[0].attribute_name = self.matAtrribute
            atrrSocket.name = self.matAtrribute
            geoNodes[atrrSocket.identifier+'_attribute_name']  = self.matAtrribute

            item_index = context.scene.medusaNodesTree_index
            item_list = context.scene.medusaNodesTree
            if len(item_list)>item_index and item_index != -1:
                item = item_list[item_index]
                if item.objectName in bpy.data.objects:
                    if len(bpy.data.objects[item.objectName].modifiers)>0:
                        geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                        if geoNodes:
                            if geoNodes.type == 'NODES':
                                activeNode = geoNodes.node_group.nodes[item.name]
                                if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                    linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                    from_socket = linkSocket.from_socket
                                    from_socket["attributeName"] = self.matAtrribute
                                    from_socket["attributeOutNodeSock"] = self.matAtrribute
            attrbData = []

    matAtrribute : StringProperty(
        name="Attribute name",
        description="Attribute name",
        default = "",
        update=attChanged
    )

    def draw(self, context):
        layout = self.layout
        layout.use_property_decorate = False
        layout.label(text='Rename Material Attribute')
        row = layout.row()
        row.prop(self, 'matAtrribute')

    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                from_socket = linkSocket.from_socket

                                if "attributeShaderNode" in from_socket:
                                    self.matAtrribute = from_socket["attributeName"]

        return {'FINISHED'}
    
    def invoke(self,context,event):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                from_socket = linkSocket.from_socket

                                if "attributeShaderNode" in from_socket:
                                    nodeVisu   = None

                                    for node in geoNodes.node_group.nodes:
                                        if node.type == "GROUP":
                                            if "mn visualizer" in node.node_tree.name.lower():
                                                nodeVisu = node

                                    if nodeVisu:
                                        mat = nodeVisu.inputs[14].default_value
                                        if mat:
                                            self.matAtrribute = from_socket["attributeName"]
                                            global attrbData
                                            if from_socket["attributeOutNodeSock"] in geoNodes.node_group.outputs and from_socket["attributeShaderNode"] in mat.node_tree.nodes:
                                                outSocket = geoNodes.node_group.outputs[from_socket["attributeOutNodeSock"]]
                                                shaderAttrNode = mat.node_tree.nodes[from_socket["attributeShaderNode"]]
                                                attrbData.append(shaderAttrNode)
                                                attrbData.append(outSocket)
                                                attrbData.append(geoNodes)
                                    
        return context.window_manager.invoke_popup(self)

class MedusaNodesRemoveMatAtt(bpy.types.Operator):
    bl_idname = "medusanodes.remove_material_attrr"
    bl_label = "Remove Material Attribute"
    bl_options = {'UNDO'}

    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            if len(activeNode.inputs[activeNodeGroupSocket].links)>0:
                                linkSocket = activeNode.inputs[activeNodeGroupSocket].links[0]
                                from_socket = linkSocket.from_socket

                                if "attributeShaderNode" in from_socket:
                                    nodeVisu   = None

                                    for node in geoNodes.node_group.nodes:
                                        if node.type == "GROUP":
                                            if "mn visualizer" in node.node_tree.name.lower():
                                                nodeVisu = node

                                    if nodeVisu:
                                        mat = nodeVisu.inputs[14].default_value
                                        if mat:
                                            self.matAtrribute = from_socket["attributeName"]
                                            global attrbData
                                            if from_socket["attributeOutNodeSock"] in geoNodes.node_group.outputs and from_socket["attributeShaderNode"] in mat.node_tree.nodes:
                                                self.matAtrribute = from_socket["attributeName"]
                                                global attrbData
                                                outSocket = geoNodes.node_group.outputs[from_socket["attributeOutNodeSock"]]
                                                shaderAttrNode = mat.node_tree.nodes[from_socket["attributeShaderNode"]]
                                                if shaderAttrNode:
                                                    mat.node_tree.nodes.remove(shaderAttrNode)
                                                if outSocket:
                                                    geoNodes.node_group.outputs.remove(outSocket)
        return {"FINISHED"}

class medusaNodesAddInputGroup(bpy.types.Operator):
    bl_idname = "medusanodes.add_group"
    bl_label = ""
    bl_options = {'UNDO'}
    
    groupNodeName: StringProperty(default="")
    groupName : StringProperty(default="")

    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            groupNode = addMedusaNode(geoNodes.node_group,self.groupName)
                            if groupNode and activeNodeGroupSocket!="":
                                geoNodes.node_group.links.new(activeNode.inputs[activeNodeGroupSocket],groupNode.outputs[0])
                                align2Nodes(groupNode,activeNode)

                                if "curve mask group" in groupNode.node_tree.name.lower():
                                    with open(jsonProfile, 'r') as f:
                                        profileData = json.load(f)
                                    for json_key in profileData:
                                        if activeNode.node_tree.name in json_key:
                                            if activeNodeGroupSocket in profileData[json_key]:
                                                for snode in groupNode.node_tree.nodes:
                                                    if snode.type == "CURVE_FLOAT":
                                                        m = snode.mapping
                                                        while len(m.curves[0].points)>2:
                                                            p = m.curves[0].points[0]
                                                            m.curves[0].points.remove(p)
                                                        data = profileData[json_key][activeNodeGroupSocket]
                                                        if len(data) > 1:
                                                            m.curves[0].points[0].location.x = data[0][0]
                                                            m.curves[0].points[0].location.y = data[0][1]
                                                            for i in range(1,len(data)-1):
                                                                point = data[i]
                                                                p = m.curves[0].points.new(point[0],point[1])
                                                            m.curves[0].points[-1].location.x = data[-1][0]
                                                            m.curves[0].points[-1].location.y = data[-1][1]
                                                        m.update()
        return {'FINISHED'}

class MedusaNodesInvokeMaskMenu(bpy.types.Operator):
    bl_idname = "medusanodes.invokemaskmenu"
    bl_label = ""
    bl_options = {'UNDO'}

    groupNodeName : StringProperty(default="")
    groupNodeSocketName : StringProperty(default="")

    def execute(self, context):
        global activeNodeGroupName
        global activeNodeGroupSocket
        activeNodeGroupSocket = self.groupNodeSocketName
        activeNodeGroupName = self.groupNodeName
        bpy.ops.wm.call_menu(name=MedusaNodeTreeMaskGroupMenu.bl_idname)
        return {'FINISHED'}

class MedusaNodeTreeMaskGroupMenu(bpy.types.Menu):
    bl_label = "Add Masks Group"
    bl_idname= "MEDUSANODE_MT_masks_group_menu"

    def draw(self, context):
        layout = self.layout
        
        layout.label(text="Add Masks Group")
        layout.operator("medusanodes.add_group",text="Texture Mask Group").groupName = "MN Texture Mask Group"
        layout.operator("medusanodes.add_group",text="Percent Mask Group").groupName = "MN Percent Mask Group"
        layout.operator("medusanodes.add_group",text="Noise Mask Group").groupName = "MN Noise Mask Group"
        layout.operator("medusanodes.add_group",text="White Noise Mask Group").groupName = "MN White Noise Mask Group"
        layout.operator("medusanodes.add_group",text="Musgrave Mask Group").groupName = "MN Musgrave Mask Group"
        layout.operator("medusanodes.add_group",text="Magic Mask Group").groupName = "MN Magic Mask Group"
        layout.operator("medusanodes.add_group",text="Checker Mask Group").groupName = "MN Checker Mask Group"
        layout.operator("medusanodes.add_group",text="Voronoi Mask Group").groupName = "MN Voronoi Mask Group"
        layout.operator("medusanodes.add_group",text="Curve Mask Group").groupName = "MN Curve Mask Group"
        layout.operator("medusanodes.add_group",text="Random Mask Group").groupName = "MN Random Mask Group"
        #added Ramp to the menu - Irakli
        layout.operator("medusanodes.add_group",text="Ramp Mask Group").groupName = "MN Ramp Mask Group"
        # layout.separator()
        # layout.label(text="Options")
        # layout.operator("medusanodes.copy_input_links")
        # layout.operator("medusanodes.paste_input_links")
        # layout.operator("medusanodes.copy_input_nodes")
        # layout.operator("medusanodes.paste_input_nodes")
        layout.separator()
        layout.operator("medusanodes.delete_group").groupNodeName = activeNodeGroupName
        layout.operator_context = "INVOKE_DEFAULT"
        layout.operator("medusanodes.create_material_attrr")
        layout.operator_context = "INVOKE_DEFAULT"
        layout.operator("medusanodes.rename_material_attrr")
        layout.operator("medusanodes.remove_material_attrr")

class MedusaNodeTreeOptionsDupMenu(bpy.types.Menu):
    bl_label = 'Duplicate Deformer'
    bl_idname = 'MEDUSANODE_MT_duplicate_menu'

    def draw(self, context):
        layout = self.layout

        layout.operator("medusanodes.duplicate_deformer_dupli")
        layout.operator("medusanodes.duplicate_deformer_inh")

class MedusaNodeTreeOptionsMenu(bpy.types.Menu):
    bl_label = "Options"
    bl_idname= "MEDUSANODE_MT_options_menu"

    def draw(self, context):
        layout = self.layout

        # layout.operator("medusanodes.dup_deformer", icon='DUPLICATE')
        layout.menu('MEDUSANODE_MT_duplicate_menu', icon='DUPLICATE')
        layout.operator("medusanodes.reset_deformer", icon='FILE_REFRESH')
        layout.operator("medusanodes.delete_deformer", icon='TRASH')

def nameChanged(self,context):
    if self.name:
        geoNodes = bpy.data.objects[self.objectName].modifiers[self.nodeTreeName]
        node = geoNodes.node_group.nodes[self.name]
        if "mn visualizer" in node.node_tree.name.lower():
            bpy.data.objects[self.objectName].name = self.label
        else:
            node.label = self.label
        SetupNodeData()

class MedusaNodesTree(bpy.types.PropertyGroup):
    name : bpy.props.StringProperty(default="")
    label : bpy.props.StringProperty(default="")
    expanded: bpy.props.BoolProperty(default=False)
    selfIndex : bpy.props.IntProperty(default=-1)
    parentIndex : bpy.props.IntProperty(default=-1)
    childCount : bpy.props.IntProperty(default=0)
    objectName : bpy.props.StringProperty(default="")
    nodeTreeName : bpy.props.StringProperty(default="")

class MedusaNodesTreeItem(bpy.types.PropertyGroup):
    name : bpy.props.StringProperty(default="")
    label : bpy.props.StringProperty(default="",update=nameChanged)
    indent: bpy.props.IntProperty(default=0)
    expanded: bpy.props.BoolProperty(default=False)
    nodeIndex : bpy.props.IntProperty(default=-1)
    childCount: bpy.props.IntProperty(default=0)
    objectName : bpy.props.StringProperty(default="")
    nodeTreeName : bpy.props.StringProperty(default="")

def followLinks(node_in,inp=None):
    nodeHierachy = {}
    for n_inputs in node_in.inputs:
        if inp == None:
            for node_links in n_inputs.links:
                if node_links.to_node not in nodeHierachy:
                    nodeHierachy[node_links.to_node] = []
                if node_links.from_node not in nodeHierachy[node_links.to_node]:
                    nodeHierachy[node_links.to_node].append(node_links.from_node)

                nodeHierachyR = followLinks(node_links.from_node)
                nodeHierachy = {**nodeHierachy, **nodeHierachyR}
        elif n_inputs.name.lower() == inp.lower():
            for node_links in n_inputs.links:
                if node_links.to_node not in nodeHierachy:
                    nodeHierachy[node_links.to_node] = []
                if node_links.from_node not in nodeHierachy[node_links.to_node]:
                    nodeHierachy[node_links.to_node].append(node_links.from_node)
                        
                nodeHierachyR = followLinks(node_links.from_node)
                nodeHierachy = {**nodeHierachy, **nodeHierachyR}
    return nodeHierachy

def getNodeHierarchy(geoNodes):
    nodeHierachy = {}
    nodeHierachyCleaned = {}
    finalNodeHierachy = {}
    
    if geoNodes:
        if geoNodes.type == 'NODES':
            for geo_node in geoNodes.node_group.nodes:
                if geo_node.type == 'GROUP_OUTPUT':
                    nodeHierachy = followLinks(geo_node)
                    break
    pastKey = None
    for node in nodeHierachy:
        finSubNodes = []
        if node.type == "REROUTE":
            subNodes = nodeHierachy[pastKey]+nodeHierachy[node]
            for subNode in subNodes:
                if subNode.type != "REROUTE":
                    finSubNodes.append(subNode)
            nodeHierachyCleaned[pastKey] = finSubNodes
        else:
            subNodes = nodeHierachy[node]
            for subNode in subNodes:
                if subNode.type != "REROUTE":
                    finSubNodes.append(subNode)
            nodeHierachyCleaned[node] = finSubNodes
        if node.type != "REROUTE":
            pastKey = node

    for node in nodeHierachyCleaned:
        if node.type == "GROUP":
            finSubNodes = []
            for subNode in nodeHierachyCleaned[node]:
                if subNode.type == "GROUP":
                    if "mask" not in subNode.node_tree.name.lower():
                        if subNode not in finSubNodes:
                            finSubNodes.append(subNode)
            finalNodeHierachy[node] = finSubNodes
    return finalNodeHierachy

def SetupNodeData():
    global treeOldList
    global treeOldCpt
    ob = bpy.context.object
    if sculptMode and bpy.context.mode == "SCULPT_CURVES":
        ob = sculptModeLstOb
    elif paintModeLstOb and bpy.context.mode == "PAINT_TEXTURE":
        ob = paintModeLstOb
    if ob:
        if len(ob.modifiers)>0:
            geoNodes = ob.modifiers.active
            medusaNodes = bpy.context.scene.medusaNodes
            treeList = bpy.context.scene.medusaNodesTree

            if len(treeList)>treeOldCpt:
                bpy.context.scene.medusaNodesTree_index = bpy.context.scene.medusaNodesTree_index+(len(treeList)-treeOldCpt)
            bpy.context.scene.medusaNodesActiveOb = ob.name
            bpy.context.scene.medusaNodesActiveNodeTree = ""
            if geoNodes:
                for treeItem in treeList:
                    treeOldList[str(treeItem.nodeIndex)+"_"+treeItem.name+"_"+treeItem.objectName+"_"+treeItem.nodeTreeName] = [treeItem.name,treeItem.objectName,treeItem.nodeTreeName,treeItem.indent,treeItem.expanded]

                medusaNodes.clear()
                treeList.clear()
                bpy.context.scene.medusaNodesActiveNodeTree = geoNodes.node_group.name
                finalNodeHierachy = getNodeHierarchy(geoNodes)
                finalNodeHierachyF = {}

                processedNodes = []
                mainNode = None
                for node in finalNodeHierachy:
                    node["objectName"] = ob.name
                    node["nodeTreeName"] = geoNodes.name
                    if "mn visualizer" in node.node_tree.name.lower():
                        mainNode = node
                        finalNodeHierachyF[mainNode] = []
                        node["hair_object"] = ob
                    if "mn guide" in node.node_tree.name.lower() or "mn clump" in node.node_tree.name.lower() or "mn braid" in node.node_tree.name.lower():
                        finalNodeHierachyF[node] = []
                        guideCurveOb = None
                        for inp in node.inputs:
                            if inp.name.lower() == "guide curves":
                                guideHier = followLinks(node,inp=inp.name)
                                if len(guideHier)>0:
                                    firsKey = list(guideHier)[0]
                                    if guideHier[firsKey][0].type != "GROUP":
                                        lstKey = list(guideHier)[-1]
                                        if len(guideHier[lstKey])>0:
                                            if guideHier[lstKey][-1].type == "GROUP_INPUT":
                                                for gInp in geoNodes.node_group.inputs:
                                                    if gInp.name.lower() == inp.name.lower():
                                                        guideCurveOb=geoNodes[gInp.identifier]
                                                        break
                                            elif guideHier[lstKey][-1].type == "OBJECT_INFO":
                                                guideCurveOb=guideHier[lstKey][-1].inputs['Object'].default_value
                                break
                        node["guide_curve"] = guideCurveOb
                        guideCurveNodeMod = None
                        if guideCurveOb:
                            for mod in guideCurveOb.modifiers:
                                if mod.type == "NODES":
                                    for inpGuid in mod.node_group.inputs:
                                        if inpGuid.name.lower() == "emitter geometry" or inpGuid.name.lower() == "emitter object":
                                            guideCurveNodeMod = mod
                                            break
                                    break
                                if guideCurveOb == None:
                                    if "hair" in mod.name.lower() or "guide" in mod.name.lower():
                                        guideCurveNodeMod = mod
                        if guideCurveNodeMod:
                            guideNodeHierarchy = getNodeHierarchy(guideCurveNodeMod)
                            mainNodeG = None
                            guideNodeFinalHier = {}
                            for subNodeG in guideNodeHierarchy:
                                subNodeG["objectName"] = guideCurveOb.name
                                subNodeG["nodeTreeName"] = guideCurveNodeMod.name
                                if "mn visualizer" in subNodeG.node_tree.name.lower():
                                    mainNodeG = subNodeG
                                    guideNodeFinalHier[mainNodeG] = []
                                    mainNodeG["hair_object"] = guideCurveOb
                                if mainNodeG:
                                    for nodeG in guideNodeHierarchy[subNodeG]:
                                        nodeG["objectName"] = guideCurveOb.name
                                        nodeG["nodeTreeName"] = guideCurveNodeMod.name
                                        if nodeG not in guideNodeFinalHier[mainNodeG]:
                                            guideNodeFinalHier[mainNodeG].append(nodeG)
                            if mainNodeG:
                                finalNodeHierachyF[node].append(mainNodeG)
                                finalNodeHierachyF = {**finalNodeHierachyF, **guideNodeFinalHier}
                    if mainNode and node not in processedNodes:
                        for subNode in finalNodeHierachy[node]:
                            if subNode not in processedNodes:
                                subNode["objectName"] = ob.name
                                subNode["nodeTreeName"] = geoNodes.name
                                if subNode not in finalNodeHierachyF[mainNode]:
                                    finalNodeHierachyF[mainNode].append(subNode)
                                else:
                                    finalNodeHierachyF[mainNode].remove(subNode)
                                    finalNodeHierachyF[mainNode].append(subNode)
                t = 0
                j = 0
                nodesIndex = {}
                mainNodeH = None
                pareIndexGui = 0
                
                for nodeH in finalNodeHierachyF:
                    if t == 0:
                        mainNodeH = nodeH
                        nodesIndex[nodeH] = j
                        node = medusaNodes.add()
                        if "mn visualize" in nodeH.node_tree.name.lower():
                            node.label = nodeH["objectName"]
                        else:
                            if nodeH.label == "":
                                nodeH.label = nodeH.node_tree.name.replace("MN ","")
                            node.label = nodeH.label
                        node.name = nodeH.name
                        node.selfIndex = len(medusaNodes)-1
                        node.objectName = nodeH["objectName"]
                        node.nodeTreeName = nodeH["nodeTreeName"]
                        t = 1
                        j = j + 1
                        
                    for links in reversed(finalNodeHierachyF[nodeH]):
                        node = medusaNodes.add()
                        if "mn visualize" in links.node_tree.name.lower():
                            node.label = links["objectName"]
                        else:
                            if links.label == "":
                                links.label = links.node_tree.name.replace("MN ","")
                            node.label = links.label
                        node.name = links.name
                        node.selfIndex = len(medusaNodes)-1
                        node.parentIndex = nodesIndex[nodeH]
                        node.objectName = links["objectName"]
                        node.nodeTreeName = links["nodeTreeName"]
                        nodesIndex[links] = j
                        j = j + 1
                
                v = {}
                for node in medusaNodes:
                    if node.parentIndex != -1:
                        parent = medusaNodes[node.parentIndex]
                        parent.childCount = parent.childCount + 1
                    if node.parentIndex in v:
                        v[node.parentIndex].append(node.label)
                        if v[node.parentIndex].count(node.label)>1: 
                            node.label = node.label + " " + str(v[node.parentIndex].count(node.label)-1)
                    else:
                        v[node.parentIndex] = [node.label]
                
                for node in medusaNodes:
                    treSel = str(node.selfIndex)+"_"+node.name+"_"+node.objectName+"_"+node.nodeTreeName
                    if node.parentIndex == -1:
                        item = treeList.add()
                        item.label = node.label
                        item.name = node.name
                        item.nodeIndex = node.selfIndex
                        item.childCount = node.childCount
                        item.objectName   = node.objectName
                        item.nodeTreeName = node.nodeTreeName
                        
                        if treSel in treeOldList:
                            if treeOldList[treSel][4]:
                                item.expanded = True
                                for n in medusaNodes:
                                    if item.nodeIndex == n.parentIndex:
                                        InsertBeneath(treeList, item.nodeIndex, treeOldList[treSel][3], n)
                    else:
                        if treSel in treeOldList:
                            if treeOldList[treSel][4]:
                                j = 0
                                for tr in treeList:
                                    if tr.name == node.name and tr.objectName == node.objectName and tr.nodeTreeName == node.nodeTreeName:
                                        tr.expanded = True
                                        for n in medusaNodes:
                                            if node.selfIndex == n.parentIndex:
                                                InsertBeneath(treeList, j, treeOldList[treSel][3], n)
                                        break
                                    j = j + 1
            treeOldCpt = len(treeList)

def InsertBeneath( treeList, parentIndex, parentIndent, node,expand=False):
    after_index = parentIndex + 1
    existIndex = -1
    item = treeList.add()
    item.label = node.label
    item.expanded = expand
    item.name = node.name
    item.nodeIndex = node.selfIndex
    item.childCount = node.childCount
    item.objectName   = node.objectName
    item.nodeTreeName = node.nodeTreeName
    item.indent = parentIndent+1
    item_index = len(treeList) -1
    treeList.move(item_index,after_index)

class MedusaNodesTreeItem_Expand(bpy.types.Operator):
    bl_idname = "medusanodes.medusanodestree_expand"
    bl_label = "Expand"
    bl_options = {'UNDO'}
    
    button_id: IntProperty(default=-1)

    def execute(self, context):
        item_index = self.button_id
        item_list = bpy.context.scene.medusaNodesTree
        if item_index < len(item_list):
            item = item_list[item_index]
            item_indent = item.indent
            nodeIndex = item.nodeIndex
            medusaNodes = bpy.context.scene.medusaNodes
            
            if item.expanded:
                item.expanded = False
                nextIndex = item_index+1
                while True:
                    if nextIndex >= len(item_list):
                        break
                    if item_list[nextIndex].indent <= item_indent:
                        break
                    item_list.remove(nextIndex)
            else:
                item.expanded = True
                for n in medusaNodes:
                    if nodeIndex == n.parentIndex:
                        InsertBeneath(item_list, item_index, item_indent, n)
        return {'FINISHED'}

class MedusaNodesNodeProp_Expand(bpy.types.Operator):
    bl_idname = "medusanodes.nodeprop_expand"
    bl_label = "Expand"
    bl_options = {'UNDO'}
    
    objectName : StringProperty()
    nodeTreeName: StringProperty()
    nodeName: StringProperty()
    socketName: StringProperty()

    def execute(self, context):
        geoNodes = bpy.data.objects[self.objectName].modifiers[self.nodeTreeName].node_group
        socket = geoNodes.nodes[self.nodeName].inputs[self.socketName]
        if "expanded" not in socket:
            socket["expanded"] = False
        else:
            if socket["expanded"] == False:
                socket["expanded"] = True
            else:
                socket["expanded"] = False
        return {'FINISHED'}

class MedusaNodesAddTemplates(bpy.types.Operator):
    bl_idname = "medusanodes.templates"
    bl_label = "Templates"
    bl_options = {'UNDO'}
    
    action: StringProperty(default="default")
    
    def execute(self, context):
        action = self.action
        blendFile = os.path.join(assetPath, "presets.blend")
        presetNodeGroup = bpy.data.node_groups.get(action)
        if presetNodeGroup:
            bpy.data.node_groups.remove(presetNodeGroup)
        with bpy.data.libraries.load(blendFile) as (data_from, data_to):
            for group in data_from.node_groups:
                if group == action:
                    data_to.node_groups = [group]
                    break
        presetNodeGroup = bpy.data.node_groups.get(action)
        if presetNodeGroup:
            geoNodes = bpy.context.object.modifiers.active
            geoNodes.node_group = presetNodeGroup
        
        return {'FINISHED'}

class MedusaNodesDisable(bpy.types.Operator):
    bl_idname = "medusanodes.disable"
    bl_label = "Disable"
    bl_options = {'UNDO'}

    itemName: StringProperty(default="")
    objectName: StringProperty(default="")
    nodeTreeName: StringProperty(default="")

    def execute(self, context):
        geoNodes = bpy.data.objects[self.objectName].modifiers[self.nodeTreeName]
        if geoNodes:
            if geoNodes.type == 'NODES':
                for inp in geoNodes.node_group.nodes[self.itemName].inputs:
                    if inp.name.lower() == "disable":
                        inp.default_value = not inp.default_value
                        break

        return {'FINISHED'}

class MedusaNodesHide(bpy.types.Operator):
    bl_idname = "medusanodes.hide"
    bl_label = "Hide"
    bl_options = {'UNDO'}

    itemName: StringProperty(default="")
    def execute(self, context):
        ob = bpy.data.objects[self.itemName]
        ob.hide_set(not ob.hide_get())
        return {'FINISHED'}

class MedusaNodesSculptToggle(bpy.types.Operator):
    bl_idname = "medusanodes.togglesculpt"
    bl_label = "Sculpt"
    bl_options = {'UNDO'}

    itemName: StringProperty(default="")
    def execute(self, context):
        global sculptMode
        global sculptModeLstOb
        orOb = bpy.context.object
        
        if bpy.context.object.mode != "SCULPT_CURVES":
            sculptModeLstOb = orOb
            sculptMode = True
            bpy.ops.object.mode_set(mode="OBJECT")
            bpy.ops.object.select_all(action="DESELECT")
            ob = bpy.data.objects[self.itemName]
            oldVis = ob.hide_get()
            oldVie = ob.hide_viewport
            ob.hide_set(False)
            ob.hide_viewport = False

            bpy.context.view_layer.objects.active = ob
            ob.select_set(True)
            bpy.ops.object.mode_set(mode="SCULPT_CURVES",toggle=True)
            
            ob.hide_set(oldVis)
            ob.hide_viewport = oldVie
        else:
            sculptMode = False
            bpy.ops.object.mode_set(mode="OBJECT")
            bpy.ops.object.select_all(action="DESELECT")
            try:
                oldVis = sculptModeLstOb.hide_get()
                oldVie = sculptModeLstOb.hide_viewport
                try:
                    sculptModeLstOb.hide_set(False)
                    sculptModeLstOb.hide_viewport = False
                except:
                    pass
                bpy.context.view_layer.objects.active = sculptModeLstOb
                try:
                    sculptModeLstOb.select_set(True)
                    sculptModeLstOb.hide_set(oldVis)
                    sculptModeLstOb.hide_viewport = oldVie
                except:
                    pass
            except:
                pass
        return {'FINISHED'}

class MedusaNodesGuides(bpy.types.Operator):
    bl_idname = "medusanodes.guides"
    bl_label = "Guides"
    bl_options = {'UNDO'}

    itemName: StringProperty(default="")
    def execute(self, context):
        return {'FINISHED'}

addedArea = None
currentMode = None
lstObj = None

class MedusaNodesEditMaskGroup(bpy.types.Operator):
    bl_idname = "medusanodes.edit_mask_group"
    bl_label = "Edit Mask Group"
    bl_options = {'UNDO'}

    groupNodeName: StringProperty(default="")
    def execute(self, context):
        global addedArea
        global lstObj
        global currentMode

        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree

        if len(item_list)>item_index and item_index != -1:
            pass
        else:
            item_index = 0
        try:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[self.groupNodeName]
                            if activeNode.type == "GROUP":
                                if currentMode is None:
                                    currentMode = bpy.context.mode
                                    if "_" in currentMode:
                                        currentMode = "_".join(currentMode.split("_")[::-1])
                                    lstObj = bpy.context.object
                                bpy.ops.object.mode_set(mode="OBJECT", toggle=False)
                                bpy.ops.object.select_all(action="DESELECT")
                                oldVis = bpy.data.objects[item.objectName].hide_get()
                                oldVie = bpy.data.objects[item.objectName].hide_viewport
                                bpy.data.objects[item.objectName].hide_set(False)
                                bpy.data.objects[item.objectName].hide_viewport = False
                                bpy.context.view_layer.objects.active = bpy.data.objects[item.objectName]
                                bpy.data.objects[item.objectName].select_set(True)
                                deselectNodes(geoNodes)
                                geoNodes.node_group.nodes.active = activeNode
                                activeNode.select = True
                                if bpy.context.area.type == "VIEW_3D":
                                    skip = False
                                    for area in bpy.context.screen.areas:
                                        if area.type == 'NODE_EDITOR' and area.spaces[0].tree_type == 'GeometryNodeTree':
                                            skip = True
                                            break
                                    if not skip:
                                        start_areas = context.screen.areas[:]
                                        bpy.ops.screen.area_split(direction='HORIZONTAL', factor=0.3)
                                        for area in context.screen.areas:
                                            if area not in start_areas:
                                                addedArea = area
                                                addedArea.type = "NODE_EDITOR"
                                                addedArea.spaces.active.tree_type = 'GeometryNodeTree'
                                                break
                                    bpy.context.view_layer.update()
                                    bpy.ops.wm.redraw_timer(type='DRAW_WIN_SWAP', iterations=1)
                                    for area in bpy.context.screen.areas:
                                        if area.type == 'NODE_EDITOR' and area.spaces[0].tree_type == 'GeometryNodeTree':
                                            with bpy.context.temp_override(window=bpy.context.window,area=area,region=[region for region in area.regions if region.type == 'WINDOW'][0]):
                                                bpy.context.space_data.show_region_toolbar = False
                                                bpy.context.space_data.show_region_ui = False
                                                if bpy.context.active_node == activeNode or bpy.context.space_data.edit_tree != activeNode.node_tree:
                                                    try:
                                                        bpy.ops.node.tree_path_parent()
                                                    except:
                                                        pass
                                                    bpy.ops.node.group_edit()
                                                else:
                                                    try:
                                                        bpy.ops.node.tree_path_parent()
                                                    except:
                                                        pass
                                                    if bpy.context.area == addedArea:
                                                        bpy.ops.object.select_all(action="DESELECT")
                                                        bpy.context.view_layer.objects.active = lstObj
                                                        lstObj.select_set(True)
                                                        bpy.ops.object.mode_set(mode=currentMode, toggle=False)
                                                        bpy.ops.screen.area_close()
                                                        addedArea = None
                                                        currentMode = None
                                                        lstObj = None
                                            break
                                else:
                                    if bpy.context.active_node == activeNode or bpy.context.space_data.edit_tree != activeNode.node_tree:
                                        try:
                                            bpy.ops.node.tree_path_parent()
                                        except:
                                            pass
                                        bpy.ops.node.group_edit()
                                    else:
                                        try:
                                            bpy.ops.node.tree_path_parent()
                                        except:
                                            pass
                                        try:
                                            bpy.ops.object.select_all(action="DESELECT")
                                            bpy.context.view_layer.objects.active = lstObj
                                            lstObj.select_set(True)
                                            bpy.ops.object.mode_set(mode=currentMode, toggle=False)
                                        except:
                                            pass
                                        lstObj = None
                                        currentMode = None
                                deselectNodes(geoNodes)
                                try:
                                    bpy.data.objects[item.objectName].hide_set(oldVis)
                                    bpy.data.objects[item.objectName].hide_viewport = oldVie
                                except:
                                    pass
        except:
            pass
        return {'FINISHED'}

class MedusaNodesDeleteGroup(bpy.types.Operator):
    bl_idname = "medusanodes.delete_group"
    bl_label = "Delete Mask Group"
    bl_options = {'UNDO'}

    groupNodeName: StringProperty(default="")
    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[self.groupNodeName]
                            nodes = followLinks(activeNode,inp=None)
                            k = 0
                            
                            try:
                                bpy.ops.node.tree_path_parent()
                            except:
                                pass
                            
                            for node in reversed(nodes):
                                for subNode in nodes[node]:
                                    for out in subNode.outputs:
                                        if len(out.links)>1:
                                            k = 1
                                            break
                                    if k == 1:
                                        break
                                if k == 1:
                                    break
                            
                            if k == 0:
                                for node in reversed(nodes):
                                    for subNode in nodes[node]:
                                        try:
                                            geoNodes.node_group.nodes.remove(subNode)
                                        except Exception as E:
                                            pass
                                    try:
                                        geoNodes.node_group.nodes.remove(node)
                                    except Exception as E:
                                        pass
                                
                                try:
                                    geoNodes.node_group.nodes.remove(activeNode)
                                except Exception as E:
                                    pass
                            
        return {'FINISHED'}

class MedusaNodesMuteLink(bpy.types.Operator):
    bl_idname = "medusanodes.mute_link"
    bl_label = "Mute link"
    bl_options = {'UNDO'}

    socketName: StringProperty(default="")
    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if len(item_list)>item_index and item_index != -1:
            item = item_list[item_index]
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]
                            socket = activeNode.inputs[self.socketName]
                            for link in socket.links:
                                link.is_muted = not link.is_muted
                            activeNode.mute = not activeNode.mute
                            activeNode.mute = not activeNode.mute
        return {'FINISHED'}

def swapNodes(nodeLinks,nodeA,nodeB):
    nodeALinksInputs = {}
    nodeBLinksInputs = {}
    
    nodeALinksOutputs = {}
    nodeBLinksOutputs = {}
    
    for inp in nodeA.inputs:
        if inp.is_linked == True:
            nodeALinksInputs[inp.name] = {}
            nodeALinksInputs[inp.name]["inputName"] = inp
            nodeALinksInputs[inp.name]["connectedOutputs"] = []
            for link in inp.links:
                nodeALinksInputs[inp.name]["connectedOutputs"].append(link.from_socket)
    
    for out in nodeA.outputs:
        if out.is_linked == True:
            nodeALinksOutputs[out.name] = {}
            nodeALinksOutputs[out.name]["outputName"] = out
            nodeALinksOutputs[out.name]["connectedInputs"] = []
            for link in out.links:
                nodeALinksOutputs[out.name]["connectedInputs"].append(link.to_socket)
                
    for inp in nodeB.inputs:
        if inp.is_linked == True:
            nodeBLinksInputs[inp.name] = {}
            nodeBLinksInputs[inp.name]["inputName"] = inp
            nodeBLinksInputs[inp.name]["connectedOutputs"] = []
            for link in inp.links:
                nodeBLinksInputs[inp.name]["connectedOutputs"].append(link.from_socket)
    
    for out in nodeB.outputs:
        if out.is_linked == True:
            nodeBLinksOutputs[out.name] = {}
            nodeBLinksOutputs[out.name]["outputName"] = out
            nodeBLinksOutputs[out.name]["connectedInputs"] = []
            for link in out.links:
                nodeBLinksOutputs[out.name]["connectedInputs"].append(link.to_socket)
    
    
    for inp in nodeB.inputs:
        for link in inp.links:
            if link.from_node == nodeA:
                try:
                    nodeLinks.new(nodeB.outputs[inp.name],link.from_node.inputs[inp.name])
                except:
                    pass
    
    for inp in nodeALinksInputs:
        if inp in nodeBLinksInputs:
            for link in nodeALinksInputs[inp]['connectedOutputs']:
                nodeLinks.new(nodeBLinksInputs[inp]["inputName"],link)
    
    for inp in nodeALinksOutputs:
        if inp in nodeBLinksOutputs:
            for link in nodeALinksOutputs[inp]['connectedInputs']:
                if link.node != nodeBLinksOutputs[inp]["outputName"].node:
                    nodeLinks.new(nodeBLinksOutputs[inp]["outputName"],link)
                    
    for inp in nodeBLinksInputs:
        if inp in nodeALinksInputs:
            for link in nodeBLinksInputs[inp]['connectedOutputs']:
                if link.node != nodeALinksInputs[inp]["inputName"].node:
                    nodeLinks.new(nodeALinksInputs[inp]["inputName"],link)
    
    for inp in nodeBLinksOutputs:
        if inp in nodeALinksOutputs:
            for link in nodeBLinksOutputs[inp]['connectedInputs']:
                if link.node != nodeALinksOutputs[inp]["outputName"].node:
                    nodeLinks.new(nodeALinksOutputs[inp]["outputName"],link)
    
    nodeALoc = (nodeA.location[0],nodeA.location[1])
    nodeBLoc = (nodeB.location[0],nodeB.location[1])
    
    nodeB.location = nodeALoc
    nodeA.location = nodeBLoc

class MedusaNodesOrder(bpy.types.Operator):
    bl_idname = "medusanodes.switch_order"
    bl_label = "Switch order"
    bl_options = {'UNDO'}

    action: StringProperty(default="")
    def execute(self, context):
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        if item_index>=0 and len(item_list)>item_index:
            item = item_list[item_index]
            geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
            if geoNodes:
                if geoNodes.type == 'NODES':
                    activeNode = geoNodes.node_group.nodes[item.name]
                    if "mn visual" not in activeNode.node_tree.name.lower() and "mn spline" not in activeNode.node_tree.name.lower():
                        if self.action == "DOWN":
                            nextIndex = item_index + 1
                            if len(item_list)>nextIndex:
                                nextItemF = None
                                for i in range(nextIndex,len(item_list)):
                                    nextItem = item_list[i]
                                    if nextItem.nodeTreeName == item.nodeTreeName and nextItem.objectName == item.objectName:
                                        nextNode = geoNodes.node_group.nodes[nextItem.name]
                                        if "mn visual" not in nextNode.node_tree.name.lower():
                                            nextItemF = nextItem
                                            break
                                if nextItemF:
                                    if "mn spline" not in nextNode.node_tree.name.lower():
                                        nextNode = geoNodes.node_group.nodes[nextItemF.name]
                                        nodeLinks = geoNodes.node_group.links
                                        swapNodes(nodeLinks,nextNode,activeNode)
                                        SetupNodeData()
                                        bpy.context.scene.medusaNodesTree_index = bpy.context.scene.medusaNodesTree_index + 1
                        elif self.action == "UP":
                            nextIndex = item_index - 1
                            if len(item_list)>nextIndex:
                                nextItemF = None
                                for i in range(nextIndex,len(item_list)):
                                    nextItem = item_list[i]
                                    
                                    if nextItem.nodeTreeName == item.nodeTreeName and nextItem.objectName == item.objectName:
                                        nextNode = geoNodes.node_group.nodes[nextItem.name]
                                        if "mn visual" not in nextNode.node_tree.name.lower():
                                            nextItemF = nextItem
                                            break
                                if nextItemF:
                                    nextNode = geoNodes.node_group.nodes[nextItemF.name]
                                    nodeLinks = geoNodes.node_group.links
                                    swapNodes(nodeLinks,activeNode,nextNode)
                                    SetupNodeData()
                                    bpy.context.scene.medusaNodesTree_index = bpy.context.scene.medusaNodesTree_index - 1
        return {'FINISHED'}

class MEDUSANODES_UL_TreeItem(bpy.types.UIList):
    def draw_item(self, context, layout, data, item, icon, active_data, active_propname, index):
        scene = data
        if self.layout_type in {'DEFAULT', 'COMPACT'}:
            for i in range(item.indent):
                split = layout.split(factor = 0.1)
            col = layout.column()
            
            if item.childCount == 0:
                op = col.operator("medusanodes.medusanodestree_expand", text="", icon='DOT', emboss=False)
                op.button_id = index
                col.enabled = False
            elif item.expanded:
                op = col.operator("medusanodes.medusanodestree_expand", text="", icon='TRIA_DOWN', emboss=False)
                op.button_id = index
            else:
                op = col.operator("medusanodes.medusanodestree_expand", text="", icon='TRIA_RIGHT', emboss=False)
                op.button_id = index
            col = layout.column()
            col.prop(item, "label", emboss=False, text="")
            
            col = layout.column()
            grid = col.row(align=True)
            if item.objectName in bpy.data.objects:
                if len(bpy.data.objects[item.objectName].modifiers)>0:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            activeNode = geoNodes.node_group.nodes[item.name]

                            if "mn visual" in activeNode.node_tree.name.lower():
                                ob = bpy.data.objects[item.objectName]
                                grid.operator("medusanodes.togglesculpt", text="", icon='SCULPTMODE_HLT', emboss=False, depress=False).itemName = item.objectName
                                if ob.hide_get():
                                    grid.operator("medusanodes.hide", text="", icon='HIDE_ON', emboss=False, depress=False).itemName = item.objectName
                                else:
                                    grid.operator("medusanodes.hide", text="", icon='HIDE_OFF', emboss=False, depress=False).itemName = item.objectName
                            
                            if "mn clump" in activeNode.node_tree.name.lower() or "mn guide" in activeNode.node_tree.name.lower() or "mn braid" in activeNode.node_tree.name.lower():
                                grid.separator()
                                grid.operator_menu_enum(MedusaNodeTreeGuidesMenu.bl_idname, 'guideItems', text="",icon='ADD').index = index
                                grid.label(text="", icon='BLANK1')

                            if "mn visual" in activeNode.node_tree.name.lower():
                                if bpy.data.objects[item.objectName].hide_viewport:
                                    grid.operator("medusanodes.hide_viewport", icon='RESTRICT_VIEW_ON', text="", emboss=False, depress=False).objectName = item.objectName
                                else:
                                    grid.operator("medusanodes.hide_viewport", icon='RESTRICT_VIEW_OFF', text="", emboss=False, depress=False).objectName = item.objectName
                            else:
                                for inp in activeNode.inputs:
                                    if inp.name.lower() == "disable":
                                        if inp.default_value:
                                            op = grid.operator("medusanodes.disable", text="", icon='RESTRICT_VIEW_ON', emboss=False, depress=False)
                                            op.itemName = item.name
                                            op.objectName = item.objectName
                                            op.nodeTreeName = item.nodeTreeName
                                        else:
                                            op = grid.operator("medusanodes.disable", text="", icon='RESTRICT_VIEW_OFF', emboss=False, depress=False)
                                            op.itemName = item.name
                                            op.objectName = item.objectName
                                            op.nodeTreeName = item.nodeTreeName
                                        break

class SCENE_PT_MedusaNodesMain(bpy.types.Panel):
    bl_label = "Medusa Nodes"
    bl_idname = "SCENE_PT_medusanodes_main"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"

    # @classmethod
    # def poll(cls, context):
    #     snode = context.space_data
    #     return snode.tree_type == 'GeometryNodeTree'
    
    def draw(self ,context):
        layout = self.layout
        layout.template_icon(icon_value=pcoll["medusa_nodes_logo"].icon_id,scale = 2)
        row = layout.row(align=True)
        row.operator("medusanodes.main_new_groom", icon="STRANDS")
        row = layout.row(align=True)
        row.operator("medusanodes.main_dup_groom", icon="DUPLICATE")
        row = layout.row(align=True)
        row.operator("medusanodes.main_del_groom", icon="TRASH")

class SCENE_PT_MedusaNodesMain_Viewport(SCENE_PT_MedusaNodesMain):
    bl_label = "Medusa Nodes"
    bl_idname = "SCENE_PT_medusanodes_main_view"
    bl_space_type = 'VIEW_3D'

class MedusaNodesMainNewGroomFunc(bpy.types.Operator):
    bl_idname = "medusanodes.main_new_groom_func"
    bl_label = "Create Groom"
    bl_options = {'UNDO'}

    groomName : StringProperty(default="",
        name="",
        description="Groom to duplicate Name")
    partName : StringProperty(default="",
        name="",
        description="Part to duplicate Name")
    seed : IntProperty(default=0,
        name="Seed",
        description="Generator seed")
    controlPointsCount : IntProperty(default=16,
        name="Control Points Count",
        description="Generator control points count")
    density : FloatProperty(default=100,
        name="Density",
        description="Generator density")
    
    x: bpy.props.IntProperty()
    y: bpy.props.IntProperty()

    def invoke(self, context, event):
        self.x = event.mouse_x
        self.y = event.mouse_y
        return self.execute(context)

    def execute(self, context):
        hairNodeData = {"Seed":self.seed,"Control Points Count":self.controlPointsCount,"Density":self.density}
        newGroomName = self.groomName
        newGroomPartName = self.partName
        if newGroomPartName == "":
            newGroomPartName = "Part01"
        if len(context.object.data.uv_layers)==0:
            context.object.data.uv_layers.new(name="surface_uv_coordinate")
        else:
            context.object.data.uv_layers[0].name ="surface_uv_coordinate"
        scalpOb = context.object
        groomCol = None

        partIndex = 0

        for ob in bpy.data.objects:
            if ob.type == "CURVES":
                if newGroomName in ob.name:
                    nameParts = ob.name.split("_")
                    if len(nameParts)>1:
                        if newGroomName == nameParts[0]:
                            namePrt = nameParts[1]
                            if newGroomPartName in namePrt.lower():
                                namePrtI = namePrt.lower().replace(newGroomPartName,"")
                                if int(namePrtI)>partIndex:
                                    partIndex = int(namePrtI)
        if partIndex != 0:
            partStrInde = str(partIndex+1).zfill(2)
            if partStrInde not in newGroomPartName and not newGroomPartName[-2:].isdigit():
                newGroomPartName = newGroomPartName+partStrInde

        for col in bpy.data.collections:
            if col.name == newGroomName:
                groomCol = col
                break
        if groomCol == None:
            groomCol = bpy.data.collections.new(name=newGroomName)
            bpy.context.scene.collection.children.link(groomCol)
        bpy.ops.object.select_all(action="DESELECT")
        bpy.context.view_layer.objects.active = scalpOb
        scalpOb.select_set(True)
        newGroomName = groomCol.name
        bpy.ops.object.curves_empty_hair_add(align='WORLD', scale=(1, 1, 1))
        hairOb = bpy.context.object
        try:
            groomCol.objects.link(hairOb)
        except:pass

        hairOb.name  = newGroomName + "_" + newGroomPartName + "_Hair"
        setupHairOb(hairOb,scalpOb,hairNodeData)
        bpy.context.window.cursor_warp(self.x, self.y-100)
        return {'FINISHED'}

class MedusaNodesMainNewGroom(bpy.types.Operator):
    bl_idname = "medusanodes.main_new_groom"
    bl_label = "New Groom"
    bl_options = {'UNDO'}

    seed : IntProperty(default=0,
        name="Seed",
        description="Generator seed")
    controlPointsCount : IntProperty(default=16,
        name="Control Points Count",
        description="Generator control points count")
    density : FloatProperty(default=1000,
        name="Density",
        description="Generator density")

    def draw(self, context):
        layout = self.layout
        layout.use_property_decorate = False
        layout.label(text='New Groom')
        row = layout.row()
        layout.label(text='Groom Name')
        row = layout.row()
        row.prop(context.scene, 'newGroomName')
        row = layout.row()
        layout.label(text='Groom Part')
        row = layout.row()
        row.prop(context.scene, 'newGroomPartName')
        row = layout.row()
        layout.label(text='Groom Data')
        row = layout.row()
        row.prop(self, 'seed')
        row = layout.row()
        row.prop(self, 'controlPointsCount')
        row = layout.row()
        row.prop(self, 'density')
        row = layout.row()
        op = row.operator("medusanodes.main_new_groom_func")
        op.groomName = context.scene.newGroomName
        op.partName = context.scene.newGroomPartName
        op.seed = self.seed
        op.controlPointsCount = self.controlPointsCount
        op.density = self.density

    def execute(self, context):
        return {'FINISHED'}
    
    def invoke(self,context,event):
        if context.object:
            if context.object.type == "MESH":
                context.scene.render.hair_type = 'STRIP'
                context.scene.render.hair_subdiv = 2
                return context.window_manager.invoke_popup(self)
            else:
                self.report({'WARNING'}, 'Select the mesh object first!')
                return {'FINISHED'}
        else:
            self.report({'WARNING'}, 'Select the mesh object first!')
            return {'FINISHED'}

def copyColl_objects(from_col, to_col, linked, dupe_lut):
    for o in from_col.objects:
        dupe = o.copy()
        if not linked and o.data:
            dupe.data = dupe.data.copy()
        dupe.name = o.name.replace(from_col.name,to_col.name)
        to_col.objects.link(dupe)
        dupe_lut[o] = dupe
        bpy.context.view_layer.objects.active = dupe
        dupe.select_set(True)

def copyColl(parent, collection, linked=False):
    dupe_lut = defaultdict(lambda : None)
    
    bpy.ops.object.select_all(action="DESELECT")
    def _copy(parent, collection, linked=False):
        copyColl_objects(collection, parent, linked, dupe_lut)
        for c in collection.children:
            _copy(parent, c, linked)

    _copy(parent, collection, linked)
    for o, dupe in tuple(dupe_lut.items()):
        parent = dupe_lut[o.parent]
        if parent:
            dupe.parent = parent

class MedusaNodesMainDuplGroomFunc(bpy.types.Operator):
    bl_idname = "medusanodes.main_dup_groom_func"
    bl_label = "Duplicate Groom"
    bl_options = {'UNDO'}

    groomToDuplicate : StringProperty(default="",
        name="",
        description="Groom to duplicate Name")
    partToDuplicate : StringProperty(default="",
        name="",
        description="Part to duplicate Name")
    duplOnlyGroom : BoolProperty(default=False,
        name="Duplicate Only Groom Part",
        description="Duplicate Only Groom Part")
    newGroomName : StringProperty(default="Groom02",
        name="",
        description="New Name of the duplicated groom")
    newPartName : StringProperty(default="Part02",
        name="",
        description="New Name of the duplicated part")

    def execute(self, context):
        col = bpy.data.collections.get(self.groomToDuplicate)
        if col:
            if not self.duplOnlyGroom and self.newGroomName != "":
                newCol = bpy.data.collections.new(name=self.newGroomName)
                bpy.context.scene.collection.children.link(newCol)
                # newCol.name = self.newGroomName
                copyColl(newCol, col)
                mainGroomHairs = []
                groomGuides = []
                for ob in newCol.objects:
                    if "MedusaGroom" in ob:
                        mainGroomHairs.append(ob)
                    elif ob.type == "CURVES":
                        if "guidecurves" in ob.name.lower():
                            groomGuides.append(ob)
                
                for guide in groomGuides:
                    groomName = guide.name.split("_")[0]
                    for groom in mainGroomHairs:
                        if groomName in groom.name:
                            for mod in groom.modifiers:
                                if mod.type == "NODES" and mod.name == "MedusaNodes":
                                    for gInp in mod.node_group.inputs:
                                        if gInp.name.lower() == "guide curves":
                                            mod[gInp.identifier] = guide
                                    break
                            break
            elif self.partToDuplicate != "":
                for o in col.objects:
                    if self.partToDuplicate in o.name.rsplit('_')[1] and self.groomToDuplicate in o.name:
                        dupe = o.copy()
                        dupe.data = dupe.data.copy()
                        cleanName = o.name.replace(self.partToDuplicate,self.newPartName)
                        dupe.name = cleanName
                        col.objects.link(dupe)
                        break
        else:
            self.report({'WARNING'}, 'No groom named "'+ self.groomToDuplicate +'" has been found! Enter the groom name you would like to duplicate!')
            return {'FINISHED'} 

        return {'FINISHED'}

def sceneGroomsItems(self, context):
    Grooms = []
    for ob in bpy.data.objects:
        if ob.type == "CURVES":
            if "MedusaGroom" in ob:
                groomName = ob.name.split("_")[0]
                groomItem = (groomName,groomName,'')
                if groomItem not in Grooms:
                    Grooms.append(groomItem)
    return Grooms

def sceneGroomsPartItems(self, context):
    Parts = []
    for ob in bpy.data.objects:
        if ob.type == "CURVES":
            if "MedusaGroom" in ob:
                partName = ob.name.split("_")[1]
                partItem = (partName,partName,'')
                if partItem not in Parts:
                    Parts.append(partItem)
    return Parts


class MedusaNodesMainDuplGroom(bpy.types.Operator):
    bl_idname = "medusanodes.main_dup_groom"
    bl_label = "Duplicate Groom"
    bl_options = {'UNDO'}

    groomsToDup : EnumProperty(name="",
        description= "List of grooms to duplicate",
        items=sceneGroomsItems)
    newGroomName : StringProperty(default="Groom02",
        name="",
        description="New Name of the duplicated groom")
    duplOnlyGroom : BoolProperty(default=False,
        name="Duplicate Only Groom Part",
        description="Duplicate Only Groom Part")
    partsToDup : EnumProperty(name="",
        description= "List of parts to duplicate",
        items=sceneGroomsPartItems)
    newPartName : StringProperty(default="Part02",
        name="",
        description="New Name of the duplicated part")

    def draw(self, context):
        layout = self.layout
        layout.use_property_decorate = False
        layout.label(text='Duplicate Groom')

        col = layout.column()
        row = col.row()
        row.label(text="Choose Groom To Duplicate")
        row.label(text="New Groom Name")
        col = layout.column()
        row = col.row()
        row.prop(self, 'groomsToDup')
        row.prop(self, 'newGroomName')

        t = False
        if self.duplOnlyGroom:
            t = True
        row = layout.row()
        row.prop(self, 'duplOnlyGroom')

        col = layout.column()
        row = col.row()
        row.label(text="Choose Part To Duplicate")
        row.label(text="New Part Name")
        col = layout.column()
        row = col.row()
        row.prop(self, 'partsToDup')
        row.prop(self, 'newPartName')
        row.enabled = t
        row = layout.row()
        op = row.operator("medusanodes.main_dup_groom_func")
        op.groomToDuplicate = self.groomsToDup
        op.partToDuplicate = self.partsToDup
        op.newGroomName = self.newGroomName
        op.newPartName = self.newPartName
        op.duplOnlyGroom = self.duplOnlyGroom

    def execute(self, context):
        return {'FINISHED'}
    
    def invoke(self,context,event):
        return context.window_manager.invoke_popup(self)

class MedusaNodesMainDelGroom(bpy.types.Operator):
    bl_idname = "medusanodes.main_del_groom"
    bl_label = "Delete Groom"
    bl_options = {'UNDO'}

    def execute(self, context):
        ob = bpy.context.object
        if bpy.context.object:
            if "_Hair" in ob.name or "_GuideCurves" in ob.name:
                objScene = bpy.data.objects
                cleanName = ob.name.replace("_Hairs","").replace("_Hair","").replace("_GuideCurves","")
                for o in objScene:
                    if "_Hair" in o.name or "_GuideCurves" in o.name:
                        if cleanName in o.name:
                            cols = o.users_collection
                            bpy.data.objects.remove(o)
                            for col in cols:
                                if len(col.objects) == 0:
                                    bpy.data.collections.remove(col)
        return {'FINISHED'}

class MedusaNodesPaintMode(bpy.types.Operator):
    bl_idname = "medusanodes.paint_mode"
    bl_label = "paint mode"
    bl_options = {'UNDO'}

    socketName: StringProperty(default="")
    groupNodeName: StringProperty(default="")

    def execute(self, context):
        global paintModeLstOb
        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        item = item_list[item_index]  
        if item.objectName in bpy.data.objects:
            if len(bpy.data.objects[item.objectName].modifiers)>0:
                geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                if geoNodes:
                    if geoNodes.type == 'NODES':
                        activeNode = geoNodes.node_group.nodes[self.groupNodeName]
                        for gInp in geoNodes.node_group.inputs:
                            if gInp.name.lower() == "emitter object" or gInp.name.lower() == "emitter geometry":
                                scalpOb = geoNodes[gInp.identifier]
                                break
        if bpy.context.object.mode == "TEXTURE_PAINT":
            bpy.ops.object.mode_set(mode="TEXTURE_PAINT",toggle=True)
            if paintModeLstOb:
                oldVis = paintModeLstOb.hide_get()
                oldVie = paintModeLstOb.hide_viewport
                paintModeLstOb.hide_set(False)
                paintModeLstOb.hide_viewport = False

                paintModeLstOb.select_set(True)
                bpy.context.view_layer.objects.active = paintModeLstOb

                paintModeLstOb.hide_set(oldVis)
                paintModeLstOb.hide_viewport = oldVie
                scalpOb["hairOb"] = paintModeLstOb.name
                scalpOb["paintMode"] = False
        else:
            paintModeLstOb = bpy.context.object
            if scalpOb:
                scalpOb["hairOb"] = paintModeLstOb.name
                scalpOb["paintMode"] = True
                oldVis = scalpOb.hide_get()
                oldVie = scalpOb.hide_viewport
                scalpOb.hide_set(False)
                scalpOb.hide_viewport = False
                scalpOb.select_set(True)
                bpy.context.view_layer.objects.active = scalpOb
                bpy.ops.object.mode_set(mode="TEXTURE_PAINT",toggle=True)
                bpy.context.scene.tool_settings.image_paint.mode = "IMAGE"
                bpy.context.scene.tool_settings.image_paint.canvas = activeNode.inputs[self.socketName].default_value
                scalpOb.hide_set(oldVis)
                scalpOb.hide_viewport = oldVie
        return {'FINISHED'}

class MedusaNodesHideViewport(bpy.types.Operator):
    bl_idname = "medusanodes.hide_viewport"
    bl_label = "Hide/Show viewport"
    bl_options = {'UNDO'}

    objectName: StringProperty(default="")

    def execute(self, context):
        ob = bpy.data.objects.get(self.objectName)
        if ob:
            ob.hide_viewport = not ob.hide_viewport
        return {'FINISHED'}

class SCENE_PT_MedusaNodesMainRigging(bpy.types.Panel):
    bl_label = "Rigging"
    bl_idname = "SCENE_PT_medusanodes_mainrigging"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"
    bl_parent_id = "SCENE_PT_medusanodes_main"
    bl_options = {"DEFAULT_CLOSED"}

    @classmethod
    def poll(cls, context):
        snode = context.space_data
        return snode.tree_type == 'GeometryNodeTree'
    
    def draw(self ,context):
        pass

class SCENE_PT_MedusaNodesMainRiggingView(SCENE_PT_MedusaNodesMainRigging):
    bl_idname = "SCENE_PT_medusanodes_mainrigging_view"
    bl_space_type = 'VIEW_3D'
    bl_parent_id = "SCENE_PT_medusanodes_hierarchy_vie"

class SCENE_PT_MedusaNodesMainRenVie_curves(bpy.types.Panel):
    bl_label = "Curves"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"
    bl_parent_id = "SCENE_PT_medusanodes_mainrenvie"
    bl_options = {'DEFAULT_CLOSED'}
    COMPAT_ENGINES = {'CYCLES'}

    @classmethod
    def poll(cls, context):
        return context.engine in cls.COMPAT_ENGINES

    def draw(self, context):
        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        scene = context.scene
        ccscene = scene.cycles_curves

        col = layout.column()
        col.prop(ccscene, "shape", text="Shape")
        if ccscene.shape == 'RIBBONS':
            col.prop(ccscene, "subdivisions", text="Curve Subdivisions")

class SCENE_PT_MedusaNodesMainRenVie_curvesView(SCENE_PT_MedusaNodesMainRenVie_curves):
    bl_space_type = 'VIEW_3D'
    bl_parent_id = "SCENE_PT_medusanodes_mainrenvie_view"

class SCENE_PT_MedusaNodesMainRenVie_viewport_display(bpy.types.Panel):
    bl_label = "Viewport Display"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"
    bl_parent_id = "SCENE_PT_medusanodes_mainrenvie"
    bl_options = {'DEFAULT_CLOSED'}

    def draw(self, context):
        draw_curves_settings(self, context)

class SCENE_PT_MedusaNodesMainRenVie_viewport_displayView(SCENE_PT_MedusaNodesMainRenVie_viewport_display):
    bl_space_type = 'VIEW_3D'
    bl_parent_id = "SCENE_PT_medusanodes_mainrenvie_view"

class SCENE_PT_MedusaNodesMainRenVie(bpy.types.Panel):
    bl_label = "Viewport & Rendering"
    bl_idname = "SCENE_PT_medusanodes_mainrenvie"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"
    bl_parent_id = "SCENE_PT_medusanodes_main"
    bl_options = {"DEFAULT_CLOSED"}

    # @classmethod
    # def poll(cls, context):
    #     snode = context.space_data
    #     return snode.tree_type == 'GeometryNodeTree'
    
    def draw(self ,context):
        pass

class SCENE_PT_MedusaNodesMainRenVieView(SCENE_PT_MedusaNodesMainRenVie):
    bl_idname = "SCENE_PT_medusanodes_mainrenvie_view"
    bl_space_type = 'VIEW_3D'
    bl_parent_id = "SCENE_PT_medusanodes_main_view"

class RENDER_PG_bn_image_settings(bpy.types.PropertyGroup):

    items = [('PNG', 'PNG', ""),
            ('JPEG', 'JPEG', ""),
            ('TARGA', 'TGA', ""),
            ('TIFF', 'TIF', ""),
            ('DPX', 'DPX', ""),
            ('BMP', 'BMP', ""),
            ('OPEN_EXR', 'OpenEXR', ""),
            ('OPEN_EXR_MULTILAYER', 'OpenEXR MultiLayer', ""),
    ]

    file_format: EnumProperty(
        name="Image format",
        description="Choose which file format that images are saved to ",
        items=items,
        default="PNG"
        )


    exr_codec_items = [
            ('DWAA', 'DWAA (lossy)', ""),
            ('ZIPS', 'ZIPS (Lossless)', ""),
            ('RLE', 'RLE (Lossless', ""),
            ('PIZ', 'PIZ (Lossless', ""),
            ('ZIP', 'ZIP (Lossless', ""),
            ('PXR24', 'Pxr24 (lossy)', ""),
    ]

    exr_codec: EnumProperty(
    name="Exr codec",
    description="Compression mode for EXR",
    items=exr_codec_items,
    default = 'ZIP'
    )

    tiff_codec_items = [
            ('PACKBITS', 'Pack bits', ""),
            ('LZW', 'LZW', ""),
            ('DEFLATE', 'DEFLATE', ""),
            ('NONE', 'None', ""),
    ]

    tiff_codec: EnumProperty(
    name="Tiff codec",
    description="Compression mode for TIFF",
    items=tiff_codec_items,
    default = 'LZW'
    )

    jpeg2000_codec_items = [
            ('JP2', 'JP2', ""),
            ('J2K', 'J2K', ""),
    ]
    
    jpeg2k_codec: EnumProperty(
    name="JPEG 2000 codec",
    description="Compression mode for JPEG 2000",
    items=jpeg2000_codec_items
    )

    def item_callback(self, context):
        if self.file_format in ['BMP', 'JPEG', 'CINEON', 'HDR', 'AVI_JPEG', 'AVI_RAW', 'FFMPEG']:
            return [
                ('RGB', 'RGB', ''),
                ('BW', 'BW', '')
            ]
        else:
            return [
                ('RGB', 'RGB', ''),
                ('RGBA', 'RGBA', ''),
                ('BW', 'BW', ''),
            ]



    color_mode: EnumProperty(
    name="Color",
    description= "Choose BW for saving grayscale images, \
        RGB for saving red, green and blue channels, \
        and RGB for saving red, green, blue and alpha channels",
    items=item_callback,

    )   

    def item_callback(self, context):
        if self.file_format in ['BMP', 'IRIS', 'JPEG', 'TARGA', 'TARGA_RAW', 'AVI_JPEG', 'AVI_RAW', 'FFMPEG']:
            return [('8', '8', "")
                ]
        elif self.file_format in ['PNG', 'TIFF', ]:
            return [('16', '16', ""),
                ('8', '8', "")
                ]
        elif  self.file_format in ['CINEON',]:
            return [('10', '10', "")]
        elif self.file_format in ['OPEN_EXR_MULTILAYER', 'OPEN_EXR', ]:
            return [('16', '16', ""),
                ('32', '32', "")
                ]
        elif self.file_format in ['EXR']:
            return [('32', '32', "")
            ]
        elif self.file_format in ['DPX']:
            return [('8', '8', ""),
                ('10', '10', ""),
                ('12', '12', ""),
                ('16', '16', "")
                ]
        else:
            return [('16', '16', ""),
                    ('8', '8', ""),
                    ('32', '32', "")
                ]
                

    color_depth: EnumProperty(
        name="Color depth",
        description= "Bit depth per channel",
        items=item_callback,
    )     
    
    compression: IntProperty(
    name="Compression",
    description= "Amount of time to determine best compression: "\
        "0= no compression with fast file output, \
        100 = maximum lossless compression with slow file output",
    subtype = 'PERCENTAGE',
    min = 0,
    max = 100,
    default = 15
    )

    quality: IntProperty(
    name="Compression",
    description= "Quality for image formats that support lossy compression",
    subtype = 'PERCENTAGE',
    min = 0,
    max = 100,
    default = 90
    ) 

fstT = 0
def updateTexOptions():
    global fstT
    medusaNodesSaveOptions = bpy.context.scene.medusaNodesSaveOptions

    import inspect
    frm = inspect.stack()[1]
    mod = inspect.getmodule(frm[0])
    name = mod.__name__
    package = mod.__package__

    pref = bpy.context.preferences.addons[package].preferences
    if pref is not None:
        if fstT == 0:
            medusaNodesSaveOptions.autoTexBak = pref.autoTexBak
            medusaNodesSaveOptions.useAltTexPath = pref.useAltTexPath
            medusaNodesSaveOptions.texPath = pref.texPath
            medusaNodesSaveOptions.image_settings.file_format = pref.image_settings.file_format
            medusaNodesSaveOptions.image_settings.color_mode = pref.image_settings.color_mode
            medusaNodesSaveOptions.image_settings.color_depth = pref.image_settings.color_depth
            medusaNodesSaveOptions.image_settings.compression = pref.image_settings.compression
            medusaNodesSaveOptions.image_settings.quality = pref.image_settings.quality
            medusaNodesSaveOptions.image_settings.tiff_codec = pref.image_settings.tiff_codec
            medusaNodesSaveOptions.image_settings.exr_codec = pref.image_settings.exr_codec
            fstT = 1

class MedusaNodesSaveOptions(PropertyGroup):
    autoTexBak: BoolProperty(
        name="Automatic Texture Backup",
        description="Automatic Texture Backup",
        default = False)
    useAltTexPath: BoolProperty(
        name="Use Alternative Texture Path",
        description="Use Alternative Texture Path",
        default = False)
    texPath: StringProperty(
        name="",
        description="",
        default = "")
    image_settings: bpy.props.PointerProperty(type = RENDER_PG_bn_image_settings)

class SCENE_PT_MedusaNodesSaveOptions(bpy.types.Panel):
    bl_label = "Medusa Nodes"
    bl_idname = "SCENE_PT_medusaNodessaveoptions"
    bl_space_type = 'FILE_BROWSER'
    bl_region_type = 'TOOL_PROPS'
    bl_category = "Medusa Nodes"
    # bl_options = {"HIDE_HEADER"}

    @classmethod
    def poll(cls, context):
        return True

    def draw(self, context):
        layout = self.layout
        medusaNodesSaveOptions = bpy.context.scene.medusaNodesSaveOptions
        row = layout.row()
        row.prop(medusaNodesSaveOptions,"autoTexBak")

        txt = 'Note: By default textures connected to the groom will be saved in "textures" folder next to the .blend file.'
        chars = int(context.region.width / 7)
        wrapper = textwrap.TextWrapper(width=chars)
        box = layout.box()
        box.alignment = 'EXPAND'
        text_lines = wrapper.wrap(text=txt)
        for text_line in text_lines:
            row = box.row(align = True)
            row.label(text=text_line)
        row = layout.row()
        row.prop(medusaNodesSaveOptions,"useAltTexPath")

        row = layout.row()
        row.enabled = False
        if medusaNodesSaveOptions.useAltTexPath:
            row.enabled = True
        row.prop(medusaNodesSaveOptions,"texPath")

class SCENE_PT_MedusaNodesSaveOptionsIS(bpy.types.Panel):
    bl_label = "Image file settings"
    bl_idname = "SCENE_PT_medusaNodessaveoptionsis"
    bl_space_type = 'FILE_BROWSER'
    bl_region_type = 'TOOL_PROPS'
    bl_category = "Medusa Nodes"
    bl_parent_id = 'SCENE_PT_medusaNodessaveoptions'

    @classmethod
    def poll(cls, context):
        return True

    def draw(self, context):
        layout = self.layout
        col = layout.column()
        medusaNodesSaveOptions = bpy.context.scene.medusaNodesSaveOptions
        image_settings = medusaNodesSaveOptions.image_settings

        grid = col.grid_flow(row_major = True, columns = 2,)

        grid.label(text='File Format')
        grid.prop(image_settings, "file_format", text = "")

        grid.label(text='Color')
        grid.prop(image_settings, "color_mode", text = "")

        grid.label(text='Color Depth')
        grid.prop(image_settings, "color_depth", text = "")


        if image_settings.file_format in ['PNG']:
            grid.label(text='Compression')
            grid.prop(image_settings, "compression", text = "") 

        if image_settings.file_format in ['JPEG', 'JPEG2000', 'AVI_JPEG']:
            grid.label(text='Quality')
            grid.prop(image_settings, "quality", text = "")

        if image_settings.file_format in ['TIFF']:
            grid.label(text='Compression')
            grid.prop(image_settings, "tiff_codec", text = "") 

        if image_settings.file_format in ['OPEN_EXR', 'OPEN_EXR_MULTILAYER']:
            grid.label(text='Compression')
            grid.prop(image_settings, "exr_codec", text = "")

activeNodeGroupName = ""
activeNodeObjectName = ""
activeNodeTreeGroupName = ""

class SCENE_PT_MedusaNodesHierarchy(bpy.types.Panel):
    bl_label = "Medusa Nodes Hierarchy"
    bl_idname = "SCENE_PT_medusanodes_hierarchy"
    bl_space_type = 'NODE_EDITOR'
    bl_region_type = "UI"
    bl_category = "Medusa Nodes"

    def draw(self, context):
        global activeNodeGroupName
        global activeNodeObjectName
        global activeNodeTreeGroupName
        scn = context.scene
        layout = self.layout
        col = layout.row(align=True)

        item_index = context.scene.medusaNodesTree_index
        item_list = context.scene.medusaNodesTree
        # pcoll = preview_collections["main"]
        # col.operator("medusanodes.templates", icon_value=pcoll["temp1"].icon_id, text="").action = 'preset1'
        # col.operator("medusanodes.templates", icon_value=pcoll["temp2"].icon_id, text="").action = 'preset2'
        # col.operator("medusanodes.templates", icon_value=pcoll["temp3"].icon_id, text="").action = 'preset3'
        # col.operator("medusanodes.templates", icon_value=pcoll["temp4"].icon_id, text="").action = 'preset4'
        # col.operator("medusanodes.templates", icon_value=pcoll["temp5"].icon_id, text="").action = 'preset5'

        row = layout.row()
        row.template_list(
            "MEDUSANODES_UL_TreeItem",
            "",
            scn,
            "medusaNodesTree",
            scn,
            "medusaNodesTree_index",
            sort_reverse=False, sort_lock=False,
            rows=5
            )
        
        col = row.column(align=True)
        col.menu("MEDUSANODE_MT_deformers_menu", icon='ADD', text="")
        col.operator("medusanodes.delete_deformer", icon='REMOVE', text="")
        col.separator()
        col.menu("MEDUSANODE_MT_options_menu", icon='DOWNARROW_HLT', text="")
        col.separator()
        
        col.operator("medusanodes.switch_order", icon='TRIA_UP', text="").action = 'UP'
        col.operator("medusanodes.switch_order", icon='TRIA_DOWN', text="").action = 'DOWN'

        col = layout.row(align=True)
        
        if item_index>=0:# and len(item_list)>item_index:
            try:
                item = None
                if len(item_list)>item_index:
                    medusaNodes = context.scene.medusaNodesTree
                    item = medusaNodes[item_index]
                    activeNodeGroupName = item.name
                    activeNodeObjectName = item.objectName
                    activeNodeTreeGroupName = item.nodeTreeName
                else:
                    for barNode in context.scene.medusaNodes:
                        if barNode.name == activeNodeGroupName and barNode.nodeTreeName == activeNodeTreeGroupName and barNode.objectName == activeNodeObjectName:
                            item = barNode
                            break
                if item:
                    geoNodes = bpy.data.objects[item.objectName].modifiers[item.nodeTreeName]
                    inpTypes = ["VALUE","INT","BOOLEAN","RGBA"]
                    if geoNodes:
                        if geoNodes.type == 'NODES':
                            if item.name in geoNodes.node_group.nodes:
                                node_ref = geoNodes.node_group.nodes[item.name]
                                layout.context_pointer_set("node", node_ref)

                                if hasattr(node_ref, "draw_buttons_ext"):
                                    node_ref.draw_buttons_ext(context, layout)
                                elif hasattr(node_ref, "draw_buttons"):
                                    node_ref.draw_buttons(context, layout)

                                value_inputs = [socket for socket in node_ref.inputs if self.show_socket_input(socket)]
                                
                                if value_inputs:
                                    layout.separator()
                                    for socket in value_inputs:
                                        if socket.name.lower() != "disable":
                                            fromNode = None
                                            for link in geoNodes.node_group.links:
                                                if link.to_node == node_ref:
                                                    if link.to_socket == socket and socket.type in inpTypes:
                                                        fromNode = link.from_node
                                                        break
                                            if fromNode:
                                                floatCurvesNodes = {}
                                                
                                                if fromNode.type == "GROUP":
                                                    for snode in fromNode.node_tree.nodes:
                                                        if snode.type == "CURVE_FLOAT":
                                                            floatCurvesNodes[snode.label] = snode
                                                        elif snode.type == "VALTORGB":
                                                            floatCurvesNodes[snode.label] = snode
                                                value_inputs_from = [socketF for socketF in fromNode.inputs if self.show_socket_input(socketF)]
                                                
                                                row = layout.row()
                                                
                                                if "expanded" not in socket:
                                                    op = row.operator("medusanodes.nodeprop_expand", text="", icon='TRIA_RIGHT', emboss=False)
                                                else:
                                                    if not socket["expanded"]:
                                                        op = row.operator("medusanodes.nodeprop_expand", text="", icon='TRIA_RIGHT', emboss=False)
                                                    else:
                                                        op = row.operator("medusanodes.nodeprop_expand", text="", icon='TRIA_DOWN', emboss=False)
                                                op.objectName= item.objectName
                                                op.nodeTreeName  = item.nodeTreeName
                                                op.nodeName  = node_ref.name
                                                op.socketName = socket.name
                                                
                                                if socket.links[0].is_muted:
                                                    socket.draw(
                                                        context,
                                                        row,
                                                        node_ref,
                                                        iface_(socket.label if socket.label else socket.name, socket.bl_rna.translation_context),
                                                    )
                                                else:
                                                    row.label(text=socket.name)
                                                # row.menu("MEDUSANODE_MT_masks_group_menu", icon='PLUGIN', text="")
                                                op = row.operator("medusanodes.invokemaskmenu", icon='PLUGIN', text="")
                                                op.groupNodeSocketName = socket.name
                                                op.groupNodeName = fromNode.name
                                                row.scale_x=1.2
                                                row.scale_y=1.2
                                                if "expanded" in socket:
                                                    if socket["expanded"]:
                                                        box = layout.box()
                                                        row = box.row(align=True)
                                                        row.label(text="  "+fromNode.node_tree.name)
                                                        
                                                        if socket.links[0].is_muted:
                                                            row.operator("medusanodes.mute_link", icon='RESTRICT_VIEW_ON', text="").socketName = socket.name
                                                        else:
                                                            row.operator("medusanodes.mute_link", icon='RESTRICT_VIEW_OFF', text="").socketName = socket.name
                                                        
                                                        row.operator("medusanodes.edit_mask_group", icon='NODETREE', text="").groupNodeName = fromNode.name
                                                        row.operator("medusanodes.delete_group", icon='TRASH', text="").groupNodeName = fromNode.name
                                                        row.scale_x=1.2
                                                        row.scale_y=1.2

                                                        l = 0
                                                        for sub_socket in value_inputs_from:
                                                            if sub_socket.name.lower() != "disable" and socket.type in inpTypes:
                                                                if str(l+1) in floatCurvesNodes:
                                                                    boxV = box.box()
                                                                    if socket.links[0].is_muted:
                                                                        boxV.enabled = False
                                                                    else:
                                                                        boxV.enabled = True
                                                                    floatCurvesNode = floatCurvesNodes[str(l+1)]
                                                                    value_inputs_from = [socketF for socketF in floatCurvesNode.inputs if self.show_socket_input(socketF)]
                                                                    if hasattr(floatCurvesNode, "draw_buttons_ext"):
                                                                        floatCurvesNode.draw_buttons_ext(context, boxV)
                                                                    elif hasattr(floatCurvesNode, "draw_buttons"):
                                                                        floatCurvesNode.draw_buttons(context, boxV)
                                                                
                                                                row = box.row()
                                                                if socket.links[0].is_muted:
                                                                    row.enabled = False
                                                                else:
                                                                    row.enabled = True
                                                                sub_socket.draw(
                                                                    context,
                                                                    row,
                                                                    fromNode,
                                                                    iface_(sub_socket.label if sub_socket.label else sub_socket.name, sub_socket.bl_rna.translation_context),
                                                                )
                                                                if sub_socket.type == "IMAGE":
                                                                    row = row.row()
                                                                    row.scale_x=1.1
                                                                    row.scale_y=1.1
                                                                    paintOp = row.operator("medusanodes.paint_mode", icon='BRUSH_DATA', text="")
                                                                    paintOp.groupNodeName = fromNode.name
                                                                    paintOp.socketName = sub_socket.name
                                                                    if sub_socket.default_value == None:
                                                                        row.enabled = False
                                                                    
                                                            l = l + 1
                                                        for index in floatCurvesNodes:
                                                            if index.isdigit():
                                                                if int(index) > l:
                                                                    boxV = box.box()
                                                                    if socket.links[0].is_muted:
                                                                        boxV.enabled = False
                                                                    else:
                                                                        boxV.enabled = True
                                                                    floatCurvesNode = floatCurvesNodes[index]
                                                                    value_inputs_from = [socketF for socketF in floatCurvesNode.inputs if self.show_socket_input(socketF)]
                                                                    if hasattr(floatCurvesNode, "draw_buttons_ext"):
                                                                        floatCurvesNode.draw_buttons_ext(context, boxV)
                                                                    elif hasattr(floatCurvesNode, "draw_buttons"):
                                                                        floatCurvesNode.draw_buttons(context, boxV)
                                                        
                                                        row = box.row()
                                            elif socket.is_linked == False:
                                                row = layout.row()
                                                socket.draw(
                                                    context,
                                                    row,
                                                    node_ref,
                                                    iface_(socket.label if socket.label else socket.name, socket.bl_rna.translation_context),
                                                )
                                                if socket.type in inpTypes and socket.type != "BOOLEAN":
                                                    op = row.operator("medusanodes.invokemaskmenu", icon='PLUGIN', text="")
                                                    op.groupNodeSocketName = socket.name
                                                    row.scale_x=1.2
                                                    row.scale_y=1.2
                
            except Exception as E:
                print(E)
    def show_socket_input(self, socket):
        return hasattr(socket, 'draw') and socket.enabled

class SCENE_PT_MedusaNodesHierarchy_Viewport(SCENE_PT_MedusaNodesHierarchy):
    bl_idname = "SCENE_PT_medusanodes_hierarchy_vie"
    bl_space_type = 'VIEW_3D'

def prefOnChange(self,context):
    medusaNodesSaveOptions = bpy.context.scene.medusaNodesSaveOptions
    medusaNodesSaveOptions.autoTexBak = self.autoTexBak
    medusaNodesSaveOptions.useAltTexPath = self.useAltTexPath
    medusaNodesSaveOptions.texPath = self.texPath
    medusaNodesSaveOptions.image_settings.file_format = self.image_settings.file_format
    medusaNodesSaveOptions.image_settings.color_mode = self.image_settings.color_mode
    medusaNodesSaveOptions.image_settings.color_depth = self.image_settings.color_depth
    medusaNodesSaveOptions.image_settings.compression = self.image_settings.compression
    medusaNodesSaveOptions.image_settings.quality = self.image_settings.quality
    medusaNodesSaveOptions.image_settings.tiff_codec = self.image_settings.tiff_codec
    medusaNodesSaveOptions.image_settings.exr_codec = self.image_settings.exr_codec

class SCENE_PT_MedusaNodesPrefs(bpy.types.AddonPreferences):
    bl_idname = __package__

    autoTexBak: BoolProperty(
        name="Automatic Texture Backup",
        description="Automatic Texture Backup",
        default = False,
        update=prefOnChange)

    useAltTexPath: BoolProperty(
        name="Use Alternative Texture Path",
        description="Use Alternative Texture Path",
        default = False,
        update=prefOnChange)

    texPath: StringProperty(
        name="",
        description="",
        default = "",
        update=prefOnChange)

    image_settings: bpy.props.PointerProperty(type = RENDER_PG_bn_image_settings,update=prefOnChange)


    # addon updater preferences from `__init__`, be sure to copy all of them
    auto_check_update: bpy.props.BoolProperty(
        name = "Auto-check for Update",
        description = "If enabled, auto-check for updates using an interval",
        default = False,
    )

    updater_interval_months: bpy.props.IntProperty(
        name='Months',
        description = "Number of months between checking for updates",
        default=0,
        min=0
    )
    updater_interval_days: bpy.props.IntProperty(
        name='Days',
        description = "Number of days between checking for updates",
        default=7,
        min=0,
    )
    updater_interval_hours: bpy.props.IntProperty(
        name='Hours',
        description = "Number of hours between checking for updates",
        default=0,
        min=0,
        max=23
    )
    updater_interval_minutes: bpy.props.IntProperty(
        name='Minutes',
        description = "Number of minutes between checking for updates",
        default=0,
        min=0,
        max=59
    )

    def draw(self, context):
        layout = self.layout
        row = layout.row()
        row.prop(self,"autoTexBak")

        txt = 'Note: By default textures connected to the groom will be saved in "textures" folder next to the .blend file.'
        chars = int(context.region.width / 6) 
        wrapper = textwrap.TextWrapper(width=chars)
        box = layout.box()
        box.alignment = 'EXPAND'
        text_lines = wrapper.wrap(text=txt)
        for text_line in text_lines:
            row = box.row(align = True)
            row.label(text=text_line)
        row = layout.row()
        row.prop(self,"useAltTexPath")

        row = layout.row()
        row.enabled = False
        if self.useAltTexPath:
            row.enabled = True
        row.prop(self,"texPath")

        col = layout.column()
        image_settings = self.image_settings

        grid = col.grid_flow(row_major = True, columns = 2,)
        grid.label(text='File Format')
        grid.prop(image_settings, "file_format", text = "")
        grid.label(text='Color')
        grid.prop(image_settings, "color_mode", text = "")
        grid.label(text='Color Depth')
        grid.prop(image_settings, "color_depth", text = "")
        if image_settings.file_format in ['PNG']:
            grid.label(text='Compression')
            grid.prop(image_settings, "compression", text = "") 
        if image_settings.file_format in ['JPEG', 'JPEG2000', 'AVI_JPEG']:
            grid.label(text='Quality')
            grid.prop(image_settings, "quality", text = "")
        if image_settings.file_format in ['TIFF']:
            grid.label(text='Compression')
            grid.prop(image_settings, "tiff_codec", text = "") 
        if image_settings.file_format in ['OPEN_EXR', 'OPEN_EXR_MULTILAYER']:
            grid.label(text='Compression')
            grid.prop(image_settings, "exr_codec", text = "")
        # #Auto-updater
        addon_updater_ops.update_settings_ui(self,context)

@persistent
def nodesUpdate(scene):
    global sculptMode
    try:
        if fstT == 0:
            updateTexOptions()
        obj = bpy.context.object
        if obj and sculptMode == False:
            # if obj.select_get():
                if len(obj.modifiers)>0:
                    geoNodes = obj.modifiers.active
                    if geoNodes == None:
                        medusaNodes = bpy.context.scene.medusaNodes
                        treeList = bpy.context.scene.medusaNodesTree
                        medusaNodes.clear()
                        treeList.clear()
                    elif scene.medusaNodesActiveOb!=obj.name:
                        SetupNodeData()
                    elif geoNodes:
                        if geoNodes.type == 'NODES':
                            # if scene.medusaNodesActiveNodeTree!=geoNodes.node_group.name:
                            #     SetupNodeData()
                            SetupNodeData()
                else:
                    if "hairOb" in obj:
                        if obj["paintMode"] == False:
                            medusaNodes = bpy.context.scene.medusaNodes
                            treeList = bpy.context.scene.medusaNodesTree
                            medusaNodes.clear()
                            treeList.clear()
                    else:
                        medusaNodes = bpy.context.scene.medusaNodes
                        treeList = bpy.context.scene.medusaNodesTree
                        medusaNodes.clear()
                        treeList.clear()
            # else:
            #     medusaNodes = bpy.context.scene.medusaNodes
            #     treeList = bpy.context.scene.medusaNodesTree
            #     medusaNodes.clear()
            #     treeList.clear()
        elif sculptMode == False:
            medusaNodes = bpy.context.scene.medusaNodes
            treeList = bpy.context.scene.medusaNodesTree
            medusaNodes.clear()
            treeList.clear()
        
        if obj and sculptMode:
            if obj.mode != "SCULPT_CURVES":
                sculptMode = False
    except Exception as E:
        print("################")
        print(E)

global manSave
manSave = 0

@persistent
def blendFileSaved(scene):
    global manSave
    if manSave == 0:
        medusaNodesSaveOptions = bpy.context.scene.medusaNodesSaveOptions
        objectsToProcess = []

        format = bpy.context.scene.render.image_settings.file_format
        colorMode = bpy.context.scene.render.image_settings.color_mode
        depth = bpy.context.scene.render.image_settings.color_depth
        compr = bpy.context.scene.render.image_settings.compression
        quali = bpy.context.scene.render.image_settings.quality
        tiffCodec = bpy.context.scene.render.image_settings.tiff_codec
        exrCodec = bpy.context.scene.render.image_settings.exr_codec

        bpy.context.scene.render.image_settings.file_format = medusaNodesSaveOptions.image_settings.file_format
        bpy.context.scene.render.image_settings.color_mode = medusaNodesSaveOptions.image_settings.color_mode
        bpy.context.scene.render.image_settings.color_depth = medusaNodesSaveOptions.image_settings.color_depth
        bpy.context.scene.render.image_settings.compression = medusaNodesSaveOptions.image_settings.compression
        bpy.context.scene.render.image_settings.quality = medusaNodesSaveOptions.image_settings.quality
        bpy.context.scene.render.image_settings.tiff_codec = medusaNodesSaveOptions.image_settings.tiff_codec
        bpy.context.scene.render.image_settings.exr_codec = medusaNodesSaveOptions.image_settings.exr_codec

        extensio = bpy.context.scene.render.file_extension
        for ob in bpy.data.objects:
            if len(ob.modifiers)>0:
                for mod in ob.modifiers:
                    if mod.type == "NODES":
                        for node in mod.node_group.nodes:
                            if node.type == "GROUP":
                                if "mn" in node.node_tree.name.lower():
                                    if ob not in objectsToProcess:
                                        objectsToProcess.append(ob)
                                    break
        
        if not medusaNodesSaveOptions.useAltTexPath:
            texturePath = os.path.join(bpy.path.abspath("//"),"textures","Medusa Nodes")
        else:
            texturePath = os.path.join(bpy.path.abspath(medusaNodesSaveOptions.texPath),"textures","Medusa Nodes")
        os.makedirs(texturePath,exist_ok=True)
        
        
        createBackup = False
        if medusaNodesSaveOptions.autoTexBak:
            for ob in bpy.data.objects:
                if len(ob.modifiers)>0:
                    for mod in ob.modifiers:
                        if mod.type == "NODES":
                            for node in mod.node_group.nodes:
                                for inp in node.inputs:
                                    if inp.type == "IMAGE":
                                        im = inp.default_value
                                        if im.is_dirty:
                                            createBackup = True
                                            break
        
        if medusaNodesSaveOptions.autoTexBak and createBackup:
            for ob in objectsToProcess:
                if len(ob.modifiers)>0:
                    for mod in ob.modifiers:
                        if mod.type == "NODES":
                            name = ob.name.split("_")
                            if len(name)>2:
                                date = datetime.datetime.now().strftime("_%Y.%m.%d_%H-%M")
                                groomPath = os.path.join(texturePath,"backup",name[0]+date)
                                partPath = os.path.join(groomPath,name[1])
                                os.makedirs(partPath,exist_ok=True)
                                for node in mod.node_group.nodes:
                                    for inp in node.inputs:
                                        if inp.type == "IMAGE":
                                            im = inp.default_value
                                            if im.has_data:
                                                fileName = os.path.basename(im.filepath)
                                                if fileName == "":
                                                    fileName = im.name
                                                if im.packed_file:
                                                    im.unpack(method='USE_LOCAL')
                                                if extensio not in fileName.lower():
                                                    fileName = fileName + extensio
                                                
                                                im.filepath_raw =os.path.join(partPath,fileName)
                                                im.save()
                                                #im.save_render(os.path.join(partPath,fileName)) #this saves the color management as well, which is not ideal
                                                im.filepath = os.path.join(partPath,fileName)
                                                im.source = 'FILE'

        else:
            for ob in objectsToProcess:
                if len(ob.modifiers)>0:
                    for mod in ob.modifiers:
                        if mod.type == "NODES":
                            name = ob.name.split("_")
                            if len(name)>2:
                                groomPath = os.path.join(texturePath,name[0])
                                partPath = os.path.join(groomPath,name[1])
                                os.makedirs(partPath,exist_ok=True)
                                for node in mod.node_group.nodes:
                                    for inp in node.inputs:
                                        if inp.type == "IMAGE":
                                            im = inp.default_value
                                            if im:
                                                if im.has_data:
                                                    fileName = os.path.basename(im.filepath)
                                                    if fileName == "":
                                                        fileName = im.name
                                                    if im.packed_file:
                                                        im.unpack(method='USE_LOCAL')
                                                    if extensio not in fileName.lower():
                                                        fileName = fileName + extensio

                                                    im.filepath_raw = os.path.join(partPath,fileName)
                                                    im.save()
                                                    #im.save_render(os.path.join(partPath,fileName)) #this saves the color management as well, which is not ideal
                                                    im.filepath = os.path.join(partPath,fileName)
                                                    im.source = 'FILE'
                                                    

        bpy.context.scene.render.image_settings.file_format = format
        bpy.context.scene.render.image_settings.color_mode = colorMode
        bpy.context.scene.render.image_settings.color_depth = depth
        bpy.context.scene.render.image_settings.compression = compr
        bpy.context.scene.render.image_settings.quality = quali
        bpy.context.scene.render.image_settings.tiff_codec = tiffCodec
        bpy.context.scene.render.image_settings.exr_codec = exrCodec
        
        if manSave == 0:
            manSave = 1
            bpy.ops.wm.save_mainfile()
    else:
        manSave = 0
