local sdk = sdk;
local json = json;
local re = re;
local imgui = imgui;
-- Config
local config = json.load_file("AutoFreeSide.json") or {RemoveDelay = true, AutoReceive = false};
if config.RemoveDelay == nil then
    config.RemoveDelay = true;
end
if config.AutoReceive == nil then
    config.AutoReceive = false;
end
-- Main
local TRUE_POINTER = sdk.to_ptr(1);
local isOpenRewardWindow = nil;

local function PreHook_doOpen(args)
    if config.RemoveDelay then
        local GuiSideQuestOrder = sdk.to_managed_object(args[2]);
        if GuiSideQuestOrder then
            GuiSideQuestOrder:set_field("StampDelayTime", 0.0);
            GuiSideQuestOrder:set_field("DecideDelay", 0.0);
        end
    end
    if config.AutoReceive then
        isOpenRewardWindow = nil;
    end
end

local function PostHook_getReaward()
    if config.AutoReceive then
        isOpenRewardWindow = true;
    end
end

local function PostHook_DecideTrg(retval)
    if isOpenRewardWindow then
        isOpenRewardWindow = nil;
        return TRUE_POINTER;
    end
    return retval;
end

sdk.hook(sdk.find_type_definition("snow.gui.GuiSideQuestOrder"):get_method("doOpen"), PreHook_doOpen);
sdk.hook(sdk.find_type_definition("snow.gui.fsm.questcounter.GuiQuestCounterFsmFreeSideQuestCheckAction"):get_method("getReaward(snow.quest.FreeMissionData, snow.quest.FreeMissionWork)"), nil, PostHook_getReaward);
sdk.hook(sdk.find_type_definition("snow.gui.StmGuiInput"):get_method("getDecideButtonTrg(snow.StmInputConfig.KeyConfigType, System.Boolean)"), nil, PostHook_DecideTrg);
--
local function SaveSettings()
    json.dump_file("AutoFreeSide.json", config);
end

re.on_config_save(SaveSettings);
re.on_draw_ui(function()
    if imgui.tree_node("AutoFreeSide") then
        local changed = false;
		changed, config.RemoveDelay = imgui.checkbox("Remove delay", config.RemoveDelay);
        changed, config.AutoReceive = imgui.checkbox("Auto receive", config.AutoReceive);
        if changed then
            SaveSettings();
        end
		imgui.tree_pop();
	end
end);