local sdk = sdk;
-- Cache
local ResetState_None = sdk.find_type_definition("snow.camera.PlayerCamera.ResetState"):get_field("None"):get_data(nil);
local get_MarionetteCameraType_method = sdk.find_type_definition("snow.CameraManager"):get_method("get_MarionetteCameraType"); -- retval
local MarionetteCameraType_type_def = get_MarionetteCameraType_method:get_return_type();
local NotResetTypes = {
	[MarionetteCameraType_type_def:get_field("GetOff"):get_data(nil)] = true,
	[MarionetteCameraType_type_def:get_field("GetOffTryAgainInput"):get_data(nil)] = true,
	[MarionetteCameraType_type_def:get_field("GetOffFreeRun"):get_data(nil)] = true
};
-- Main
local FALSE_POINTER = sdk.to_ptr(ResetState_None);

local function SkipReset(retval)
	if (sdk.to_int64(retval) & 0xFFFFFFFF) ~= ResetState_None then
		local CameraManager = sdk.get_managed_singleton("snow.CameraManager");
		if CameraManager then
			local MarionetteCameraType = get_MarionetteCameraType_method:call(CameraManager);
			if MarionetteCameraType ~= nil and NotResetTypes[MarionetteCameraType] then
				return FALSE_POINTER;
			end
		end
	end
	return retval;
end
-- Hook
sdk.hook(sdk.find_type_definition("snow.camera.TargetCamera_Marionette"):get_method("UpdateCameraReset(via.GameObject)"), nil, SkipReset);