-- sell_non_qurious_talisman.lua : written by archwizard1204
-- Only on NexusMods, my profile page: https://www.nexusmods.com/users/154089548
-- version: 1.0

local modUI = require("ModOptionsMenu.ModMenuApi");
local equipDataManager = nil

local name = "Sell Non Qurious Talisman";
local description = "<COL RED>Make sure you made a backup before using!</COL>";

function sell()

    local dataManager = sdk.get_managed_singleton("snow.data.DataManager")
    local equipBox = dataManager._PlEquipBox
    local inventoryList = equipBox:get_field("_WeaponArmorInventoryList")
    local count = 0

    for i = 0, inventoryList:call("get_Count") - 1 do
        local equipment = inventoryList:call("get_Item", i)
        if equipment._IdType == 3 then
            if equipment:call("findMatchedAlchemyPatturn") < 10 then
                if not equipment._IsLock and
                   equipment:call("canSell") and
                   not equipment:call("isEquiped") and
                   not equipment:call("isAttachedDeco") then
                    equipBox:call("sellEquipment", equipment)

                    count = count + 1
                end
            end
        end
    end

    return count
end

re.on_draw_ui(function()
    if imgui.tree_node(name) then
        if imgui.button("Sell") then
            sell()
        end
        imgui.tree_pop()
    end
end)

local modObj = modUI.OnMenu(name, description, function()
	
    modUI.Header(name)

    if modUI.Button('Sell', '', false, description) then
        local number = sell()
	    modUI.PromptMsg("Sold " .. number .. " talismans.");
    end

end)