﻿<%@ Page Language="c#" CodeBehind="Course.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Admin.Course"
    Title="课程设置-系统" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1 {
            color: #FF0000;
        }
    </style>
</head>
<body>
    <!--#include file="../include/modal.htm"-->

    <form id="Form1" method="post" runat="server">
        <div class="kuai-list">
            <uc1:Ann ID="Ann1" runat="server" />


            <div class=" control_bg">

                <ul class="mt-listitems">
                    <li>课程名称：</li>
                    <li>
                        <asp:TextBox ID="tbxCourseName" runat="server"></asp:TextBox></li>
                    <li>单位：</li>
                    <li>
                        <asp:DropDownList ID="ddlUnit" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlUnit_SelectedIndexChanged">
                            <asp:ListItem Value="1">课时</asp:ListItem>
                            <asp:ListItem Value="2">学期</asp:ListItem>
                            <asp:ListItem Value="2.2">月</asp:ListItem>
                            <asp:ListItem Value="2.1">年</asp:ListItem>
                            <asp:ListItem Value="2.3">季</asp:ListItem>
                            <asp:ListItem Value="2.4">周</asp:ListItem>
                            <asp:ListItem Value="2.5">天</asp:ListItem>

                        </asp:DropDownList></li>
                    <li>
                        <asp:Label ID="labUnitPrice" runat="server" Text="价格："></asp:Label></li>
                    <li><%=swq.CurrentCurrencySymbol %></li>
                    <li>
                        <asp:TextBox ID="tbxUnitPrice" runat="server" Width="65px"></asp:TextBox></li>
                    <li>每课时：</li>
                    <li>
                        <asp:TextBox ID="tbxLessonMinute" runat="server" Width="55px"></asp:TextBox></li>
                    <li>分钟</li>
                    <li>分类：</li>
                    <li>
                        <asp:DropDownList ID="ddlCourseType" runat="server" DataSource="<%# swq.Cache.Fill(swq.Cache.GetCourseType(),Rs.Strings.请选择) %>"
                            DataValueField="CourseTypeID" DataTextField="CourseTypeName">
                        </asp:DropDownList></li>
                    <li>
                        <div title="增加课程分类" data-toggle="tooltip" class="glyphicon glyphicon-edit btn btn-default" data-url="../admin/coursetype.aspx" data-action="kcbind" onclick="openweb(this)"></div>
                    </li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" Text="增加" CssClass="btn btn-default" OnClick="btnAdd_Click"></asp:Button></li>

                    <li>
                        <div title="批处导入课程" data-toggle="tooltip" class="btn btn-default" data-url="../admin/importcourse.aspx" data-action="sxbind" onclick="openweb(this)">批处导入课程</div>
                    </li>
                </ul>
            </div>

            <div class=" listwidthauto">
                <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                    DataKeyNames="CourseID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                    OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                    OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                    <Columns>
                        <asp:BoundField DataField="CourseID" ReadOnly="True" HeaderText="编号" />
                        <asp:BoundField DataField="CourseName" HeaderText="课程名称" />
                        <asp:TemplateField HeaderText="价格(默认)">
                            <ItemTemplate>
                                <asp:HyperLink ID="hlkUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:c2}")%>'
                                    NavigateUrl='<%# string.Format("CoursePrice.aspx?CourseID={0}&GetURL={1}",Eval("CourseID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox ID="tbxUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:f2}")%>'></asp:TextBox>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="单位">
                            <ItemTemplate>
                                <%# Eval("UnitName")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:DropDownList ID="ddlUnit" runat="server">
                                    <asp:ListItem Value="1">课时</asp:ListItem>
                                    <asp:ListItem Value="2">学期</asp:ListItem>
                                    <asp:ListItem Value="2.1">月</asp:ListItem>
                                    <asp:ListItem Value="2.2">年</asp:ListItem>
                                    <asp:ListItem Value="2.3">季</asp:ListItem>
                                    <asp:ListItem Value="2.4">天</asp:ListItem>
                                    <asp:ListItem Value="2.5">周</asp:ListItem>
                                </asp:DropDownList>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="分钟/课时">
                            <ItemTemplate>
                                <%# Eval("LessonMinute")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox ID="tbxLessonMinute" runat="server" Width="60px" Text='<%# Eval("LessonMinute")%>'></asp:TextBox>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="分类">
                            <ItemTemplate>
                                <asp:Label ID="labCourseTypeName" runat="server" Text='<%# Eval("CourseTypeName")%>'></asp:Label>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:DropDownList ID="ddlCourseType" runat="server" DataSource="<%# swq.Cache.GetCourseType() %>"
                                    DataValueField="CourseTypeID" DataTextField="CourseTypeName">
                                </asp:DropDownList>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                    <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                                    <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                                </asp:DropDownList>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="排序">
                            <ItemTemplate>
                                <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                                <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="子价格">
                            <ItemTemplate>
                                <div class="lab_button_sub" id="divSubPrice" runat="server">
                                    <asp:HyperLink ID="hlkSubPrice" runat="server" Text='子价格' CssClass="btn btn-default"
                                        NavigateUrl='<%# string.Format("CoursePrice.aspx?CourseID={0}&GetURL={1}",Eval("CourseID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                </div>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="编辑">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CssClass="btn btn-default" CommandName="Edit"></asp:LinkButton>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CssClass="btn btn-default" CommandName="Update"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CssClass="btn btn-default" CommandName="Cancel"></asp:LinkButton>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="删除">
                            <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CssClass="btn btn-default" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
            </div>

            <div class="control_bg">
                <ul class="mt-listitems">
                    <li>课程名称：</li>
                    <li>
                        <asp:TextBox ID="tbxFCourseName" runat="server"></asp:TextBox></li>
                    <li>
                        <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" Text="查找" OnClick="btnSearch_Click" /></li>
                    <li style="display: none">
                        <input type="button" value="课程组合优惠设置" class="btn btn-default" data-url="../admin/discountstrate.aspx" data-action="disbind" onclick="openweb(this)" /></li>
                </ul>
            </div>

        </div>



        <div class="mt-back">
            <input causesvalidation="false" type="button" class="btn btn-default" runat="server" onclick="back(this)" value="返回" />
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、<span class="style1">点击【子价格】可设置同一课程在不同校区的价格。</span><br />
            2、以“<b>课时</b>”为单位销售的课程，是一种高精度、按量量化方式。<br />
            3、以“<strong>学期、年、月</strong>”等为单位销售的课程，是一种灵活性强，按时间的量化方式。<br />
        </div>
    </form>
</body>
</html>
