﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CoursePrice.aspx.cs" Inherits="MTCUN.Admin.CoursePrice"
    Title="课程价格-系统" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1 {
            color: #FF0000;
        }
    </style>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    
    <form id="Form1" method="post" runat="server">
        <div class="kuai-list">
            <div class=" control_bg">

                <ul class="mt-listitems">
                    <li>课程：</li>
                    <li>
                        <asp:Label ID="labCourseName" runat="server" Font-Bold="True"></asp:Label></li>
                    <li>单位：</li>
                    <li>
                        <asp:Label ID="labUnitName" runat="server" Font-Bold="True"></asp:Label></li>
                    <li>默认价：</li>
                    <li>
                        <asp:Label ID="labUnitPrice" runat="server" Font-Bold="True"></asp:Label></li>
                </ul>

                <ul class="mt-listitems">
                    <li>子价格名称：</li>
                    <li>
                        <asp:TextBox ID="tbxCoursePriceName" runat="server" Width="90px"></asp:TextBox></li>
                    <li>校区：</li>
                    <li>
                        <asp:DropDownList ID="ddlSchool" runat="server"
                            DataValueField="SchoolID" DataTextField="SchoolName">
                        </asp:DropDownList></li>
                    <li>金额：</li>
                    <li>
                        <asp:TextBox ID="tbxUnitPrice" runat="server" Width="90px"></asp:TextBox></li>
                    <li>数量范围：</li>
                    <li>
                        <asp:TextBox ID="tbxStart" runat="server" Width="57px"></asp:TextBox>
                    </li>
                    <li>-</li>
                    <li>
                        <asp:TextBox ID="tbxEnd" runat="server" Width="57px"></asp:TextBox></li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" Text="增加" CssClass="btn btn-default" OnClick="btnAdd_Click"></asp:Button></li>
                </ul>
            </div>
            <div style="width: auto; margin-left: 0px">
                <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                    DataKeyNames="CoursePriceID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
                    OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
                    OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound"
                    EnableModelValidation="True">
                    <Columns>
                        <asp:TemplateField HeaderText="名称">
                            <ItemTemplate>
                                <%# swq.Tools.ClearEmpty((string)Eval("CoursePriceName") , "自动出价")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox ID="tbxCoursePriceName" runat="server" Text='<%# Eval("CoursePriceName")%>' Width="180px"></asp:TextBox>
                            </EditItemTemplate>
                        </asp:TemplateField>

                        <asp:TemplateField HeaderText="校区">
                            <ItemTemplate>
                                <%# Eval("SchoolName") %>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:DropDownList ID="ddlSchool" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSchool(), "","全校区") %>'
                                    SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                                </asp:DropDownList>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="价格">
                            <ItemTemplate>
                                <%# Eval("UnitPrice","{0:c2}")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox ID="tbxUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:f2}")%>' Width="100px"></asp:TextBox>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="数量范围">
                            <ItemTemplate>
                                <%# Eval("StartAmount","{0:0.##}")%>-<%# Eval("EndAmount","{0:0.##}")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <ul class="mt-listitems"><li><asp:TextBox ID="tbxStart" runat="server" Text='<%# Eval("StartAmount","{0:0.##}") %>' Width="80px"></asp:TextBox></li><li>-</li><li><asp:TextBox ID="tbxEnd" runat="server" Text='<%# Eval("EndAmount","{0:0.##}") %>' Width="80px"></asp:TextBox></li></ul> 
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="编辑">
                            <ItemTemplate>
                                    <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CssClass="btn btn-default" CommandName="Edit"></asp:LinkButton>
                            </ItemTemplate>
                            <EditItemTemplate>
                                    <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CssClass="btn btn-default" CommandName="Update"></asp:LinkButton>
                                    <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CssClass="btn btn-default" CommandName="Cancel"></asp:LinkButton>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="删除">
                            <ItemTemplate>
                                    <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CssClass="btn btn-default" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>

                <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
            </div>
        </div>


        <div class="mt-back">
                <input causesvalidation="false" type="button" class="btn btn-default" runat="server" onclick="back(this)" value="返回" />
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、<span class="style1">不输入名称将做为【自动出价】，自动出价可以设定购买数量范围。</span><br />
            2、<span class="style1">带名称的价格购买数量范围设置无效。</span><br />
            3、购买数量格式如：0-0 表示不限数量；1-5表示一次购买数量在1至5（包括5）区间的价格；6-0表示数量大于等于6时的价格。<br />
            4、单独校区价格权重大于全校区。<br />
        </div>
    </form>
</body>
</html>
