﻿<%@ Import Namespace="MTCUN" %>

<%@ Page Language="c#" CodeBehind="School.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Admin.School"
    Title="校区设置-系统" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>校区名称：</li>
                    <li>
                        <asp:TextBox ID="tbxSchoolName" runat="server"></asp:TextBox></li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" Text="增加" CssClass="btn btn-default" OnClick="btnAdd_Click"></asp:Button></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="SchoolID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="SchoolID" ReadOnly="True" HeaderText="校区编号" />
                    <asp:TemplateField HeaderText="校区名称">
                        <ItemTemplate>
                            <asp:Label ID="labSchoolName" runat="server" Text='<%# Bind("SchoolName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxSchoolName" runat="server" Text='<%# Bind("SchoolName") %>' Width="140"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="电话">
                        <ItemTemplate>
                            <asp:Label ID="labTel" runat="server" Text='<%# Bind("Tel") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxTel" runat="server" Text='<%# Bind("Tel") %>' Width="100"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="地址">
                        <ItemTemplate>
                            <asp:Label ID="labAddress" runat="server" Text='<%# Bind("Address") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxAddress" runat="server" Text='<%# Bind("Address") %>' Width="140"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="密钥">
                        <ItemTemplate>
                            <asp:Label ID="labHardwarePwd" runat="server" Text="*********"></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxHardwarePwd" runat="server" Text='<%# Bind("HardwarePwd") %>' Width="100px"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="坐标(经,纬)">
                        <ItemTemplate>
                            <asp:Label ID="lngandlat" runat="server" Text='<%# Eval("Lng")+","+Eval("Lat") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxlngandlat" runat="server" Text='<%# Eval("Lng")+","+Eval("Lat") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="基础资源">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkSelectCourses" runat="server" CssClass="btn btn-default" NavigateUrl='<%# string.Format("SchoolCourses.aspx?SchoolID={0}&GetUrl={1}",Eval("SchoolID"),swq.Web.PathAndQuery()) %>'>课程</asp:HyperLink>
                            <asp:HyperLink ID="hlkSelectUsers" runat="server" CssClass="btn btn-default" NavigateUrl='<%# string.Format("SchoolUsers.aspx?SchoolID={0}&GetUrl={1}",Eval("SchoolID"),swq.Web.PathAndQuery()) %>'>员工</asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>' Width="70">
                                <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                                <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CssClass="btn btn-default" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CssClass="btn btn-default" CommandName="Update"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CssClass="btn btn-default" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CssClass="btn btn-default" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、坐标拾取工具：<a href="http://api.map.baidu.com/lbsapi/getpoint/index.html" target="_blank">http://api.map.baidu.com/lbsapi/getpoint/index.html</a><br />
        </div>

    </form>
</body>
</html>
