﻿<%@ Page Language="c#" CodeBehind="SchoolCourses.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Admin.SchoolCourses"
    Title="校区课程-系统" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/CodeBox.ascx" TagName="CodeBox" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script language="javascript" type="text/javascript">
        function checkIssueType(source, args) {
            var chkListaTipoModificaciones = document.getElementById('cblSetGroup');
            var chkLista = chkListaTipoModificaciones.getElementsByTagName("input");
            for (var i = 0; i < chkLista.length; i++) {
                if (chkLista[i].checked) {
                    args.IsValid = true;
                    return;
                }
            }
            args.IsValid = false;
        }
    </script>
    <script type="text/javascript">
        var h1 = 250;
        function AddHeight(num) {
            var div = document.getElementById("tbxContent_div_HtmlBox");
            if (num < 0 && h1 < 250) {

            } else {
                h1 += num;
            }

            if (h1 > 0) {
                div.style.height = h1 + "px";
            }

            document.getElementById("tbxContent_codeboxheight").value = h1;
        }

        var h2 = 150;
        function AddHeight2(num) {
            var div = document.getElementById("tbxShowContent_div_HtmlBox");
            if (num < 0 && h2 < 150) {

            } else {
                h2 += num;
            }

            if (h2 > 0) {
                div.style.height = h2 + "px";
            }

            document.getElementById("tbxShowContent_codeboxheight").value = h2;
        }

        function insertHTML(edit, html) {
            edit.focus();
            if (edit != null) {
                var r = edit.document.selection.createRange();
                r.pasteHTML(html);
            }
        }

        function insertText(edit, text) {
            edit.focus();
            if (edit != null) {

                if (edit.document.selection && edit.document.selection.createRange) {
                    var r = edit.document.selection.createRange();
                    r.text = text;
                } else {
                    edit.document.body.innerHTML += text;
                }
            }
        }

    </script>
    <script src="../JScript/HtmlEdit.js" type="text/javascript"></script>
</head>
<body>
<!--#include file="../include/modal.htm"-->

    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>校区：</li>
                    <li>
                        <asp:Label ID="labSchoolName" runat="server"></asp:Label></li>
                    <li>课程分类：</li>
                    <li>
                        <asp:DropDownList ID="ddlCourseType" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetCourseType(),"全部") %>'
                            DataValueField="CourseTypeID" DataTextField="CourseTypeName">
                        </asp:DropDownList></li>
                    <li>
                        <asp:Button ID="btnSearch" runat="server" Text="查询" CssClass="btn btn-default" OnClick="btnSearch_Click" /></li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" Text="显示/隐藏课程" CssClass="btn btn-default" OnClick="btnAdd_Click"></asp:Button></li>
                    <li>
                        <asp:HyperLink ID="hlkUp" runat="server" Text="返回" CssClass="btn btn-warning" /></li>
                </ul>
            </div>

            <div style="width: 70%; margin-left: 0px">
                <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                    DataKeyNames="CourseID" OnRowDataBound="GridView1_RowDataBound">
                    <Columns>
                        <asp:BoundField DataField="CourseID" ReadOnly="True" HeaderText="编号" />
                        <asp:BoundField DataField="CourseName" HeaderText="课程名称" />
                        <asp:TemplateField HeaderText="标准价格(默认)">
                            <ItemTemplate>
                                <asp:HyperLink ID="hlkUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:c2}")%>'
                                    NavigateUrl='<%# string.Format("CoursePrice.aspx?CourseID={0}&SchoolID={1}&GetURL={2}",Eval("CourseID"),Request.QueryString["SchoolID"],swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:TextBox ID="tbxUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:f2}")%>'></asp:TextBox>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="单位">
                            <ItemTemplate>
                                <%# Eval("UnitName")%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="分钟/课时">
                            <ItemTemplate>
                                <%# Eval("LessonMinute")%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="分类">
                            <ItemTemplate>
                                <asp:Label ID="labCourseTypeName" runat="server" Text='<%# Eval("CourseTypeName")%>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="设置价格">
                            <ItemTemplate>
                                <label class="lab_button" style="padding: 2px">
                                    <asp:HyperLink ID="hlkSetPrice" runat="server" Text="设置" CssClass="btn btn-default"
                                        NavigateUrl='<%# string.Format("CoursePrice.aspx?CourseID={0}&SchoolID={1}&GetURL={2}",Eval("CourseID"),Request.QueryString["SchoolID"],swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                </label>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>

                <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
            </div>
        </div>
    </form>
</body>
</html>
