﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SelectClass.aspx.cs" Inherits="MTCUN.Affairs.SelectClass"
    Title="选班处理-教务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                </asp:DropDownList>
                分类：<asp:DropDownList ID="ddlCourseType" runat="server" DataTextField="CourseTypeName"
                    DataValueField="CourseTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCourseType_SelectedIndexChanged">
                </asp:DropDownList>
                课程：<asp:DropDownList ID="ddlCourse" runat="server" DataTextField="CourseName" DataValueField="CourseID">
                </asp:DropDownList>
                <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlCourse" CodeType="Course" />
                ID卡号：<asp:TextBox ID="tbxSignInID" runat="server" Width="109px"></asp:TextBox>
                学号：<asp:TextBox ID="tbxStudentID" runat="server" Width="96px"></asp:TextBox>
                姓名：<asp:TextBox ID="tbxStudentName" runat="server" Width="96px"></asp:TextBox>
                    <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="BillID" OnRowDataBound="GridView1_RowDataBound">
                <SelectedRowStyle CssClass="selected" />
                <Columns>
                    <asp:TemplateField HeaderText="学号">
                        <ItemTemplate>
                            <%#Eval("StudentID")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员姓名">
                        <ItemTemplate>
                            <%#Eval("StudentName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="课程">
                        <ItemTemplate>
                            <asp:Label ID="labProductName" runat="server" Text='<%# Bind("ProductName") %>'></asp:Label><%#swq.Tools.AddBrackets(Eval("PackageName")) %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单号">
                        <ItemTemplate>
                            <asp:Label ID="labBillID" runat="server" Text='<%# Bind("BillID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单价">
                        <ItemTemplate>
                            <asp:Label ID="labUnitPrice" runat="server" Text='<%# Bind("UnitPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="数量">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount","{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单位">
                        <ItemTemplate>
                            <asp:Label ID="labUnitName" runat="server" Text='<%# Bind("UnitName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="优惠">
                        <ItemTemplate>
                            <asp:Label ID="labDiscount" runat="server" Text='<%# Eval("Discount","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="合计">
                        <ItemTemplate>
                            <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="控制面板">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkControlPanel" runat="server" cssclass="btn btn-default" Text="控制面板" NavigateUrl='<%# string.Format("../Register/StuControlPanel.aspx?Module=1&StudentID={0}&PageIndex=3&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <div class="lab_button_sub" id="divState" runat="server">
                                <asp:HyperLink runat="server" ID="hlkState"></asp:HyperLink>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
