﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuLessons.aspx.cs" Inherits="MTCUN.Affairs.StuLessons"
    Title="出勤信息-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>班级：</li>
                    <li>
                        <asp:DropDownList ID="ddlStuClass" runat="server">
                        </asp:DropDownList></li>
                    <li>类型：</li>
                    <li>
                        <asp:DropDownList ID="ddlShowType" runat="server">
                            <asp:ListItem Value="0">显示全部</asp:ListItem>
                            <asp:ListItem Value="1" Selected="True">考勤记录</asp:ListItem>
                        </asp:DropDownList></li>
                    <li>
                        <asp:Button ID="btnSearch" CssClass="btn btn-default" runat="server" OnClick="btnSearch_Click" Text="转到" /></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" DataKeyNames="AttendID"
                AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting">
                <Columns>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <label runat="server" class='<%# (int)Eval("LeStateID") == 0 ? "label label-default": "label label-success"%>' data-toggle="tooltip" title='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>'>课</label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Subject" ReadOnly="True" HeaderText="课题" />
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <span runat="server" id="spanDate">
                                <%#Eval("StartDate","{0:d}")%></span><span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="ClassroomName" ReadOnly="True" HeaderText="教室" />
                    <asp:BoundField DataField="TeacherName" ReadOnly="True" HeaderText="讲师" />
                    <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号" />
                    <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级名称" />
                    <asp:TemplateField HeaderText="上课类型">
                        <ItemTemplate>
                            <%# Rs.Items.GetLessonType(Eval("LessonType"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="CurrentLessons" ReadOnly="True" HeaderText="出勤课时" />
                    <asp:BoundField DataField="Remark" ReadOnly="True" HeaderText="备注" HtmlEncode="true" />
                    <asp:TemplateField HeaderText="出勤状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetAtState(Eval("AtStateID"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" CssClass="btn btn-default" runat="server" Text="删除" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
    </form>
</body>
</html>
