﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuPayment.aspx.cs" Inherits="MTCUN.Affairs.StuPayment"
    Title="账户信息-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function StudentBox() {
            window.showModelessDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
        }
    </script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-show">
            <asp:FormView ID="fvStudent" runat="server" Width="100%">
                <ItemTemplate>
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3" style="text-align: center">账户信息
                                </th>
                            </tr>
                        </thead>
                        <tr>
                            <td style="width: 100px">学号：
                            </td>
                            <td colspan="2">
                                <%#Eval("StudentID")%>
                            </td>
                        </tr>
                        <tr>
                            <td>姓名：
                            </td>
                            <td>
                                <%#Eval("StudentName")%>
                            </td>
                        </tr>
                        <tr>
                            <td>可用余额：
                            </td>
                            <td colspan="2">
                                <span style="color: Red">
                                    <%#Eval("AvailableMoney", "{0:c2}")%></span>
                            </td>
                        </tr>
                        <tr>
                            <td>消费总额：
                            </td>
                            <td colspan="2">
                                <%#Eval("ConsumedMoney","{0:c2}")%>
                            </td>
                        </tr>
                        <tr>
                            <td>借款金额：
                            </td>
                            <td colspan="2">
                                <%#Eval("CreditMoney", "{0:c2}")%>
                            </td>
                        </tr>
                        <tr>
                            <td>积分：
                            </td>
                            <td colspan="2">
                                <%#Eval("Points")%>分
                            </td>
                        </tr>
                    </table>
                </ItemTemplate>
            </asp:FormView>
        </div>
        <div class=" kuai-list" style="display: none">
            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table"
                DataKeyNames="PaymentID" OnRowDataBound="GridView1_RowDataBound" Visible="False">
                <Columns>
                    <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额">
                        <ItemTemplate>
                            <asp:Label ID="labPayMoney" runat="server" Text='<%# Bind("PayMoney", "{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="收款方式">
                        <ItemTemplate>
                            <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethod") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="借款到期">
                        <ItemTemplate>
                            <asp:Label ID="labCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="办理点">
                        <ItemTemplate>
                            <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="收费文员">
                        <ItemTemplate>
                            <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div class=" alert alert-info">
            <b>注意事项：</b><br />
            1、如果您想增加交费信息，请到客服模块：学员控制面板-账户信息-增加，因为收费录入工作由客服负责。<br />
            2、如果您想编辑或删除充值单，请到财务模块：学员控制面板-账户信息-编辑或删除，因为交费信息的管理工作由财务负责。<br />
        </div>
    </form>
</body>
</html>
