﻿<%@ Page Language="c#" CodeBehind="StudentList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Affairs.StudentList"
    Title="学员列表-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }



        function Send(type) {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("StudentID").value = StudentID;
                if (type == 1) {
                    document.formStudent.action = "../media/sms/SendToStudent.aspx?geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                } else {
                    document.formStudent.action = "../weixin/wxsend.aspx?geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
            }
        }
    </script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                ＩＤ卡号：<asp:TextBox ID="tbxSignInID" runat="server" Width="114px"></asp:TextBox>
                学号：<asp:TextBox ID="tbxStudentID" runat="server" Width="84px"></asp:TextBox>
                姓名：<asp:TextBox ID="tbxStudentName" runat="server" Width="88px"></asp:TextBox>
                电话：<asp:TextBox ID="tbxTel" runat="server" Width="94px"></asp:TextBox>
                校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                </asp:DropDownList>
                录入员：<asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                </asp:DropDownList>
                顾问：<asp:DropDownList ID="ddlConsultant" runat="server" DataTextField="TrueName" DataValueField="UserID">
                </asp:DropDownList>
                <label class="lab_button">
                    <asp:Button ID="btnSelect" runat="server" Text="查询" OnClick="btnSelect_Click" CssClass="btn btn-default"></asp:Button>
                </label>
            </div>
            <br />
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>
                        <span class="btn btn-boxdefault">
                            <input onclick="Checks(this)" type="checkbox" id="cbxAll" /><label for="cbxAll">全选</label></span>
                    </li>
                    <li>
                        <asp:HyperLink ID="hlkWX" CssClass="glyphicon glyphicon-phone btn btn-success" runat="server" NavigateUrl='<%#string.Format("javascript:Send(2);void(0);") %>'
                            Text="发微信" />
                    </li>

                    <li>
                        <asp:HyperLink ID="hlkSMS" CssClass="glyphicon glyphicon-phone btn btn-default" runat="server" NavigateUrl='<%#string.Format("javascript:Send(1);void(0);") %>'
                            Text="发短信" />
                    </li>
                    <li>排序：</li>
                    <li>
                        <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                            <asp:ListItem Value="0">默认排序</asp:ListItem>
                            <asp:ListItem Value="2">录入日期</asp:ListItem>
                            <asp:ListItem Value="3">学员编号</asp:ListItem>
                        </asp:DropDownList></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StudentID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="学号">
                        <ItemTemplate>
                            <span runat="server" id="spanBox">
                                <input type="checkbox" id="id" value='<%#Eval("StudentID")%>' /></span>
                            <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员">
                        <ItemTemplate>
                            <%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("qywxState"), Eval("mtqywxState"), Eval("wxState"), Eval("mtwxState"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%#Eval("SchoolName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="可用余额">
                        <ItemTemplate>
                            <%#Eval("AvailableMoney", "{0:c2}")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="消费单">
                        <ItemTemplate>
                            帐单数<span style="color: Red"><b>
                                <%#Eval("BillCount")%></b></span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="最新选班">
                        <ItemTemplate>
                            <%#Eval("LastClassName")%>
                        (<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="控制面板">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkControlPanel" runat="server" Text="控制面板" CssClass="btn btn-default" NavigateUrl='<%# string.Format("../Register/StuControlPanel.aspx?module=1&StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="录入员">
                        <ItemTemplate>
                            <%#Eval("TrueName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员关怀">
                        <ItemTemplate>
                            <a href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>' class="btn btn-default">关怀
                                    <span class="badge">
                                        <%#Eval("ReCount")%>
                                    </span>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑" SortExpression="edit">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("../Register/StuControlPanel.aspx?module=1&StudentID={0}&PageIndex=0&action=edit&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除" SortExpression="delete">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                                OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="printWeb">
            <iframe id="PrintWeb" width="0" height="0"></iframe>
        </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
        <input id="StudentID" name="StudentID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
    <div class="alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、在学员姓名栏中输入姓名拼音简写可快速查询学员（如：输入kz，可查询出孔子）。<br />
    </div>
</body>
</html>
