﻿<%@ Page Language="c#" CodeBehind="ArrangeCourse.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Class.ArrangeCourse"
    Title="需要排课班级-教务" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">

        <div class=" kuai-list">

            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>校区：</li>
                    <li>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSchool()," ") %>'
                            DataValueField="SchoolID" DataTextField="SchoolName">
                        </asp:DropDownList></li>
                    <li>类型：</li>
                    <li>
                        <asp:DropDownList ID="ddlClassType" runat="server">
                            <asp:ListItem Value="-1">全部</asp:ListItem>
                            <asp:ListItem Value="1">一对一</asp:ListItem>
                            <asp:ListItem Value="0">一对多</asp:ListItem>
                        </asp:DropDownList></li>
                    <li>名称：</li>
                    <li>
                        <asp:TextBox ID="tbxClassName" runat="server"></asp:TextBox></li>
                    <li>排序：</li>
                    <li>
                        <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                            <asp:ListItem Value="0">默认排序</asp:ListItem>
                            <asp:ListItem Value="1">开班日期</asp:ListItem>
                            <asp:ListItem Value="2">班级编号</asp:ListItem>
                        </asp:DropDownList></li>
                    <li>
                        <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" /></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" DataKeyNames="ClassID"
                AutoGenerateColumns="False" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号"></asp:BoundField>
                    <asp:TemplateField HeaderText="班级名称">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("ClassName") %>' NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="StartDate" HeaderText="开课日期" DataFormatString="{0:d}"></asp:BoundField>
                    <asp:BoundField DataField="TeacherName" HeaderText="老师"></asp:BoundField>
                    <asp:BoundField DataField="TimeRule" HeaderText="上课规律"></asp:BoundField>
                    <asp:BoundField DataField="SchoolName" HeaderText="校区"></asp:BoundField>
                    <asp:TemplateField HeaderText="招生比例">
                        <ItemTemplate>
                            <uc2:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("PlanCount") %>' MinNum='<%#Eval("StuCount") %>'
                                ProgressWidth="50px" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课进度">
                        <ItemTemplate>
                            <uc2:Progress ID="Progress3" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                ProgressWidth="50px" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排课进度">
                        <ItemTemplate>
                            <uc2:Progress ID="Progress2" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("ArrangeLessons") %>'
                                ProgressWidth="50px" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="LastArrangeDate" HeaderText="最后上课时间" DataFormatString="{0:d}"></asp:BoundField>
                    <asp:TemplateField HeaderText="排课">
                        <ItemTemplate>
                                <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkLessons" Text="排课" NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&pageindex=2&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&PageIndex=0&action=edit&GetURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

    </form>
</body>
</html>
