﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Attend.aspx.cs" Inherits="MTCUN.Class.Attend"
    Title="上课点名-教务" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }

    </script>
    <script type="text/javascript">

        function GetSelectedValues() {
            var pID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        pID += "," + e.value;
                    }
                }
            }

            if (pID.length > 0) {
                pID = pID.substring(1, pID.length);
            }

            return pID;
        }

        function Send(type) {

            var pids = GetSelectedValues();
            if (pids.length > 0) {
                document.getElementById("StuClassID").value = pids;
                if (type == 1) {
                    document.formStudent.action = "../media/sms/SendHighToStudent.aspx?classid=" + ClassID + "&app=true&action=attend&LessonTimeID=" + LessonTimeID + "&geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
                else {
                    document.formStudent.action = "../weixin/wxsend.aspx?classid=" + ClassID + "&action=attend&LessonTimeID=" + LessonTimeID + "&geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
            }
        }
    </script>

</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <style type="text/css"> .bgc{ background-color:yellow}</style>
    <script type="text/javascript">
        var IsPrint = false;
    </script>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>
    </div>
    <form id="form1" runat="server">
        <div class="kuai-show">
            <table border="0" style="width: 100%">
                <tr>
                    <td style="width: 140px; vertical-align: top">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>学员名单簿
                                    </th>
                                </tr>
                            </thead>
                            <tr>
                                <td>
                                    <asp:ListBox ID="lbxStudents" runat="server" Height="320px" Width="100%" DataTextField="RichStudentName" ToolTip="拖放鼠标可多选。"
                                        DataValueField="StuClassID" SelectionMode="Multiple"></asp:ListBox>
                                    <asp:CheckBox ID="cbxAll" runat="server" CssClass="btn btn-default" Text="显示全部" ToolTip="显示所有学员，包含课时已上完。" data-toggle="tooltip" AutoPostBack="True" OnCheckedChanged="cbxAll_CheckedChanged" /><br />
                                    <asp:Button ID="btnSelectAll" runat="server" CssClass="btn btn-default" Text="全选" OnClick="btnSelectAll_Click" />
                                    <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-default" OnClick="btnCancel_Click" Text="取消" />

                                </td>
                            </tr>
                        </table>
                    </td>
                    <td style="vertical-align: top">
                        <div class="divpanel">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="2">上课主题
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>上课日期：
                                        </td>
                                        <td>
                                            <asp:Label ID="labDateAndTime" runat="server"></asp:Label>
                                            <asp:Label ID="labLessonType" runat="server"></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>本次课时：
                                        </td>
                                        <td>
                                            <asp:Label ID="labLessons" runat="server"></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>本课课题：
                                        </td>
                                        <td>
                                            <asp:TextBox ID="tbxSubject" runat="server" Width="184px"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>视频地址：</td>
                                        <td>
                                            <asp:TextBox ID="tbxVideoUrl" runat="server" Width="296px"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>备注/作业：
                                        </td>
                                        <td>
                                            <div id="msg" style="color: #676767">
                                            </div>
                                            <asp:TextBox ID="tbxCourseRemark" runat="server" Height="48px" TextMode="MultiLine"
                                                Width="333px"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>
                                            <asp:Button ID="btnSave" runat="server" CssClass="btn btn-default" Text="更新" OnClick="btnSave_Click" />
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <div class="kuai-list">

            <div class=" control_bg">
                <table style="border-collapse: separate; border-spacing: 2px">
                    <tr>
                        <td>

                            <div class="input-group" style="width: 100px; border-spacing: 0px">
                                <span class="input-group-addon">
                                    <input id="input-2" type="checkbox" onclick="Checks(this)" /></span>
                                <label for="input-2" class="form-control">全选</label>
                            </div>

                        </td>
                        <td></td>
                        <td></td>
                        <td runat="server" id="tdSendWx">
                            <asp:HyperLink ID="hlkWX" runat="server" CssClass="btn btn-success" NavigateUrl='<%#string.Format("javascript:Send(2);void(0);") %>'
                                Text="发微信" />
                        </td>
                        <td></td>
                        <td>
                            <asp:HyperLink ID="hlkSMS" runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("javascript:Send(1);void(0);") %>'
                                Text="发短信" />
                        </td>
                        <td></td>
                        <td>
                            
                            <div class="input-group" style="width: 400px; border-spacing: 0px">

                                <span class="input-group-addon">考勤类型：</span>
                                <asp:DropDownList ID="ddlAtStateID" runat="server" RepeatDirection="Horizontal" CssClass="bgc">
                                    <asp:ListItem Value="1" Text="出勤" Selected="True"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="迟到"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="早退"></asp:ListItem>
                                    <asp:ListItem Value="4" Text="旷课"></asp:ListItem>
                                    <asp:ListItem Value="5" Text="请假"></asp:ListItem>
                                </asp:DropDownList>
                                <span class="input-group-addon">备注：</span>
                                <asp:TextBox ID="tbxRemark" runat="server"></asp:TextBox>
                            </div>
                        </td>
                        <td>
                            <asp:Button
                                ID="btnExe" runat="server" CssClass="btn btn-success" Text="执行考勤" OnClick="btnExe_Click" ToolTip="先从学员名单簿中选择学员。（按住鼠标、Shift或Ctrl键可多选）" data-toggle="tooltip" />
                        </td>
                    </tr>
                </table>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table  table-hover" AutoGenerateColumns="False"
                DataKeyNames="AttendID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                        <ItemTemplate>
                            <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' />
                            <%#Eval("StudentID")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="姓名">
                        <ItemTemplate>
                            <%#Eval("StudentName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:Label runat="server" data-toggle="tooltip" ToolTip="选班状态" ID="ScStateID" Text='<%# Rs.Items.GetScState(Eval("ScStateID")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="课时">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labCurrentLessons" Text='<%#Eval("CurrentLessons","{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxCurrentLessons" Text='<%#Eval("CurrentLessons","{0:0.##}")%>' runat="server" Width="60px"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="考勤">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="AtStateID" Text='<%# Rs.Items.GetAtState(Eval("AtStateID"))%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlAtStateID" runat="server" Width="60px">
                                <asp:ListItem Value="1" Text="正常"></asp:ListItem>
                                <asp:ListItem Value="2" Text="迟到"></asp:ListItem>
                                <asp:ListItem Value="3" Text="早退"></asp:ListItem>
                                <asp:ListItem Value="4" Text="旷课"></asp:ListItem>
                                <asp:ListItem Value="5" Text="请假"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="签到">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labSignOn" Text='<%#Eval("SignOn","{0:HH:mm}")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="签退">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labSignOut" Text='<%#Eval("SignOut","{0:HH:mm}")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注/课堂表现">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="RemarkText" Text='<%#Eval("Remark")%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" Text='<%#Eval("Remark")%>' runat="server" TextMode="SingleLine"
                                Rows="2" Columns="30"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="个人课时进度">
                        <ItemTemplate>
                            <uc1:Progress ID="Progress1" runat="server" QType='<%#(QType)Eval("QType") %>' MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>' StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>'
                                ProgressParentWidth="60%" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="消耗学费">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labPrice" Text='<%#Eval("Price","{0:c2}")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkPrint" runat="server" CssClass="glyphicon glyphicon-print btn btn-default" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("AttendID")) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" CommandName="Delete" Text="删除" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="mt-back">

            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
            <input id="btnTop" class="btn btn-default" runat="server" causesvalidation="false" type="button"
                value="排课列表" />
            <input id="btnChange" class="btn btn-default" runat="server" causesvalidation="false" type="button"
                value="调课" />
        </div>


        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、选班日期在上课日期之后的学员不会出现在名单簿上。<br />
            2、考勤方法：先选中左边学员（可多选）,然后选择考勤类型，点击“执行考勤”即可。<br />
            3、选择显示全部，将出现课时已上完的学员姓名及选班日期在本次上课日期之后的学员。<br />
            4、当勾选“显示全部”，学员名单簿姓名后面的数字表示剩余课时，负数表示已上超的课时数。<br />
        </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
        <input id="StuClassID" name="StuClassID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
</body>
</html>
