﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ChangeLessons.aspx.cs" Inherits="MTCUN.Class.ChangeLessons"
    Title="按天调课-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body onload="dspCurDT()">
    <script type="text/javascript">

        function Prints() {
            var StuClassID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StuClassID += "," + e.value;
                    }
                }
            }

            if (StuClassID.length > 0) {
                StuClassID = StuClassID.substring(1, StuClassID.length);
            }
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }
    </script>
    <form id="form1" runat="server">


        <div class=" kuai-list">

            <div class="control_bg">
                <table border="0" class="mt-boxlist inline_block">
                    <tr>
                        <td>
                            <input onclick="Checks(this)" type="checkbox" id="boxall" /><label for="boxall">全选</label>
                        </td>
                    </tr>
                </table>

                校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                </asp:DropDownList>
                当前：<asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                <asp:Button ID="btnPost" runat="server" OnClick="btnPost_Click" CssClass="btn btn-default" Text="搜索" />
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="LessonTimeID" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="班号" ItemStyle-Width="120">
                        <ItemTemplate>
                            <input type="checkbox" id="id" name="id" value='<%#Eval("LessonTimeID")%>' />
                            <%#Eval("ClassID")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="班级名称">
                        <ItemTemplate>
                            <span class="glyphicon glyphicon-home text-success"></span>
                            <asp:HyperLink runat="server" ID="HyperLink1" Text='<%#Eval("ClassName") %>' NavigateUrl='<%# string.Format("../Class/ClassControlPanel.aspx?ClassID={0}&pageindex=2&LessonTimeID={1}&action=attend&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <label runat="server" class='<%# (int)Eval("LeStateID") == 0 ? "label label-default": "label label-success"%>' data-toggle="tooltip" title='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>'>课</label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labLessonType" Text='<%#Rs.Items.GetLessonType(Eval("LessonType"))%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLessonType" SelectedValue='<%#Eval("LessonType")%>'>
                                <asp:ListItem Text="正常" Value="1"></asp:ListItem>
                                <asp:ListItem Text="补课" Value="0"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Subject" HeaderText="课题"></asp:BoundField>
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" ID="hlkLessonInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                NavigateUrl='<%# string.Format("../Class/ClassControlPanel.aspx?ClassID={0}&pageindex=2&LessonTimeID={1}&action=attend&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            <span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="dateandtime" runat="server" Text='<%#Convert.ToDateTime(Eval("StartDate")).ToString("d")%>'
                                Width="80">
                            </asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# SignTimeState(Eval("StartDate"), Eval("EndDate"), Eval("SetParameters"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Lessons" HeaderText="课时"></asp:BoundField>
                    <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                    <asp:TemplateField HeaderText="讲师">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labTeacherName" Text='<%#Eval("TeacherName")%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%#Eval("TeacherID")%>'
                                DataSource='<%#swq.Cache.GetUsers()%>' DataTextField="TrueName" DataValueField="UserID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="教室">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labClassroomName" Text='<%#Eval("ClassroomName")%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%#Eval("ClassroomID")%>'
                                DataSource='<%#swq.Cache.GetClassroom()%>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="kuai-show form">
            <table class="table">
                <thead>
                    <tr>
                        <th colspan="2">调课操作</th>
                    </tr>
                </thead>
                <tr>
                    <td style="text-align: right">调课方式：</td>
                    <td>
                        <asp:RadioButtonList ID="rblMode" runat="server" CssClass="mt-radiolist">
                            <asp:ListItem Value="0">仅删除当日排课</asp:ListItem>
                            <asp:ListItem Value="1" Selected="True">调整到指定日期</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td style="text-align: right">日期：</td>
                    <td>
                        <asp:TextBox ID="tbxToDate" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;</td>
                    <td>
                        <label class="lab_button">
                            <asp:Button ID="btnTo" runat="server" OnClick="btnTo_Click" Text="执行" CssClass="btn btn-default" /></label>
                    </td>
                </tr>
            </table>
            <br />
            <br />
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、【仅删除当日排课】只删除尚未上课的排课记录。<br />
            2、【调整到指定日期(补课日期)】注意这个日期表示安排补课的时间，不能与已排课冲突（只针对尚未上课的排课记录）。<br />
        </div>
    </form>
</body>
</html>
