﻿<%@ Page Language="c#" CodeBehind="ClassList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Class.ClassList"
    Title="班级列表-教务" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->

    <form id="Form1" method="post" runat="server">

        <div class="kuai-show">
            <table class="table">
                <thead>
                    <tr>
                        <th>班级快速查询
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <div class="input-group" style="width: 300px">
                                <span class="input-group-addon">校区：</span>
                                <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                                </asp:DropDownList>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="input-group" style="width: 600px">
                                <span class="input-group-addon">课程分类：</span>
                                <asp:DropDownList ID="ddlCourseType" runat="server" DataTextField="CourseTypeName"
                                    DataValueField="CourseTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCourseType_SelectedIndexChanged">
                                </asp:DropDownList>

                                <span class="input-group-addon">课程：</span>
                                <asp:DropDownList ID="ddlCourse" runat="server" DataTextField="CourseName" DataValueField="CourseID">
                                </asp:DropDownList>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="input-group" style="width: 780px">
                                <span class="input-group-addon">班号：</span>
                                <asp:TextBox ID="tbxClassID" runat="server"></asp:TextBox>
                                <span class="input-group-addon">名称：</span>
                                <asp:TextBox ID="tbxClassName" runat="server"></asp:TextBox>
                                <span class="input-group-addon">班级类型：</span>
                                <asp:DropDownList ID="ddlClassType" runat="server">
                                    <asp:ListItem Value="-1" Text=" "></asp:ListItem>
                                    <asp:ListItem Value="0">一对多</asp:ListItem>
                                    <asp:ListItem Value="1">一对一</asp:ListItem>
                                </asp:DropDownList>
                                <span class="input-group-addon">状态：</span>
                                <asp:DropDownList ID="ddlState" runat="server">
                                    <asp:ListItem Value="0" Text=""></asp:ListItem>
                                    <asp:ListItem Value="1" Text="未开课"></asp:ListItem>
                                    <asp:ListItem Value="2" Text="开课中"></asp:ListItem>
                                    <asp:ListItem Value="3" Text="已结束"></asp:ListItem>
                                    <asp:ListItem Selected="True" Value="4" Text="未结束"></asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="input-group" style="width: 600px">
                                <span class="input-group-addon">开始：</span>
                                <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                                <span class="input-group-addon">结束：</span>
                                <asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="input-group" style="width: 300px;">
                                <span class="input-group-addon">讲师：</span>
                                <asp:DropDownList ID="ddlTeacher" runat="server" DataTextField="TrueName" DataValueField="UserID">
                                </asp:DropDownList>
                                <span class="input-group-addon"></span>
                                <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Button ID="btnSelect" CssClass="btn btn-success" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class=" kuai-list">

            <div class="input-group" style="width: 200px">
                <span class="input-group-addon">排序：</span>
                <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                    <asp:ListItem Value="0">默认排序</asp:ListItem>
                    <asp:ListItem Value="1">开班日期</asp:ListItem>
                    <asp:ListItem Value="2">班级编号</asp:ListItem>
                </asp:DropDownList>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table  table-hover" DataKeyNames="ClassID"
                AutoGenerateColumns="False" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="">
                        <ItemTemplate>
                            <span class="glyphicon glyphicon-home text-success"></span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="班级信息">
                        <ItemTemplate>

                            <span style="font-weight: bold; font-size: 1.2em">
                                <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("ClassName") %>' NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            </span>
                            <br />
                            班号：<%# Eval("ClassID") %><br />
                            收费：<%# Eval("UnitName") %><br />
                            主讲：<%# Eval("TeacherName") %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="">
                        <ItemTemplate>
                            开课：<%# Eval("StartDate","{0:d}") %><br />
                            周期：<%# Eval("TimeRule") %><br />
                            校区：<%# Eval("SchoolName") %><br />
                            助教：<%# Eval("HeadTeacherName") %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="进度信息" ItemStyle-Width="200px">
                        <ItemTemplate>
                            <uc2:Progress ID="Progress1" TitleText="招生：" runat="server" MaxNum='<%#Eval("PlanCount") %>' MinNum='<%#Eval("StuCount") %>'
                                ProgressWidth="80px" />

                            <uc2:Progress ID="Progress3" TitleText="上课：" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                ProgressWidth="80px" />

                            <uc2:Progress ID="Progress2" TitleText="排课：" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("ArrangeLessons") %>'
                                ProgressWidth="80px" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="课程表">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkLessons" Text="课表" NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&pageindex=2&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="控制面板">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkShow" CssClass="btn btn-default" runat="server" Text="控制面板" NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&GetUrl={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("ClassControlPanel.aspx?ClassID={0}&PageIndex=0&action=edit&GetURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="alert alert-info">
            <b>注意事项：</b><br />
            1、当您发现开好的班不见了，请不要着急，看清楚查询控制面板上的状态为“未结束”，把它修改了空白，再点击查询试试。<br />
        </div>
    </form>
</body>
</html>
