﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ClassStudents.aspx.cs"
    Inherits="MTCUN.Class.ClassStudents" Title="班级学员列表-教务" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportControl.ascx" TagName="ReportControl" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function __Control_Prints(id) {

            var KeyID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        KeyID += "," + e.value;
                    }
                }
            }

            if (KeyID.length > 0) {
                KeyID = KeyID.substring(1, KeyID.length);
            }

            __Control_Print(id, KeyID);
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }

    </script>
    <script type="text/javascript">

        function GetSelectedValues() {
            var pID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        pID += "," + e.value;
                    }
                }
            }

            if (pID.length > 0) {
                pID = pID.substring(1, pID.length);
            }

            return pID;
        }

        function Send(type) {
            var pids = GetSelectedValues();
            if (pids.length > 0) {
                document.getElementById("StuClassID").value = pids;
                if (type == 1) {
                    document.formStudent.action = "../media/sms/SendToStudent.aspx?geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                } else {
                    document.formStudent.action = "../weixin/wxsend.aspx?classid=" + ClassID + "&geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
            }
        }
    </script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->

    <form id="form1" runat="server">
        <div class=" kuai-list">

            <div class=" control_bg">
                <table style="border-collapse: separate; border-spacing: 2px">
                    <tr>
                        <td>
                            <div class="input-group" style="width: 100px; border-spacing: 0px;">
                                <span class="input-group-addon">
                                    <input id="input-2" type="checkbox" onclick="Checks(this)" /></span>
                                <label for="input-2" class="form-control">全选</label>
                            </div>
                        </td>
                        <td runat="server" id="tdSendWx">
                            <asp:HyperLink ID="hlkWX" runat="server" CssClass="btn btn-success" NavigateUrl='<%#string.Format("javascript:Send(2);void(0);") %>'
                                Text="发微信" />
                        </td>
                        <td></td>
                        <td>
                            <asp:HyperLink ID="hlkSMS" runat="server" CssClass="btn btn-success" NavigateUrl='<%#string.Format("javascript:Send(1);void(0);") %>'
                                Text="发短信" />
                        </td>
                        <td>
                            <div style="border-spacing: 0px;">
                                <uc2:ReportControl ID="ReportControl1" runat="server" />
                            </div>
                        </td>
                        <td>
                            <div class="input-group" style="width: 180px; border-spacing: 0px">
                                <span class="input-group-addon">筛选：</span>
                                <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                                    <asp:ListItem Value="0">默认</asp:ListItem>
                                    <asp:ListItem Value="1">显示全部</asp:ListItem>
                                    <asp:ListItem Value="2">状态正常</asp:ListItem>
                                    <asp:ListItem Value="3">状态异常</asp:ListItem>
                                    <asp:ListItem Value="4">课时未完学员</asp:ListItem>
                                    <asp:ListItem Value="5">课时上完学员</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </td>
                        <td></td>
                        <td>
                            <asp:Button ID="btnAddStudent" runat="server" Text="增加学员"
                                OnClick="btnAddStudent_Click" Visible="false" />
                        </td>
                        <td style="padding-left: 2px">
                            <asp:Button ID="btnToClass" runat="server" CssClass="btn btn-warning" Text="快捷转班" OnClick="btnToClass_Click" />
                        </td>
                        <td style="padding-left: 2px; display:none">
                            <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加学员" />
                        </td>
                    </tr>
                </table>
            </div>




            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StuClassID" OnRowDataBound="GridView1_RowDataBound" EnableViewState="False">
                <Columns>
                    <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                        <ItemTemplate>
                            <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' />
                            <%#Eval("StudentID")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="姓名">
                        <ItemTemplate>
                            <%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("qywxState"), Eval("mtqywxState"), Eval("wxState"), Eval("mtwxState"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="ScStateID" Text='<%# Rs.Items.GetScState(Eval("ScStateID")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <%#Rs.Items.GetStuClassType(Eval("ContinueReg"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="选班日期">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labDateAndTime" Text='<%# Eval("DateAndTime","{0:d}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="课时进度">
                        <ItemTemplate>
                            <uc1:Progress ID="Progress1" runat="server" QType='<%#(QType)Eval("QType") %>' MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>' Width="90%" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="成绩">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labScore" Text='<%#Eval("Score")%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="评价">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkOpinion" Text="评价" NavigateUrl='<%# string.Format("../Affairs/PostOpinion.aspx?Module="+(int)ModuleType+"&StuClassID={0}&GetURL={1}",Eval("StuClassID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="回访">
                        <ItemTemplate>
                            <a class="btn btn-default" href='../Affairs/StuReply.aspx?StudentID=<%#Eval("StudentID")%>&module=<%=(int)ModuleType %>&GetURL=<% = swq.Web.PathAndQuery() %>'>回访
                                    <span class="badge"><%#Eval("ReCount") %></span>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="控制面板">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkStudent" CssClass="btn btn-default" NavigateUrl='<%# string.Format("../Register/StuControlPanel.aspx?Module="+(int)ModuleType+"&StudentID={0}&StuClassID={1}&pageIndex=0&GetURL={2}",Eval("StudentID"),Eval("StuClassID"),swq.Web.PathAndQuery()) %>'
                                Text="控制面板" runat="server">
                            </asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
            <uc3:ReportServer ID="ReportServer1" runat="server" />
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
        <input id="StuClassID" name="StuClassID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
</body>
</html>
