﻿<%@ Import Namespace="MTCUN" %>

<%@ Page Language="c#" CodeBehind="Classroom.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Class.Classroom"
    Title="教室设置-教务" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
            教室名称：
        <asp:TextBox ID="tbxClassroomName" runat="server"></asp:TextBox>
            容纳人数：
        <asp:TextBox ID="tbxSeating" runat="server" Width="47px"></asp:TextBox>
            校区：
        <asp:DropDownList ID="ddlSchool" runat="server" DataSource='<%# swq.Cache.Fill(swq.Cache.GetSchool()," ") %>'
            DataValueField="SchoolID" DataTextField="SchoolName">
        </asp:DropDownList>
                <asp:Button ID="btnGo" runat="server" Text="转到" OnClick="btnGo_Click" CssClass="btn btn-default"></asp:Button>
                <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click" CssClass="btn btn-default"></asp:Button>
        </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="ClassroomID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="ClassroomID" ReadOnly="True" HeaderText="教室编号" />
                    <asp:BoundField DataField="ClassroomName" HeaderText="教室名称" />
                    <asp:BoundField DataField="Seating" HeaderText="容纳人数" />
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                <asp:ListItem Value="0" Text="禁用"></asp:ListItem>
                                <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%# Eval("SchoolName") %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                                SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CommandName="Edit" CssClass="btn btn-default"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CommandName="Update" CssClass="btn btn-default"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CommandName="Cancel" CssClass="btn btn-default"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CssClass="btn btn-default" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、注意教室不是班级，有几间教室您就设置几间。<br />
        </div>
    </form>
</body>
</html>
