﻿<%@ Import Namespace="MTCUN" %>

<%@ Page Language="c#" CodeBehind="Holiday.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Class.Holiday"
    Title="假日设置-教务" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                假日名称：
        <asp:TextBox ID="tbxHolidayName" runat="server"></asp:TextBox>
                日期：
        <asp:TextBox ID="tbxStartDate" runat="server" onfocus="javascript:return showCalendar(this);"></asp:TextBox>
                至
        <asp:TextBox ID="tbxEndDate" runat="server" onfocus="javascript:return showCalendar(this);"></asp:TextBox>
                <label class="lab_button">
                    <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click" CssClass="btn btn-default"></asp:Button>
                </label>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="HolidayID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="HolidayName" HeaderText="假日名称" />
                    <asp:BoundField DataField="StartDate" HeaderText="开始日期" HtmlEncode="False" DataFormatString="{0:d}"
                        ApplyFormatInEditMode="True" />
                    <asp:BoundField DataField="EndDate" HeaderText="结束日期" HtmlEncode="False" DataFormatString="{0:d}"
                        ApplyFormatInEditMode="True" />
                    <asp:TemplateField HeaderText="排序" Visible="false">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <div class="lab_button_sub" id="divEdit" runat="server">
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CommandName="Edit"></asp:LinkButton>
                            </div>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <div class="lab_button_sub">
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CommandName="Update"></asp:LinkButton>
                            </div>
                            <div class="lab_button_sub">
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CommandName="Cancel"></asp:LinkButton>
                            </div>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <div class="lab_button_sub" id="divDelete" runat="server">
                                <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、预先设置好假期，排课时才会自动跳过假期。<br />
        </div>
    </form>
</body>
</html>
