﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTable_Month.aspx.cs"
    Inherits="MTCUN.Class.LessonTable_Month" Title="月课程总表-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">

        var arrIndexs = new Array();
        var i = 0;

        function getElementsByClassName(n) {
            var classElements = [], allElements = document.getElementsByTagName('*');
            for (var i = 0; i < allElements.length; i++) {
                if (allElements[i].className == n) {
                    classElements[classElements.length] = allElements[i];
                }
            }
            return classElements;
        }

        function ClassName(className, state, color) {
            if (state == 1) {
                var redClassElements = getElementsByClassName(className);
                for (var i = 0; i < redClassElements.length; i++) {
                    redClassElements[i].style.backgroundColor = color;
                }
            } else {
                var redClassElements = getElementsByClassName(className);
                for (var i = 0; i < redClassElements.length; i++) {
                    redClassElements[i].style.backgroundColor = color;
                }
            }
        }

        function OnClick(index, color) {
            var redClassElements = getElementsByClassName('mt_bg_' + index);
            for (var i = 0; i < redClassElements.length; i++) {
                redClassElements[i].style.backgroundColor = color;
                redClassElements[i].onmouseout = "";
            }
        }

        function Selected(indexs) {
            if (indexs != "0") {
                var index = indexs.split('_')[0];
                var color = indexs.split('_')[1];
                OnClick(index, color);

                arrIndexs[i] = index;
                i++;
            }
            else {
                for (i = 0; i < arrIndexs.length; i++) {
                    var index = arrIndexs[i];
                    ClassName('mt_bg_' + index, 0, '#ffffff');
                }
            }
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "cbxName") {
                    e.checked = checkbox.checked;
                }
            }
        }

        function Hide() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "cbxName") {
                    if (e.checked) {
                        document.getElementById("GridView1").rows[e.value].style.display = "none";
                    }
                }
            }
        }
    </script>
    <style type="text/css">
        .gridview th {
            text-align: center;
        }

        .gridview td {
            border-right-width: 1px;
        }

        .colorCode {
            background-color: White;
        }
    </style>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <table cellpadding="0" cellspacing="0">
                    <tr>
                        <td>
                            <div class="input-group" style="width: 100px; border-spacing: 0px;">
                                <span class="input-group-addon">
                                    <input id="input-2" type="checkbox" onclick="Checks(this)" /></span>
                                <label for="input-2" class="form-control">全选</label>
                            </div>
                        </td>
                        <td></td>
                        <td>
                            <input id="Button1" type="button" value="隐藏" onclick="Hide();" class="btn btn-default" />
                        </td>
                        <td>校区：
                        </td>
                        <td>
                            <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                            </asp:DropDownList>
                            分组：<asp:DropDownList ID="ddlSortType" runat="server">
                                <asp:ListItem Value="0">教室</asp:ListItem>
                                <asp:ListItem Value="1">老师</asp:ListItem>
                                <asp:ListItem Value="2">班级</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td>日期：
                        </td>
                        <td>
                            <asp:TextBox ID="tbxDateAndTime" runat="server" Width="100px"></asp:TextBox>
                        </td>
                        <td>
                            <asp:Button ID="btnShow" runat="server" OnClick="btnShow_Click" Text="查看" CssClass="btn btn-default" />
                            <asp:Button ID="btnUp" runat="server" OnClick="btnUp_Click" Text="上月" CssClass="btn btn-default" />
                            <asp:Button ID="btnDown" runat="server" OnClick="btnDown_Click" Text="下月" CssClass="btn btn-default" />
                            <asp:Button ID="btnExportExcel" runat="server" OnClick="btnExportExcel_Click" Text="导出EXCEL" CssClass="btn btn-default" />
                        </td>
                    </tr>
                </table>
            </div>

            <div class="divpanel" style="overflow: auto; padding-bottom: 40px">
                <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="false" CssClass="table table-hover"
                    OnRowDataBound="GridView1_RowDataBound" EnableViewState="False">
                </asp:GridView>
            </div>
            <div class="divpanel">
                <b>色标说明：</b><br />
                <br />
                <div style="width: 600px; height: auto; overflow: auto; border: 1px solid #cccccc;">
                    <asp:GridView ID="GridView2" runat="server" EnableModelValidation="True" EnableViewState="False"
                        CssClass="colorCode" AutoGenerateColumns="False" Width="100%" HeaderStyle-HorizontalAlign="Left">
                        <Columns>
                            <asp:TemplateField HeaderText="色标">
                                <ItemTemplate>
                                    <div onclick="<%# string.Format("Selected('{0}_{1}')",Eval("ClassIndex"),GetClassColor((int)Eval("ClassIndex"))) %>"
                                        style="<%# string.Format("background-color:{0}; width: 20px;height: 20px; border: 1px solid #cccccc; text-align: center; margin-left: auto; cursor:pointer;margin-right: auto;; vertical-align:middle; line-height:20px",GetClassColor((int)Eval("ClassIndex"))) %>">
                                        <%#Eval("ClassIndex") %>
                                    </div>
                                </ItemTemplate>
                                <HeaderStyle HorizontalAlign="Center" />
                            </asp:TemplateField>
                            <asp:BoundField DataField="ClassID" HeaderText="班号">
                                <HeaderStyle HorizontalAlign="Left" />
                            </asp:BoundField>
                            <asp:BoundField DataField="ClassName" HeaderText="班名">
                                <HeaderStyle HorizontalAlign="Left" />
                            </asp:BoundField>
                            <asp:BoundField DataField="TeacherName" HeaderText="老师">
                                <HeaderStyle HorizontalAlign="Left" />
                            </asp:BoundField>
                        </Columns>
                        <HeaderStyle HorizontalAlign="Left" />
                    </asp:GridView>
                </div>
            </div>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、标题数字红色表示周末，蓝色表示当前日期。<br />
            2、内容方框内数字红色表示课程时间有冲突。
        <br />
            3、内容方框内左上角显示绿色表示已上完课。
        </div>
    </form>
</body>
</html>
