﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTime.aspx.cs" Inherits="MTCUN.Class.LessonTime"
    Title="排课信息-教务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />


    <style type="text/css">
        .ld {
            margin: 0px;
            padding: 0px;
            list-style: none;
        }

            .ld li {
                display: inline-block;
            }
    </style>

    <script type="text/javascript">
        function NoDataTips() {
            var _billItems = document.getElementById("BillItems");
            if (_billItems.innerText.trim() == "") {
                _billItems.innerHTML = "<span style='color:red'>*</span>排课先增加排课参数。";
            }
        }
    </script>

</head>
<body onload="NoDataTips()">
    <!--#include file="../include/modal.htm"-->

    <form id="form1" runat="server" class="bs-example bs-example-form" role="form">


        <div class="kuai-show">
            <uc3:Ann ID="Ann1" runat="server" />
            <table class="table">
                <thead>
                    <tr>
                        <th colspan="2">排课面板
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>排课提示：
                    </td>
                    <td>
                        <div class="striking inline_block">
                            <asp:Label ID="labTimeRule" runat="server" Text="Label"></asp:Label>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>排课参数：
                    </td>
                    <td>
                        <div class="striking_head">
                            <ul class="ld">
                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">周期：</span>
                                        <asp:DropDownList ID="ddlWeek" runat="server">
                                            <asp:ListItem Text="周日" Value="0"></asp:ListItem>
                                            <asp:ListItem Text="周一" Value="1"></asp:ListItem>
                                            <asp:ListItem Text="周二" Value="2"></asp:ListItem>
                                            <asp:ListItem Text="周三" Value="3"></asp:ListItem>
                                            <asp:ListItem Text="周四" Value="4"></asp:ListItem>
                                            <asp:ListItem Text="周五" Value="5"></asp:ListItem>
                                            <asp:ListItem Text="周六" Value="6"></asp:ListItem>
                                            <asp:ListItem Text="全周" Value="-1"></asp:ListItem>
                                            <asp:ListItem Text="单号" Value="-3"></asp:ListItem>
                                            <asp:ListItem Text="双号" Value="-2"></asp:ListItem>
                                            <asp:ListItem Text="隔天" Value="-4"></asp:ListItem>
                                        </asp:DropDownList>
                                    </div>
                                </li>
                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">时段：</span>

                                        <asp:DropDownList ID="ddlTimes" runat="server">
                                        </asp:DropDownList>

                                        <span class="input-group-addon btn">
                                            <span title="时段快捷管理" data-toggle="tooltip" class="glyphicon glyphicon-edit" data-url="../Class/PeriodTime.aspx" data-action="sxsd" onclick="openweb(this)"></span>
                                        </span>

                                        <asp:DropDownList ID="ddlGroupType" runat="server" DataTextField="PeriodTimeGroupName"
                                            DataValueField="PeriodTimeGroupID" AutoPostBack="True" OnSelectedIndexChanged="ddlGroupType_SelectedIndexChanged">
                                        </asp:DropDownList>
                                    </div>
                                </li>
                            </ul>
                            <ul class="ld">
                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">讲师：</span>
                                        <asp:DropDownList runat="server" ID="ddlTeacher" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList>
                                        <span class="input-group-addon"></span>
                                        <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" CssClass="form-control" />

                                    </div>
                                </li>
                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">助教：</span>
                                        <asp:DropDownList runat="server" ID="ddlAssistant" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList>
                                        <span class="input-group-addon"></span>
                                        <uc1:SimpleCode ID="SimpleCode2" runat="server" UsersControlID="ddlAssistant" />
                                    </div>
                                </li>
                            </ul>
                            <ul class="ld">
                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">教室：</span>
                                        <asp:DropDownList ID="ddlClassroom" runat="server" DataTextField="ClassroomName"
                                            DataValueField="ClassroomID">
                                        </asp:DropDownList>

                                        <span class="input-group-addon btn">
                                            <span title="教室快捷管理" data-toggle="tooltip" class="glyphicon glyphicon-edit" data-url="../Class/Classroom.aspx" data-action="sxjs" onclick="openweb(this)"></span>
                                        </span>
                                    </div>

                                </li>

                                <li>
                                    <div class="input-group">
                                        <span class="input-group-addon">课题：</span>
                                        <asp:TextBox runat="server" ID="tbxSubject" Width="120px" class="form-control" placeholder=""></asp:TextBox>
                                    </div>
                                </li>
                                <li>
                                    <div class="input-group">
                                        <asp:Button ID="btnAddTime" CssClass="btn btn-warning" runat="server" CausesValidation="False" OnClick="btnAddTime_Click"
                                            Text="添加排课参数" />
                                    </div>
                                </li>
                            </ul>
                        </div>

                        <div class="striking_content">
                            <div style="width: 80%" id="BillItems">
                                <ul class="ld">
                                    <li style="min-width: 60%">
                                        <asp:GridView ID="gvCycPeriodTime" runat="server" AutoGenerateColumns="False"
                                            DataKeyNames="ClassID,PeriodTimeID,Week" OnRowCancelingEdit="gvCycPeriodTime_RowCancelingEdit"
                                            OnRowDeleting="gvCycPeriodTime_RowDeleting" OnRowEditing="gvCycPeriodTime_RowEditing"
                                            OnRowUpdating="gvCycPeriodTime_RowUpdating" CssClass="table table-striped" CellSpacing="0"
                                            CellPadding="0">
                                            <Columns>
                                                <asp:TemplateField HeaderText="周期">
                                                    <ItemTemplate>
                                                        <asp:Label ID="Week0" runat="server" Text='<%# Rs.Items.GetWeekText(Eval("Week")) %>'></asp:Label>
                                                    </ItemTemplate>
                                                </asp:TemplateField>
                                                <asp:BoundField DataField="PeriodTimeName" HeaderText="时间段" ReadOnly="true" />
                                                <asp:BoundField DataField="Minute" HeaderText="分钟" ReadOnly="true" />
                                                <asp:TemplateField HeaderText="课时" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:Label ID="labLessons" runat="server" Text='<%# Eval("Lessons","{0:0.##}") %>'></asp:Label>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:TextBox ID="tbxLessons" runat="server" Text='<%# Eval("Lessons","{0:0.##}") %>' Width="60px"></asp:TextBox>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="讲师" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:Label ID="labTeacherName" runat="server" Text='<%# Eval("TeacherName") %>'></asp:Label>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%# Eval("TeacherID") %>'
                                                            DataSource='<%# swq.Cache.GetUsers() %>' DataTextField="TrueName" DataValueField="UserID">
                                                        </asp:DropDownList>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="助教" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:Label ID="labAssistantName" runat="server" Text='<%# Eval("AssistantName") %>'></asp:Label>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:DropDownList runat="server" ID="ddlAssistant" SelectedValue='<%# Eval("AssistantID") %>'
                                                            DataSource='<%# swq.Cache.Fill(swq.Cache.GetUsers()," ") %>' DataTextField="TrueName"
                                                            DataValueField="UserID">
                                                        </asp:DropDownList>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="教室" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:Label ID="labClassroomName" runat="server" Text='<%# Eval("ClassroomName") %>'></asp:Label>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%# Eval("ClassroomID") %>'
                                                            DataSource='<%# swq.Cache.GetClassroom() %>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                                                        </asp:DropDownList>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="课题" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:Label ID="labSubject" runat="server" Text='<%# Eval("Subject") %>'></asp:Label>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:TextBox runat="server" ID="tbxSubject" Width="60px" Text='<%# Eval("Subject") %>'></asp:TextBox>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="编辑">
                                                    <ItemTemplate>
                                                        <div id="divEdit" runat="server">
                                                            <asp:LinkButton ID="lbnEdit" CssClass="btn btn-default" runat="server" Text="编辑" CommandName="Edit"></asp:LinkButton>
                                                        </div>
                                                    </ItemTemplate>
                                                    <EditItemTemplate>
                                                        <asp:LinkButton ID="lbnUpdate" CssClass="btn btn-default" runat="server" Text="更新" CommandName="Update"></asp:LinkButton>
                                                        <asp:LinkButton ID="lbnCancel" CssClass="btn btn-default" runat="server" Text="取消" CommandName="Cancel"></asp:LinkButton>
                                                    </EditItemTemplate>
                                                </asp:TemplateField>
                                                <asp:TemplateField HeaderText="删除" ShowHeader="False">
                                                    <ItemTemplate>
                                                        <asp:LinkButton ID="lbnDelete" CssClass="btn btn-default" runat="server" CausesValidation="False" CommandName="Delete"
                                                            OnClientClick="return delete_confirm(this,'您确定要删除这条记录？');" Text="删除"></asp:LinkButton>
                                                    </ItemTemplate>
                                                </asp:TemplateField>
                                            </Columns>
                                        </asp:GridView>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>排课日期段：
                    </td>
                    <td>
                        <div class="input-group" style="width: 300px">
                            <span class="input-group-addon">起始日：</span>
                            <asp:TextBox ID="tbxStartDate" runat="server" CssClass="required mt-dropdownlist"></asp:TextBox>

                            <span class="input-group-addon">截止日：</span>
                            <asp:TextBox ID="tbxEndDate" runat="server" CssClass="mt-dropdownlist"></asp:TextBox>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>可排课时数：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlLessons" runat="server" Width="120px">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>排课完成度：
                    </td>
                    <td>
                        <uc2:Progress ID="Progress1" runat="server" Text="课时" Width="40%" />
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <asp:Button ID="btnAutoAddLessonTime" CssClass="btn btn-success" runat="server" OnClick="btnAutoAddLessonTime_Click"
                            Text="自动排课" />

                        <asp:Button ID="btnAddOneLessonTime" CssClass="btn btn-default" runat="server" OnClick="btnAddOneLessonTime_Click"
                            Text="逐个排课" />

                        <asp:Button ID="btnClearLessonTime" CssClass="btn btn-default" runat="server" OnClick="btnClearLessonTime_Click"
                            Text="清除排课" OnClientClick="return delete_confirm(this,'执行此操作，将删除所有未上课的排课信息，您确定要这么做？');" />

                    </td>
                </tr>
            </table>
        </div>

        <div class=" kuai-list">
            <asp:GridView ID="GridView1" runat="server" CssClass="table  table-hover" AutoGenerateColumns="False"
                DataKeyNames="LessonTimeID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <label runat="server" class='<%# (int)Eval("LeStateID") == 0 ? "label label-default": "label label-success"%>' data-toggle="tooltip" title='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>'>课</label>
                            <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            <span class="label label-warning"><%#swq.Tools.GetWeek(Eval("StartDate"))%></span>
                            <%#Eval("Subject")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Lessons" HeaderText="课时" DataFormatString="{0:0.##}"></asp:BoundField>
                    <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TruancyCount" HeaderText="旷课" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LateCount" HeaderText="迟到" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AdvanceCount" HeaderText="早退" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LeaveCount" HeaderText="请假" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TeacherName" HeaderText="讲师" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AssistantName" HeaderText="助教" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="ClassroomName" HeaderText="教室" ReadOnly="True"></asp:BoundField>
                    <asp:TemplateField HeaderText="点名">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkAttend" Text="点名" NavigateUrl='<%# string.Format("Attend.aspx?Module="+(int)ModuleType+"&ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑" ShowHeader="False">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("PostLessonTime.aspx?Module="+(int)ModuleType+"&LessonTimeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonTimeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                ID="hlkEdit" Text="编辑" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" OnClientClick="return delete_confirm(this,'您确定要删除这条记录？');" CommandName="Delete" class="btn btn-default"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>

        </div>



        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div class="alert alert-info">
            <b>注意事项：</b><br />
            1、日期后面红色数字表示当天是星期几。<br />
            2、点击“清除排课”仅删除未上课的排课，不影响已考勤的排课。<br />
        </div>

    </form>
</body>
</html>
