﻿<%@ Page Language="c#" CodeBehind="PeriodTime.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Class.PeriodTime"
    Title="时段设置-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>时间段：<asp:TextBox ID="tbxPeriodTimeName" runat="server"></asp:TextBox></li>
                    <li>组：<asp:DropDownList ID="ddlGroupType" DataTextField="PeriodTimeGroupName" DataValueField="PeriodTimeGroupID" runat="server">
                    </asp:DropDownList></li>
                    <li><span title="时间组管理" data-toggle="tooltip" class="glyphicon glyphicon-edit btn btn-default" data-url="PeriodTimeGroup.aspx" data-action="ref" onclick="openweb(this)"></span></li>
                    <li>
                        <asp:Button ID="btnGo" runat="server" Text="转到" OnClick="btnGo_Click" CssClass="btn btn-default"></asp:Button>
                        <asp:Button ID="btnAdd" runat="server" Text="增加" OnClick="btnAdd_Click" CssClass="btn btn-success"></asp:Button>
                        格式：14:30-17:30               
                        <asp:RegularExpressionValidator ID="_tbxPeriodTimeName" runat="server" Display="Dynamic" ErrorMessage="时间段格式设置错误，注意标点符号一定要在英文模式下完成。"
                            ControlToValidate="tbxPeriodTimeName" ValidationExpression="(((0?[1-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9])))[\-](((0?[0-9])|((1[0-9])|(2[0-4])))[\:]((0?[0-9])|((1|2|3|4|5)[0-9])))$"></asp:RegularExpressionValidator>
                    </li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="PeriodTimeID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="PeriodTimeID" ReadOnly="True" HeaderText="编号" />
                    <asp:TemplateField HeaderText="时间段">
                        <ItemTemplate>
                            <asp:Label ID="labPeriodTimeName" runat="server" Text='<%# Eval("StartTime").ToString() +"-"+Eval("EndTime").ToString() %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <div class="mt-row">
                            <asp:TextBox ID="tbxStartTime" runat="server" Text='<%# Eval("StartTime") %>' Width="100"></asp:TextBox>-<asp:TextBox
                                ID="tbxEndTime" runat="server" Text='<%# Eval("EndTime") %>' Width="100"></asp:TextBox></div>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="组">
                        <ItemTemplate>
                            <%# CacheItems.GetPeriodTimeType(Eval("GroupType"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlGroupType" DataTextField="PeriodTimeGroupName" DataValueField="PeriodTimeGroupID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
