﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="InBatch.aspx.cs" Inherits="MTCUN.Commodity.InBatch"
    Title="入库查询-仓库" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <uc1:ReportServer ID="ReportServer1" runat="server" />
        <div class=" kuai-list">
            <div class=" control_bg">
                单号：<asp:TextBox ID="tbxBatchID" runat="server" AutoComplete="off" onfocus="this.style.imeMode = 'disabled'"></asp:TextBox>
                日期：<asp:TextBox ID="tbxStartDate" runat="server" Width="90px"></asp:TextBox>
                -<asp:TextBox ID="tbxEndDate" runat="server" Width="90px"></asp:TextBox>
                仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
                    DataValueField="StoreroomID">
                </asp:DropDownList>
                    <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
                    <input id="btnBatchDetails" type="button" class="btn btn-default" value="按明细管理" onclick="location = 'InBatchDetails.aspx'" />
            </div>

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="BatchID"
                CssClass="table" OnRowDeleting="GridView1_RowDeleting" Width="100%" OnRowDataBound="GridView1_RowDataBound"
                OnSelectedIndexChanging="GridView1_SelectedIndexChanging">
                <Columns>
                    <asp:TemplateField InsertVisible="False" HeaderText="编号" SortExpression="BatchID">
                        <ItemTemplate>
                            <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                                runat="server" />
                            <asp:LinkButton ID="lbnSelect" runat="server" Text='<%# Eval("BatchID") %>' CommandName="Select" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="TotalAmount" HeaderText="数量" SortExpression="TotalAmount" />
                    <asp:BoundField DataField="TotalPurchasePrice" HeaderText="总进价" SortExpression="TotalPurchasePrice"
                        DataFormatString="{0:c2}" HtmlEncode="False" />
                    <asp:BoundField DataField="DateAndTime" HeaderText="时间" SortExpression="DateAndTime"
                        HtmlEncode="False" />
                    <asp:BoundField DataField="ProviderName" HeaderText="供应商" SortExpression="ProviderName" />
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                            <div class=" lab_button_sub">
                                <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("BatchID")) %>'><div class="inline_block">打印</div></asp:HyperLink>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Remark" HeaderText="备注" SortExpression="Remark" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("PostInBatch.aspx?BatchID={0}&GetURL={1}",Eval("BatchID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除" ShowHeader="False">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" CausesValidation="False" CommandName="Delete"
                                    Text="删除" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div id="divItems" style="display: none">
            <div style="width: 50%; display: none" id="sub">
                <div class="triangle-up"></div>
                <div class=" details">
                    <asp:GridView ID="gvItems" runat="server" AutoGenerateColumns="false">
                        <Columns>
                            <asp:BoundField DataField="CommodityID" HeaderText="编号" ReadOnly="True" />
                            <asp:BoundField DataField="CommodityName" HeaderText="项目" ReadOnly="True" />
                            <asp:TemplateField HeaderText="进价">
                                <ItemTemplate>
                                    <asp:Label ID="labPurchasePrice" runat="server" Text='<%# Bind("PurchasePrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="数量">
                                <ItemTemplate>
                                    <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="合计">
                                <ItemTemplate>
                                    <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="仓库">
                                <ItemTemplate>
                                    <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
