﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="InBatchDetails.aspx.cs"
    Inherits="MTCUN.Commodity.InBatchDetails" Title="入库查询-仓库" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
    <script type="text/javascript"> 
<!--

    function Focus() {
        if (!document.getElementById("tbxBarcode").disabled) {
            document.getElementById("tbxBarcode").style.imeMode = 'disabled';
            document.getElementById("tbxBarcode").focus();
        }
    }

    //--> 
    </script>
</head>
<body onload="Focus();">
    <form id="form1" runat="server">
        <div class=" kuai-list">
        <div class=" control_bg">
            条形码：<asp:TextBox ID="tbxBarcode" runat="server" Width="110px" AutoComplete="off"></asp:TextBox>
            &nbsp;分类：<asp:DropDownList ID="ddlCommodityType" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityTypeName"
                DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
            </asp:DropDownList>
            商品：<asp:DropDownList ID="ddlCommodity" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityName"
                DataValueField="CommodityID">
            </asp:DropDownList>
            仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
                DataValueField="StoreroomID">
            </asp:DropDownList>
            日期：<asp:TextBox ID="tbxStartDate" runat="server" Width="90px"></asp:TextBox>
            -<asp:TextBox ID="tbxEndDate" runat="server" Width="90px"></asp:TextBox>
                <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
                <input id="btnBatchID" type="button" value="按单号管理" class="btn btn-default" onclick="location = 'InBatch.aspx'" />
        </div>

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="BatchItemID"
                CssClass="table" Width="100%" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="BatchID" HeaderText="单号" ReadOnly="True" />
                    <asp:BoundField DataField="CommodityName" HeaderText="商品" ReadOnly="True" />
                    <asp:TemplateField HeaderText="进价">
                        <ItemTemplate>
                            <asp:Label ID="labPurchasePrice" runat="server" Text='<%# Bind("PurchasePrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="数量">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="合计">
                        <ItemTemplate>
                            <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="仓库">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" HeaderText="时间" SortExpression="DateAndTime"
                        HtmlEncode="False" />
                    <asp:BoundField DataField="ProviderName" HeaderText="供应商" SortExpression="ProviderName" />
                    <asp:BoundField DataField="Remark" HeaderText="备注" SortExpression="Remark" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("PostInBatch.aspx?BatchID={0}&GetURL={1}",Eval("BatchID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
