﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PostOutBatch.aspx.cs" Inherits="MTCUN.Commodity.PostOutBatch"
    Title="退回公司-仓库" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript"> 
<!--

    function Focus() {
        if (!document.getElementById("tbxBarcode").disabled) {
            document.getElementById("tbxBarcode").style.imeMode = 'disabled';
            document.getElementById("tbxBarcode").focus();
        }
    }

    //--> 
    </script>

    <script type="text/javascript">
        function NoDataTips() {
            var _billItems = document.getElementById("BatchItems");
            if (_billItems.innerText.trim() == "") {
                _billItems.innerHTML = "<span style='color:red'>*</span>请增加项目。";
            }
        }
    </script>
</head>
<body onload="Focus();NoDataTips()">
    <form id="form1" runat="server">


        <div class=" kuai-show form">
            <span class="form_title">已选项目</span>
            <div class="striking_head mt-row">
                条形码：<asp:TextBox ID="tbxBarcode" runat="server" Width="90px" AutoComplete="off"></asp:TextBox>
                <asp:DropDownList ID="ddlCommodityType" runat="server" DataTextField="CommodityTypeName"
                    DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
                </asp:DropDownList>
                <asp:DropDownList ID="ddlCommodity" runat="server" DataTextField="CommodityName"
                    DataValueField="CommodityID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodity_SelectedIndexChanged">
                </asp:DropDownList>
                进价：<asp:TextBox ID="tbxPurchasePrice" runat="server" Width="80px"></asp:TextBox>
                数量：<asp:TextBox ID="tbxAmount" runat="server" Width="80px"></asp:TextBox>
                <asp:Label ID="labUnitName" runat="server"></asp:Label>
                仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
                    DataValueField="StoreroomID">
                </asp:DropDownList>
                <asp:Button ID="btnAddItem" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAddItem_Click" />
            </div>

            <div class="striking_content">
                <div style="width: 80%" id="BatchItems">
                    <div class="triangle-up"></div>
                    <div class=" details">
                        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table table-hover"
                            DataKeyNames="BatchItemID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                            OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting">
                            <Columns>
                                <asp:BoundField DataField="CommodityID" ReadOnly="True" HeaderText="商品编号" />
                                <asp:TemplateField HeaderText="商品名称">
                                    <ItemTemplate>
                                        <asp:Label ID="labCommodityName" runat="server" Text='<%# Eval("CommodityName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="进价">
                                    <ItemTemplate>
                                        <asp:Label ID="labPurchasePrice" runat="server" Text='<%# Eval("PurchasePrice","{0:c2}") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="tbxPurchasePrice" runat="server" Text='<%# Eval("PurchasePrice") %>'
                                            Width="80"></asp:TextBox>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="数量">
                                    <ItemTemplate>
                                        <asp:Label ID="labAmount" runat="server" Text='<%# Eval("Amount") %>'></asp:Label>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="tbxAmount" runat="server" Text='<%# Eval("Amount") %>' Width="80"></asp:TextBox>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="单位">
                                    <ItemTemplate>
                                        <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="合计">
                                    <ItemTemplate>
                                        <asp:Label ID="labTotalPrice" runat="server" Text='<%# Eval("TotalPrice","{0:c2}") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="仓库">
                                    <ItemTemplate>
                                        <asp:Label ID="labStoreroomName" runat="server" Text='<%# Eval("StoreroomName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="编辑">
                                    <ItemTemplate>
                                        <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                                        <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                                    </EditItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="删除">
                                    <ItemTemplate>
                                        <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete"></asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                </div>
            </div>


            <table class="table">
                <tr>
                    <th colspan="2" style="text-align: left">退货单
                    </th>
                </tr>
                <tr>
                    <td>单号：
                    </td>
                    <td class="required mt-row">
                        <asp:TextBox ID="tbxBatchID" runat="server" Width="184px" Enabled="False"></asp:TextBox>
                        <asp:CheckBox
                            ID="cbxAutoID" runat="server" AutoPostBack="True" Checked="True" OnCheckedChanged="cbxAutoID_CheckedChanged"
                            Text="自动" />
                    </td>
                </tr>
                <tr>
                    <td>日期：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>供货商：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlProvider" runat="server" DataTextField="ProviderName" DataValueField="ProviderID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>总数量：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxTotalAmount" runat="server" ReadOnly="True"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>总价值：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxTotalPurchasePrice" runat="server" ReadOnly="True"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>备注：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxRemark" runat="server" Width="387px" Height="53px" TextMode="MultiLine"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>录入员：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <asp:Button ID="btnPost" runat="server" CssClass="btn btn-default" Text="确定退货" OnClick="btnPost_Click" />
                        <label class="btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                            返回
                        </label>
                    </td>
                </tr>
            </table>
        </div>
    </form>
</body>
</html>
