﻿<%@ Page Language="c#" CodeBehind="StoCommodity.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Commodity.StoCommodity"
    Title="库存管理-仓库" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript"> 
<!--

        function Focus() {
            if (!document.getElementById("tbxBarcode").disabled) {
                document.getElementById("tbxBarcode").style.imeMode = 'disabled';
                document.getElementById("tbxBarcode").focus();
            }
        }

//--> 
    </script>
</head>
<body onload="Focus();">
    <form id="Form1" method="post" runat="server" defaultbutton="btnGoto">
        <div class=" kuai-list">
        <div class=" control_bg">

        条形码：<asp:TextBox ID="tbxBarcode" runat="server" AutoComplete="off"></asp:TextBox>
        &nbsp;分类：<asp:DropDownList ID="ddlCommodityType" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityTypeName"
            DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
        </asp:DropDownList>
        商品：<asp:DropDownList ID="ddlCommodity" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityName"
            DataValueField="CommodityID">
        </asp:DropDownList>
        仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
            DataValueField="StoreroomID">
        </asp:DropDownList>
            <asp:Button ID="btnGoto" runat="server" CssClass="btn btn-default" Text="查询" OnClick="btnGoto_Click"></asp:Button>
    </div>

        <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
            DataKeyNames="CommodityID" OnRowDataBound="GridView1_RowDataBound">
            <Columns>
                <asp:TemplateField InsertVisible="False" HeaderText="商品编号" SortExpression="CommodityID">
                    <ItemTemplate>
                        <%# Eval("CommodityID") %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品名称">
                    <ItemTemplate>
                        <%# Eval("CommodityName") %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="总量">
                    <ItemTemplate>
                        <asp:Label ID="labAmount" runat="server" Text='<%# Eval("Amount") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="StoreroomName" HeaderText="仓库" />
                <asp:BoundField DataField="StoCommodity_Amount" HeaderText="库存" ItemStyle-ForeColor="Red"
                    ItemStyle-Font-Bold="true" ReadOnly="True" SortExpression="StoCommodity_Amount" />
                <asp:TemplateField HeaderText="警示数" SortExpression="WarnAmount">
                    <ItemTemplate>
                        <asp:Label ID="Label5" runat="server" Text='<%# Bind("WarnAmount") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="单位">
                    <ItemTemplate>
                        <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="分类">
                    <ItemTemplate>
                        <asp:Label ID="labCommodityTypeName" runat="server" Text='<%# Eval("CommodityTypeName") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                        <%# (int)Eval("LockState") == 0 ? "禁用" : "启用"%>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>

        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
    </div>
    <div id="divItems" style="visibility: hidden">
        <div style="width: 50%">
            <asp:GridView ID="gvItems" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StoCommodityID">
                <Columns>
                    <asp:BoundField DataField="StoreroomID" ReadOnly="True" HeaderText="仓库编号" />
                    <asp:TemplateField HeaderText="隶属仓库">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="库存">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
    </div>
    </form>
</body>
</html>
