﻿<%@ Import Namespace="MTCUN" %>

<%@ Page Language="c#" CodeBehind="Storeroom.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Commodity.Storeroom"
    Title="仓库设置-仓库" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
        <div class=" control_bg">

            仓库名称：<asp:TextBox ID="tbxStoreroomName" runat="server"></asp:TextBox>所属校区：<asp:DropDownList
                ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>" DataTextField="SchoolName"
                DataValueField="SchoolID">
            </asp:DropDownList>
                <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click"></asp:Button>
        </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StoreroomID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="StoreroomID" ReadOnly="True" HeaderText="仓库编号" />
                    <asp:TemplateField HeaderText="仓库名称">
                        <ItemTemplate>
                            <asp:Label ID="labStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxStoreroomName" runat="server" Text='<%# Bind("StoreroomName") %>'
                                Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="电话">
                        <ItemTemplate>
                            <asp:Label ID="labTel" runat="server" Text='<%# Bind("Tel") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxTel" runat="server" Text='<%# Bind("Tel") %>' Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="地址">
                        <ItemTemplate>
                            <asp:Label ID="labAddress" runat="server" Text='<%# Bind("Address") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxAddress" runat="server" Text='<%# Bind("Address") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="可销售">
                        <ItemTemplate>
                            <%# Rs.Items.GetYN((int)Eval("Sell"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlSell" SelectedIndex='<%# Eval("Sell") %>'>
                                <asp:ListItem Value="0" Selected="True" Text="否"></asp:ListItem>
                                <asp:ListItem Value="1" Text="是"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                                <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%# Eval("SchoolName") %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                                SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CssClass="btn btn-default" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CssClass="btn btn-default" CommandName="Update"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CssClass="btn btn-default" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
