﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TuneOutList.aspx.cs" Inherits="MTCUN.Commodity.TuneOutList"
    Title="调拨查询-仓库" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register src="../UserCol/ReportServer.ascx" tagname="ReportServer" tagprefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript"> 
<!--

    function Focus() {
        if (!document.getElementById("tbxBarcode").disabled) {
            document.getElementById("tbxBarcode").style.imeMode = 'disabled';
            document.getElementById("tbxBarcode").focus();
        }
    }

    //--> 
    </script>
</head>
<body onload="Focus();">
    <form id="form1" runat="server">
        <uc1:ReportServer ID="ReportServer1" runat="server" />
        <div class=" kuai-list">
            <div class=" control_bg">
                条形码：<asp:TextBox ID="tbxBarcode" runat="server" Width="110px" AutoComplete="off"></asp:TextBox>
                &nbsp;分类：<asp:DropDownList ID="ddlCommodityType" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityTypeName"
                    DataValueField="CommodityTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCommodityType_SelectedIndexChanged">
                </asp:DropDownList>
                商品：<asp:DropDownList ID="ddlCommodity" runat="server" CssClass="mt-dropdownlist" DataTextField="CommodityName"
                    DataValueField="CommodityID">
                </asp:DropDownList>
                仓库：<asp:DropDownList ID="ddlStoreroom" runat="server" DataTextField="StoreroomName"
                    DataValueField="StoreroomID">
                </asp:DropDownList>
                日期：<asp:TextBox ID="tbxStartDate" runat="server" Width="79px"></asp:TextBox>
                -<asp:TextBox ID="tbxEndDate" runat="server" Width="79px"></asp:TextBox>
                    <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
            </div>

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table"
                DataKeyNames="TuneOutID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="CommodityID" HeaderText="商品编号" />
                    <asp:BoundField DataField="CommodityName" HeaderText="商品名称" />
                    <asp:BoundField DataField="StoreroomName" HeaderText="调出仓库" />
                    <asp:BoundField DataField="ToStoreroomName" HeaderText="调入仓库" />
                    <asp:BoundField DataField="DateAndTime" HeaderText="日期" />
                    <asp:BoundField DataField="Amount" HeaderText="调出数量" />
                    <asp:BoundField DataField="Remark" HeaderText="备注" />
                    <asp:BoundField DataField="TrueName" HeaderText="录入员" />
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkPrint" runat="server" CssClass="glyphicon glyphicon-print btn btn-default" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("TuneOutID")) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑" ShowHeader="False">
                        <ItemTemplate>
                                <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("PostTuneOut.aspx?TuneOutID={0}&StoCommodityID={1}&GetUrl={2}",Eval("TuneOutID"),Eval("StoCommodityID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
