﻿<%@ Import Namespace="MTCUN" %>

<%@ Page Language="c#" CodeBehind="Status.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.ConsultManage.Status"
    Title="客户状态-顾问管理" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1 {
            color: #FF0000;
        }
    </style>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class="kuai-list">

            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>状态名称：</li>
                    <li>
                        <asp:TextBox ID="tbxStatusName" runat="server"></asp:TextBox></li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click"></asp:Button></li>
                    <li>
                        <asp:Button ID="btnReason" runat="server" CssClass="btn btn-default" Text="回访简述设置" OnClick="btnReason_Click" /></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StatusID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowCommand="GridView1_RowCommand"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="StatusID" ReadOnly="True" HeaderText="状态编号" />
                    <asp:TemplateField HeaderText="状态名称">
                        <ItemTemplate>
                            <asp:Label ID="labStatusName" runat="server" Text='<%# Bind("StatusName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxStatusName" runat="server" Text='<%# Bind("StatusName") %>' Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="下次回访间隔（天）">
                        <ItemTemplate>
                            <asp:Label ID="labNextReplyDays" runat="server" Text='<%# Bind("NextReplyDays") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxNextReplyDays" runat="server" Text='<%# Bind("NextReplyDays") %>' Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                                <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、<span class="style1">【潜在、成功、战败】是系统内置项目，不可改变它的意义，否则会造成严重后果。</span><br />
        </div>
    </form>
</body>
</html>
