﻿<%@ Page Language="c#" CodeBehind="StatusReason.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.ConsultManage.StatusReason"
    Title="回访内容简述-顾问管理" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class="kuai-list">

            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>回访简述：</li>
                    <li>
                        <asp:TextBox ID="tbxStatusReasonName" runat="server"></asp:TextBox></li>
                    <li>分组：</li>
                    <li>
                        <asp:DropDownList runat="server" ID="ddlStatus">
                        </asp:DropDownList></li>
                    <li>
                        <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click"></asp:Button></li>
                    <li style="display:none">
                        <asp:HyperLink ID="hlkUp" runat="server" CssClass="btn btn-warning" Text="返回上级" /></li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StatusReasonID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
                OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
                OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="StatusReasonID" ReadOnly="True" HeaderText="编号" HeaderStyle-Width="10%" />
                    <asp:BoundField DataField="StatusReasonName" HeaderText="回访简述" ItemStyle-Width="50%"
                        ControlStyle-Width="95%" />
                    <asp:TemplateField HeaderText="组">
                        <ItemTemplate>
                            <%# GetStatusName((int)Eval("StatusID"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlStatus">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                <asp:ListItem Value="0" Selected="True" Text="禁用"></asp:ListItem>
                                <asp:ListItem Value="1" Text="启用"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <%--<asp:CommandField HeaderText="编辑" EditText="编辑" CancelText="取消" UpdateText="更新" ShowEditButton="true" />--%>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <div class="lab_button_sub" id="divEdit" runat="server">
                                <asp:LinkButton ID="lbnEdit" runat="server" Text="编辑" CommandName="Edit"></asp:LinkButton>
                            </div>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <div class="lab_button_sub">
                                <asp:LinkButton ID="lbnUpdate" runat="server" Text="更新" CommandName="Update"></asp:LinkButton>
                            </div>
                            <div class="lab_button_sub">
                                <asp:LinkButton ID="lbnCancel" runat="server" Text="取消" CommandName="Cancel"></asp:LinkButton>
                            </div>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <div class="lab_button_sub" id="divDelete" runat="server">
                                <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                            </div>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、回访简述是对回访内容进行简要说明，方便后期报表分组分析。<br />
            2、回访简述同时可以对用户状态级别做进一步的细化。比如状态为：战败，我们可以描述战败具体原因，方便做进一步分析、发现学校存在的问题。<br />

        </div>
    </form>
</body>
</html>
