﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="FoundStu.aspx.cs" Inherits="MTCUN.Consultant.FoundStu"
    Title="查找咨询归属-顾问" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">

        <div class="kuai-show">
            <table class="table">
                <thead>
                    <tr>
                        <th colspan="2">查找咨询归属
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>校区：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlSchool" CssClass="mt-dropdownlist" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>姓名：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxStudentName" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>电话/手机号：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxTel" runat="server" Width="160px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <asp:Button ID="btnSelect" CssClass="btn btn-default" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                    </td>
                </tr>
            </table>
        </div>

        <div class="kuai-list">
            <asp:Label ID="labTitle" runat="server" Text="潜在学员信息" Visible="false" Font-Bold="true"></asp:Label>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="PotentialID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="咨询号">
                        <ItemTemplate>
                            <asp:Label ID="labPotentialID" runat="server" Text='<%# Eval("PotentialID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="姓名">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labPotentialName" ForeColor='<%# Convert.ToInt32(Eval("StatusID")) == 3 ? System.Drawing.Color.ForestGreen:System.Drawing.Color.Black%>'
                                Text='<%#Eval("PotentialName")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="来源">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labSourceType" Text='<%#Rs.Items.GetSourceType(Eval("SourceType"))%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="CourseName" ReadOnly="True" HeaderText="课程" />
                    <asp:BoundField DataField="DateAndTime" ReadOnly="True" HeaderText="咨询日期" />
                    <asp:TemplateField HeaderText="客户状态">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labStatusName" Text='<%# Eval("StatusName") %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="咨询顾问">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labTrueName" Text='<%#Eval("TrueName") %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="最后回访信息">
                        <ItemTemplate>
                            <%#Eval("LastPostName")%>|<%#Eval("LastPostTime")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="回访">
                        <ItemTemplate>
                            <a href='Reply.aspx?PotentialID=<%#Eval("PotentialID")%>&GetURL=<% = swq.Web.PathAndQuery() %>' class="btn btn-default">回访
                                                                <span class="badge">
                                                                    <%#Eval("ReCount")%>
                                                                </span>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>

            <asp:Label ID="labTitle2" runat="server" Text="正式学员信息" Visible="false" Font-Bold="true"></asp:Label>

            <asp:GridView ID="GridView2" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StudentID" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="学号">
                        <ItemTemplate>
                            <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="姓名">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labStudentName" Text='<%#Eval("StudentName")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="隶属顾问">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labConsultantName" Text='<%#Eval("ConsultantName")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员关怀">
                        <ItemTemplate>
                            <a href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>' class="btn btn-default">关怀
                                                                    <span class="badge">
                                                                        <%#Eval("ReCount")%>
                                                                    </span>
                            </a>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>


    </form>
    <div class="alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、此功能用于值班时有正式/潜在学员电话来访，我们需要暂时释放权限让值班人员将学员来访信息记录下来。<br />
        2、使用方法：按姓名/电话查询学员信息，如果是潜在学员，找到后点击“回访”登记来访信息，如果是正式学员点击“关怀”登记来访信息。<br />
    </div>
</body>
</html>
