﻿<%@ Page Language="c#" CodeBehind="StudentList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Consultant.StudentList"
    Title="我的正式学员-顾问" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }



        function Send() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("StudentID").value = StudentID;
                document.formStudent.action = "../media/sms/SendToStudent.aspx?geturl=" + location.href;
                document.formStudent.submit();
            }
        }
    </script>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>ＩＤ卡号：</li>
                    <li>
                        <asp:TextBox ID="tbxSignInID" runat="server" Width="114px"></asp:TextBox>
                    </li>
                    <li>学号：</li>
                    <li>
                        <asp:TextBox ID="tbxStudentID" runat="server" Width="84px"></asp:TextBox></li>
                    <li>姓名：</li>
                    <li>
                        <asp:TextBox ID="tbxStudentName" runat="server" Width="88px"></asp:TextBox></li>
                    <li>电话：</li>
                    <li>
                        <asp:TextBox ID="tbxTel" runat="server" Width="94px"></asp:TextBox></li>
                    <li>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList></li>
                    <li>
                        <asp:Button ID="btnSelect" CssClass="btn btn-success" runat="server" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                    </li>
                </ul>





            </div>
            <br />
            <div class=" control_bg">
                <ul class="mt-listitems">
                    <li>
                        <div class="input-group" style="width: 100px; border-spacing: 0px">
                            <span class="input-group-addon">
                                <input id="input-2" type="checkbox" onclick="Checks(this)" /></span>
                            <label for="input-2" class="form-control">全选</label>
                        </div>
                    </li>
                    <li>
                        <asp:HyperLink ID="hlkSMS" CssClass="btn btn-default" runat="server" NavigateUrl='<%#string.Format("javascript:Send();void(0);") %>'
                            Text="发短信" />
                    </li>
                </ul>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass=" table table-hover" AutoGenerateColumns="False"
                DataKeyNames="StudentID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="学号">
                        <ItemTemplate>
                            <span runat="server" id="spanBox">
                                <input type="checkbox" id="id" value='<%#Eval("StudentID")%>' /></span>
                            <asp:Label ID="labStudentID" runat="server" Text='<%# Eval("StudentID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员">
                        <ItemTemplate>
                            <%#Eval("StudentName")%><%# (Convert.IsDBNull(Eval("Byname")) || Eval("Byname").ToString().Trim() == "") ? "" : "(" + Eval("Byname").ToString() + ")"%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类别">
                        <ItemTemplate>
                            <%#CacheItems.GetStudentType(Eval("StudentType"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" DataFormatString="{0:d}" HeaderText="报名日期" />
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%#Eval("SchoolName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="可用余额">
                        <ItemTemplate>
                            <%#Eval("AvailableMoney", "{0:c2}")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="最新选班">
                        <ItemTemplate>
                            <%#Eval("LastClassName")%>
                        (<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>)
                            <label class="lab_button_sub">
                                <asp:HyperLink ID="hlkStuClass" runat="server" CssClass="btn btn-default" Text="查看" NavigateUrl='<%# string.Format("StuClass.aspx?StudentID={0}&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                            </label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员关怀信息">
                        <ItemTemplate>
                            <ul class="mt-listitems">
                                <li>
                                    <div title='<%# "内容：" + swq.Tools.GetSingleText(Eval("LastPostContent")) +" 日期："+ Eval("LastPostTime") +" 员工："+ Eval("LastPostName")%>' style="float: left; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 120px">
                                        <%#swq.Tools.GetSingleText(Eval("LastPostContent"))%>|<%#Eval("LastPostTime")%>
                                    </div>
                                </li>
                                <li><a class="btn btn-default" href='StuReply.aspx?StudentID=<%#Eval("StudentID")%>&GetURL=<% = swq.Web.PathAndQuery() %>'>关怀                                <span class="badge">
                                    <%#Eval("ReCount")%>
                                </span></a></li>
                            </ul>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="咨询管理">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkSP" CssClass="btn btn-default" runat="server" Text="管理" NavigateUrl='<%# string.Format("StuPotentials.aspx?StudentID={0}&PageIndex=5&GetURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="printWeb">
            <iframe id="PrintWeb" width="0" height="0"></iframe>
        </div>
    </form>
    <!--短信Post传递参数代码S-->
    <form id="formStudent" name="formStudent" method="post">
        <input id="StudentID" name="StudentID" type="hidden" value="" />
    </form>
    <!--短信Post传递参数代码E-->
    <div class=" alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、我的正式学员是指，学员正式报名时，咨询顾问填的是我才是显示在这里。<br />
        2、由于潜在学员管理与正式学员管理是分开的系统，由于软件设置不同或者人为操作，我的潜在学员正式报名后，不一定出现在“我的正式学员”里，可联系系统管理员或上级主管修正。<br />
    </div>
</body>
</html>
