﻿<%@ Page Language="C#" AutoEventWireup="True" CodeBehind="BasicLessonShow.aspx.cs" Inherits="MTCUN.EasyAnalyzer.BasicLessonShow" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>老师课时提成原数据</title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id.substring(0, 10) == "cblColumn_") {
                    e.checked = checkbox.checked;
                }
            }
        }
    </script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class="kuai-show">
            <table class="table" cellspacing="0" cellpadding="0">
                <thead>
                    <tr>
                        <th colspan="2">
                            <asp:Label ID="labTeacherName" runat="server" ForeColor="Red"></asp:Label>
                            老师课时提成原数据
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>校区：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>班级类型：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlClassType" runat="server">
                            <asp:ListItem Value="-1" Text=""></asp:ListItem>
                            <asp:ListItem Value="1">一对一</asp:ListItem>
                            <asp:ListItem Value="0">一对多</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>上课类型：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlLessonType" runat="server">
                            <asp:ListItem Value="-1" Text=""></asp:ListItem>
                            <asp:ListItem Value="1">正常</asp:ListItem>
                            <asp:ListItem Value="0">补课</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>量化方式：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlQuantifyType" runat="server">
                            <asp:ListItem Value="-1" Text=""></asp:ListItem>
                            <asp:ListItem Value="1">课时</asp:ListItem>
                            <asp:ListItem Value="2">到期时间</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>时间范围：
                    </td>
                    <td class="mt-row">
                        <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                        -<asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                        <asp:Button ID="btnWeek" runat="server" CssClass="btn btn-default" Text="本周" OnClick="btnWeek_Click" />
                        <asp:Button ID="btnMonth" runat="server" CssClass="btn btn-default" Text="本月" OnClick="btnMonth_Click" />
                        <asp:Button ID="btnYear" runat="server" CssClass="btn btn-default" Text="本年" OnClick="btnYear_Click" />
                        <asp:Button ID="btnPrevMonth" runat="server" CssClass="btn btn-default" Text="上月" OnClick="btnPrevMonth_Click" />
                        <asp:Button ID="btnNextMonth" runat="server" CssClass="btn btn-default" Text="下月" OnClick="btnNextMonth_Click" />
                    </td>
                </tr>
                <tr>
                    <td>明细类型：</td>
                    <td>
                        <asp:DropDownList ID="ddlDetailsType" runat="server" AutoPostBack="True"
                            OnSelectedIndexChanged="ddlDetailsType_SelectedIndexChanged">
                            <asp:ListItem Value="1">按班级分组</asp:ListItem>
                            <asp:ListItem Value="2">按排课显示</asp:ListItem>
                            <asp:ListItem Value="3">按考勤显示</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>字段选择：
                    </td>
                    <td>
                        <table border="0" class="mt-boxlist inline_block">
                            <tr>
                                <td>
                                    <input onclick="Checks(this)" type="checkbox" checked="checked" id="boxall" /><label for="boxall">全选</label>
                                </td>
                            </tr>
                        </table>
                        <div class="inline_block">
                            <asp:CheckBoxList ID="cblColumn" runat="server" CssClass="mt-boxlist" RepeatDirection="Horizontal" RepeatColumns="6">
                            </asp:CheckBoxList>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <asp:Button ID="btnAcc" runat="server" CssClass="btn btn-default" Text="计算" OnClick="btnAcc_Click" />
                        <asp:Button ID="btnExportExcel" runat="server" CssClass="btn btn-default" OnClick="btnExportExcel_Click" Text="导出EXCEL"
                            ToolTip="ExportExcel" />
                    </td>
                </tr>
            </table>
        </div>
        <div class="kuai-show">
            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                AllowSorting="True" OnSorting="GridView1_Sorting">
            </asp:GridView>
        </div>
        <br />
        <br />
        <div class="alert alert-info mt-remark">
            <b>注意事项：<br />
            </b>
            <br />
            1、课次：指一次排课或一次上下课，一般用于解释考勤。<br />
            2、课时：将课程分成N个时间相等的单元，每个单元就是1课时，一般用于量化课程的进度。（公式：1课次=N课时，1课时=N分钟）<br />
            3、小时数：上课的总时长用小时制表示。<br />
            4、总人次（课次）：每次上课正常出勤人数的总和。<br />
            5、总人次（课时）：每次上课正常出勤人数乘以本次课课时数的总和。
         
        <br />
            6、每课时提成：指班级基本信息上的【每课时提成】字段值。<br />
            7、每课时分钟数：指班级基本信息上的【每课时分钟数】字段值。<br />
            8、班级总课次费： 上课总课次乘以【每课时提成】。<br />
            9、班级总课时费： 上课总课时乘以【每课时提成】。<br />
            10、班级总小时费： 上课总小时乘以【每课时提成】。<br />
            11、消耗学费： 每课次消耗学员的学费总和。（系统需开启高精度课时计算，对按课时数进行量化的课程高度精准，按到期时间量化的准确率不高）<br />
            12、上课类型： 
        0表示补课，1表示正常上课。<br />
        </div>
    </form>
</body>
</html>
