﻿<%@ Page Language="c#" CodeBehind="BillDetails.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Finance.BillDetails"
    Title="消费单-财务" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>财务-利润管理</title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
    <form id="Form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                校区：<asp:DropDownList ID="ddlSchool" DataTextField="SchoolName" DataValueField="SchoolID"
                    runat="server" AutoPostBack="True">
                </asp:DropDownList>
                <asp:DropDownList ID="ddlType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlType_SelectedIndexChanged">
                    <asp:ListItem Value="0">全部显示</asp:ListItem>
                    <asp:ListItem Value="1">显示含欠费单</asp:ListItem>
                    <asp:ListItem Value="2">显示已补交单</asp:ListItem>
                    <asp:ListItem Value="3">显示钱包支付单</asp:ListItem>
                </asp:DropDownList>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="BillItemID" OnRowDataBound="GridView1_RowDataBound" OnRowEditing="GridView1_RowEditing"
                OnRowUpdating="GridView1_RowUpdating" OnRowCancelingEdit="GridView1_RowCancelingEdit">
                <SelectedRowStyle CssClass="selected" />
                <Columns>
                    <asp:TemplateField HeaderText="学员">
                        <ItemTemplate>
                            <asp:Label ID="labClientName" runat="server" Text='<%# Bind("StudentName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="项目">
                        <ItemTemplate>
                            <asp:Label ID="labProductName" runat="server" Text='<%# Eval("ProductName") + ContinueReg(Eval("ContinueReg"),Eval("ProductType"),Eval("BillTypeID"))%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime","{0:d}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单号">
                        <ItemTemplate>
                            <asp:Label ID="labBillID" runat="server" Text='<%# Bind("BillID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="数量">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Eval("Amount","{0:0.##}") %>'></asp:Label><asp:Label ID="labUnitName" runat="server" Text='<%# Bind("UnitName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="优惠">
                        <ItemTemplate>
                            <%# ((decimal)Eval("Discount")).ToString("c2")  %>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label ID="labBillTypeID" runat="server" Text='<%#(int)Eval("BillTypeID") == 1 ? "售出" : "退货"%>' ForeColor='<%#(int)Eval("BillTypeID") == 1 ? System.Drawing.Color.Black : System.Drawing.Color.Red%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="欠费">
                        <ItemTemplate>
                            <asp:Label ID="labArrearage" runat="server" Text='<%#((decimal)Eval("Arrearage")).ToString("c2")%>' ForeColor='<%# (decimal)Eval("Arrearage") > 0 ? System.Drawing.Color.Red: System.Drawing.Color.Black %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="支付方式">
                        <ItemTemplate>
                            <asp:Label ID="labPayMethod" runat="server" Text='<%#Eval("PayMethodName")%>' ForeColor='<%# (int)Eval("PayMethodID") == 2 ? System.Drawing.Color.Red: System.Drawing.Color.Black %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="合计">
                        <ItemTemplate>
                            <asp:Label ID="labAll" runat="server" Text='<%#( (decimal)Eval("Amount") * (decimal)Eval("UnitPrice") + (decimal)Eval("Discount")).ToString("c2")  %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="分享/利润">
                        <ItemTemplate>
                            <%# GetCakePer(Eval("CakeMoney"),Eval("Profit")) %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox runat="server" ID="tbxProfit" Text='<%# Eval("Profit","{0:f2}") %>' Width="60px"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>

                    <asp:TemplateField HeaderText="备注">
                        <ItemTemplate>
                            <%# Eval("BIRemark") %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox runat="server" ID="tbxRemark" Text='<%# Eval("BIRemark") %>' Width="80px"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="分蛋糕者">
                        <ItemTemplate>
                            <asp:Label ID="labCake" runat="server" Text='<%#Eval("CakeText")  %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="利润">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="设置" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="分享">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkCake" runat="server" CssClass="btn btn-default" Text='分享' NavigateUrl='<%# string.Format("cake.aspx?billitemid={0}&profit={1}&GetURL={2}",Eval("BillItemID"), Eval("Profit","{0:f2}"),Server.UrlEncode(Request.Url.PathAndQuery)) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="学员">
                        <ItemTemplate>
                                <asp:HyperLink ID="hlkShow" runat="server" CssClass="btn btn-default" Text='学员' onclick='<%# url((int)Eval("StudentID")) %>' NavigateUrl='#' />
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、操作方法：先设置利润，再进行分享。<br />
            2、支付方式为“钱包”可能是转班或退学产生的余额消费，分提成时严格检查，以免重复计算。<br />
            3、欠费状态时注意是否欠费部分暂不算提成，补交时再结算。<br />
            4、退费单请使用负数利润，负数提成金额。<br />
        </div>

    </form>
</body>
</html>
