﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Cake.aspx.cs" Inherits="MTCUN.Finance.Cake" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>财务-分蛋糕</title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class="striking">
                <table style="border-collapse: separate; border-spacing: 3px 3px">
                    <tr>
                        <td>总利润：</td>
                        <td>
                            <asp:Label ID="labFee" runat="server" Font-Size="X-Large" ForeColor="Red"></asp:Label></td>
                        <td>
                            <asp:HyperLink ID="hlkControlPanel" runat="server" CssClass="btn btn-warning" Text="控制面板" />
                        </td>
                        <td class="mt-row">成交顾问：<asp:DropDownList ID="ddlConsult" runat="server">
                        </asp:DropDownList><div class="btn btn-default" style="display: none; visibility: hidden">查看</div>
                        </td>
                        <td class="mt-row">回访者：<asp:DropDownList ID="ddlReply" runat="server">
                        </asp:DropDownList><div class="btn btn-default" style="display: none">查看</div>
                        </td>
                        <td class="mt-row">正式顾问：<asp:Label ID="labConsult" runat="server"></asp:Label>
                        </td>
                        <td class="mt-row">主讲/助教：<asp:DropDownList ID="ddlTeacher" runat="server">
                        </asp:DropDownList><div class="btn btn-default" style="display: none">查看</div>
                        </td>
                    </tr>
                </table>
            </div>
            <br />
            <div class=" control_bg">
                员工：<asp:DropDownList ID="ddlUser" DataTextField="TrueName" DataValueField="UserID" runat="server">
                </asp:DropDownList>
                比例：<asp:DropDownList ID="ddlRatio" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlRatio_SelectedIndexChanged">
                    <asp:ListItem Value="0.01">1%</asp:ListItem>
                    <asp:ListItem Value="0.02">2%</asp:ListItem>
                    <asp:ListItem Value="0.03">3%</asp:ListItem>
                    <asp:ListItem Value="0.04">4%</asp:ListItem>
                    <asp:ListItem Value="0.05">5%</asp:ListItem>
                    <asp:ListItem Value="0.06">6%</asp:ListItem>
                    <asp:ListItem Value="0.07">7%</asp:ListItem>
                    <asp:ListItem Value="0.08">8%</asp:ListItem>
                    <asp:ListItem Value="0.09">9%</asp:ListItem>
                    <asp:ListItem Value="0.10">10%</asp:ListItem>
                    <asp:ListItem Value="0.15">15%</asp:ListItem>
                    <asp:ListItem Value="0.20">20%</asp:ListItem>
                    <asp:ListItem Value="0.30">30%</asp:ListItem>
                    <asp:ListItem Value="0.40">40%</asp:ListItem>
                </asp:DropDownList>
                金额：<asp:TextBox ID="tbxCakeMoney" runat="server"></asp:TextBox>
                所属校区：<asp:DropDownList ID="ddlSchool" DataTextField="SchoolName" DataValueField="SchoolID" runat="server">
                </asp:DropDownList>
                <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click" />
            </div>
            <br />
            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="CakeID" OnRowDeleting="GridView1_RowDeleting"
                OnRowDataBound="GridView1_RowDataBound" OnRowCancelingEdit="GridView1_RowCancelingEdit"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
                EnableModelValidation="True">
                <SelectedRowStyle CssClass="selected" />
                <Columns>
                    <asp:TemplateField HeaderText="编号">
                        <ItemTemplate>
                            <%#Eval("CakeID")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="员工">
                        <ItemTemplate>
                            <%#Eval("ToTrueName")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" ReadOnly="false" HeaderText="日期" />
                    <asp:TemplateField HeaderText="金额">
                        <ItemTemplate>
                            <asp:Label ID="labCakeMoney" runat="server" Text='<%# Eval("CakeMoney","{0:c2}")%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:TextBox ID="tbxCakeMoney" runat="server" Text='<%# Eval("CakeMoney","{0:f2}")%>'
                                    Width="110"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                                        <asp:TemplateField HeaderText="比例">
                        <ItemTemplate>
                            <asp:Label ID="labRatio" runat="server" Text='<%# Eval("Ratio","{0:f2}")%>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:TextBox ID="tbxRatio" runat="server" Text='<%# Eval("Ratio","{0:f2}")%>'
                                    Width="110"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <%--<asp:BoundField DataField="Ratio" ReadOnly="false" HeaderText="比例" />--%>
                    <asp:BoundField DataField="TrueName" ReadOnly="True" HeaderText="经办人" />
                    <asp:BoundField DataField="SchoolName" ReadOnly="True" HeaderText="所属校区" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("UserID")%>'
                                OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

        </div>

        <div class="mt-back">
            <label class="btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
    </form>
</body>
</html>
