﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="IncomeList.aspx.cs" Inherits="MTCUN.Finance.IncomeList"
    Title="帐目列表-财务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-show form">

            <table class="table" cellspacing="0">
                <tr>
                    <th colspan="2">账目查询
                    </th>
                </tr>
                <tr>
                    <td>入帐日期：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                        -<asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>校区：
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>类型：</td>
                    <td>
                        <asp:DropDownList ID="ddlIncome" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlIncome_SelectedIndexChanged">
                            <asp:ListItem Value="-1" Text=" "></asp:ListItem>
                            <asp:ListItem Value="0">支出</asp:ListItem>
                            <asp:ListItem Value="1">收入</asp:ListItem>
                        </asp:DropDownList>
                        &nbsp;&nbsp;&nbsp;<br />
                    </td>
                </tr>
                <tr>
                    <td>账目分类：</td>
                    <td>
                        <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                            DataValueField="IncomeClassID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>资金账户：</td>
                    <td>
                        <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName"
                            DataValueField="AccountID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" Text="查询" OnClick="btnSearch_Click" />
                    </td>
                </tr>
            </table>
        </div>
        <div class=" kuai-list">
            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="IncomeID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <%# (int)Eval("Income") == 0 ? "支出" : "收入" %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <asp:Label ID="labAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'
                                Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="账目">
                        <ItemTemplate>
                            <asp:Label ID="labIncomeClassName" runat="server" Text='<%# Eval("IncomeClassName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                                DataValueField="IncomeClassID" DataSource='<%# swq.Cache.GetIncomeClass((int)Eval("Income")) %>'
                                SelectedValue='<%# Eval("IncomeClassID") %>'>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额">
                        <ItemTemplate>
                            <asp:Label ID="labPrice" runat="server" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxPrice" runat="server" Text='<%# Eval("Price") %>' Width="60"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="帐户">
                        <ItemTemplate>
                            <asp:Label ID="labAccountName" runat="server" Text='<%# Eval("AccountName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName" DataValueField="AccountID"
                                DataSource='<%# swq.Cache.GetAccount() %>' SelectedValue='<%# Eval("AccountID") %>'>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%# Eval("SchoolName") %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                                SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="TrueName" HeaderText="操作员" ReadOnly="true" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
