﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTimeDetails.aspx.cs" Inherits="MTCUN.Finance.LessonTimeDetails"
    Title="课时费管理-财务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script src="../JScript/web-modal.js"></script>
    <style type="text/css">
        .ld {
            margin: 0px;
            padding: 0px;
            list-style: none;
        }

            .ld li {
                /*float: left;*/
                display: inline-block;
            }
    </style>

    <%--    <script type="text/javascript">
        function Back() {
            //alert("ok");
            //location.replace(location.href);
            window.location.replace(location.href + "");
        }
    </script>--%>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-show form">
            <table class="table" cellspacing="0">
                <thead>
                    <tr>
                        <th colspan="2">课时费管理</th>
                    </tr>
                </thead>
                <tr>
                    <td>校区：</td>
                    <td>
                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>时间：</td>
                    <td class="mt-row">
                        <asp:DropDownList ID="ddlYear" runat="server">
                        </asp:DropDownList>年
                        <asp:DropDownList ID="ddlMonth" runat="server">
                            <asp:ListItem>1</asp:ListItem>
                            <asp:ListItem>2</asp:ListItem>
                            <asp:ListItem>3</asp:ListItem>
                            <asp:ListItem>4</asp:ListItem>
                            <asp:ListItem>5</asp:ListItem>
                            <asp:ListItem>6</asp:ListItem>
                            <asp:ListItem>7</asp:ListItem>
                            <asp:ListItem>8</asp:ListItem>
                            <asp:ListItem>9</asp:ListItem>
                            <asp:ListItem>10</asp:ListItem>
                            <asp:ListItem>11</asp:ListItem>
                            <asp:ListItem>12</asp:ListItem>
                        </asp:DropDownList>月
                    </td>
                </tr>
                <tr>
                    <td>类型：</td>
                    <td>
                        <asp:DropDownList ID="ddlLessonType" runat="server">
                            <asp:ListItem Value="1" Selected="True">正常</asp:ListItem>
                            <asp:ListItem Value="0">补课</asp:ListItem>
                            <asp:ListItem Value="-1">全部</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>状态：</td>
                    <td>
                        <asp:DropDownList ID="ddlLeState" runat="server">
                            <asp:ListItem Value="1" Selected="True">已上课</asp:ListItem>
                            <asp:ListItem Value="0">未上课</asp:ListItem>
                            <asp:ListItem Value="-1">全部</asp:ListItem>
                        </asp:DropDownList>

                    </td>
                </tr>
                <tr>
                    <td>主讲：</td>
                    <td class="mt-row">
                        <asp:DropDownList runat="server" ID="ddlTeacher" DataTextField="TrueName" DataValueField="UserID" OnSelectedIndexChanged="ddlTeacher_SelectedIndexChanged">
                        </asp:DropDownList>
                        <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />

                    </td>
                </tr>
                <tr>
                    <td>助教：</td>
                    <td class="mt-row">
                        <asp:DropDownList runat="server" ID="ddlAssistant" DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                        <uc1:SimpleCode ID="SimpleCode2" runat="server" UsersControlID="ddlAssistant" />
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <table class=" table_simple">
                            <tr>
                                <td>
                                    <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
                                </td>
                                <td>
                                    <div title="批处理课时费" data-toggle="tooltip" class="btn btn-default" data-url="../finance/editlesson.aspx" data-action="sxbind" onclick="openweb(this)">批处理课时费</div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <div class=" kuai-list">
            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="LessonTimeID" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating">
                <Columns>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                                CommandArgument='<%#Eval("LeStateID")%>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="ClassName" HeaderText="班级" ReadOnly="true"></asp:BoundField>
                    <asp:TemplateField HeaderText="上课时间">
                        <ItemTemplate>
                            <%#Eval("StartDate","{0:d}")%>
                            <span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="TeacherName" HeaderText="讲师" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AssistantName" HeaderText="助教" ReadOnly="True"></asp:BoundField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Lessons" HeaderText="课时" DataFormatString="{0:0.##}" ReadOnly="true"></asp:BoundField>
                    <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TruancyCount" HeaderText="旷课" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LeaveCount" HeaderText="请假" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="ClassroomName" HeaderText="教室" ReadOnly="True"></asp:BoundField>
                    <%--                    <asp:BoundField DataField="Price" HeaderText="消耗学费" DataFormatString="{0:0.###}"></asp:BoundField>--%>
                    <asp:BoundField DataField="LessonFee" HeaderText="讲师提成" ControlStyle-Width="50px" DataFormatString="{0:0.###}"></asp:BoundField>
                    <asp:BoundField DataField="TALessonFee" HeaderText="助教提成" ControlStyle-Width="50px" DataFormatString="{0:0.###}"></asp:BoundField>
                    <asp:TemplateField HeaderText="消耗学费">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkControlPanel" CssClass="btn btn-default" runat="server" Text="查看" NavigateUrl='<%# string.Format("Attend.aspx?LessonTimeID={0}&GetURL={1}",Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、可以手工编辑每课次提成金额，也可以使用批处理。<br />
        </div>


    </form>
</body>
</html>
