﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PostIncome.aspx.cs" Inherits="MTCUN.Finance.PostIncome"
    Title="增加收支-财务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function NoDataTips() {
            var _billItems = document.getElementById("BillItems");
            if (_billItems.innerText.trim() == "") {
                _billItems.innerHTML = "<span style='color:red'>*</span>请增加收支项目，可增加多个项目。";
            }
        }
    </script>
</head>
<body onload="NoDataTips()">
    <form id="form1" runat="server">
        <div class=" kuai-show form">
            <table class="table" cellspacing="0">
                <thead>
                    <tr>
                        <th colspan="2">增加新的账目
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>入帐日期：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxAccountDate" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>校区：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>收支项目：
                    </td>
                    <td class="mt-row">
                        <div class="striking_head listwidthauto">
                            类型：<asp:DropDownList ID="ddlIncome" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlIncome_SelectedIndexChanged">
                                <asp:ListItem Value="-1">选择</asp:ListItem>
                                <asp:ListItem Value="0">支出</asp:ListItem>
                                <asp:ListItem Value="1">收入</asp:ListItem>
                            </asp:DropDownList>
                            &nbsp;账目分类：<asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                                DataValueField="IncomeClassID">
                            </asp:DropDownList>
                            金额：<%= swq.CurrentCurrencySymbol%><asp:TextBox ID="tbxPrice" runat="server" Width="100px"></asp:TextBox>
                            &nbsp;资金账户：<asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName"
                                DataValueField="AccountID">
                            </asp:DropDownList>
                            备注：<asp:TextBox ID="tbxRemark" runat="server" Width="134px"></asp:TextBox>
                            <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click" />
                        </div>

                        <div class="striking_content">
                            <div style="display: inline-block" id="BillItems">
                                <div class="triangle-up"></div>
                                <div class=" details">
                                    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table table-hover"
                                        DataKeyNames="Index" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                                        OnRowUpdating="GridView1_RowUpdating" OnRowDeleting="GridView1_RowDeleting">
                                        <Columns>
                                            <asp:TemplateField HeaderText="类型">
                                                <ItemTemplate>
                                                    <%# (int)Eval("Income") == 0 ? "支出" : "收入" %>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="账目">
                                                <ItemTemplate>
                                                    <asp:Label ID="labIncomeClassName" runat="server" Text='<%# Eval("IncomeClassName") %>'></asp:Label>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                                                        DataValueField="IncomeClassID" DataSource='<%# swq.Cache.GetIncomeClass((int)Eval("Income")) %>'
                                                        SelectedValue='<%# Eval("IncomeClassID") %>'>
                                                    </asp:DropDownList>
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="金额">
                                                <ItemTemplate>
                                                    <asp:Label ID="labPrice" runat="server" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:TextBox ID="tbxPrice" runat="server" Text='<%# Eval("Price") %>' Width="90"></asp:TextBox>
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="帐户">
                                                <ItemTemplate>
                                                    <asp:Label ID="labAccountName" runat="server" Text='<%# Eval("AccountName") %>'></asp:Label>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName" DataValueField="AccountID"
                                                        DataSource='<%# swq.Cache.GetAccount() %>' SelectedValue='<%# Eval("AccountID") %>'>
                                                    </asp:DropDownList>
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="备注">
                                                <ItemTemplate>
                                                    <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="编辑">
                                                <ItemTemplate>
                                                    <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                                                </ItemTemplate>
                                                <EditItemTemplate>
                                                    <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                                                    <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                                                </EditItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="删除">
                                                <ItemTemplate>
                                                    <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete"></asp:LinkButton>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                        </Columns>
                                    </asp:GridView>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <asp:Button ID="btnSave" runat="server" CssClass="btn btn-default" Text="保存" OnClick="btnSave_Click" />
                    </td>
                </tr>
            </table>
        </div>
        <div class=" kuai-list">

            <asp:GridView ID="GridView2" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="IncomeID" OnRowCancelingEdit="GridView2_RowCancelingEdit" OnRowEditing="GridView2_RowEditing"
                OnRowUpdating="GridView2_RowUpdating" OnRowDeleting="GridView2_RowDeleting" OnRowDataBound="GridView2_RowDataBound" EnableModelValidation="True">
                <Columns>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <%# (int)Eval("Income") == 0 ? "支出" : "收入" %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <ItemTemplate>
                            <asp:Label ID="labAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxAccountDate" runat="server" Text='<%# Eval("AccountDate","{0:d}") %>'
                                Width="120"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="账目">
                        <ItemTemplate>
                            <asp:Label ID="labIncomeClassName" runat="server" Text='<%# Eval("IncomeClassName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlIncomeClass" runat="server" DataTextField="IncomeClassName"
                                DataValueField="IncomeClassID" DataSource='<%# swq.Cache.GetIncomeClass((int)Eval("Income")) %>'
                                SelectedValue='<%# Eval("IncomeClassID") %>'>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额">
                        <ItemTemplate>
                            <asp:Label ID="labPrice" runat="server" Text='<%# Eval("Price","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxPrice" runat="server" Text='<%# Eval("Price") %>' Width="80"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="帐户">
                        <ItemTemplate>
                            <asp:Label ID="labAccountName" runat="server" Text='<%# Eval("AccountName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlAccount" runat="server" DataTextField="AccountName" DataValueField="AccountID"
                                DataSource='<%# swq.Cache.GetAccount() %>' SelectedValue='<%# Eval("AccountID") %>'>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="校区">
                        <ItemTemplate>
                            <%# Eval("SchoolName") %>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlSchool" runat="server" DataSource="<%# swq.Cache.GetSchool() %>"
                                SelectedValue='<%# Eval("SchoolID") %>' DataValueField="SchoolID" DataTextField="SchoolName">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="TrueName" HeaderText="操作员" ReadOnly="true" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
    </form>
</body>
</html>
