﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Unpaid.aspx.cs" Inherits="MTCUN.Finance.Unpaid"
    Title="未付款查询-财务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
        <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                校区：<asp:DropDownList ID="ddlSchool" DataTextField="SchoolName" DataValueField="SchoolID"
                    runat="server">
                </asp:DropDownList>
                &nbsp;消费单号：<asp:TextBox ID="tbxBillID" runat="server"></asp:TextBox>
                <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
            </div>

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting" DataKeyNames="BillID" EnableModelValidation="True" OnSelectedIndexChanging="GridView1_SelectedIndexChanging">
                <Columns>
                    <asp:TemplateField HeaderText="单号">
                        <ItemTemplate>
                                                        <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                                runat="server" />
                            <asp:LinkButton ID="lbnSelect" runat="server" Text='<%# Eval("BillID") %>' CommandName="Select" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="StudentID" HeaderText="学号" />
                    <asp:BoundField DataField="StudentName" HeaderText="姓名" />
                    <asp:BoundField DataField="Tel" HeaderText="电话" />
                    <asp:BoundField DataField="MobileTel" HeaderText="手机" />
                    <asp:BoundField DataField="DateAndTime" HeaderText="时间" />
                    <asp:BoundField DataField="Arrearage" DataFormatString="{0:c2}" HeaderText="欠费金额" />
                    <asp:TemplateField HeaderText="帐单">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkBillShow" runat="server" CssClass="btn btn-default" Text="帐单" NavigateUrl='<%# string.Format("../Register/StuControlPanel.aspx?StudentID={0}&pageindex=2&geturl={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="支付状态">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkCode" CssClass="btn btn-default" runat="server">
                                支付记录
                                    <span class="badge"><%#Eval("PayCount") %></span>
                            </asp:HyperLink>
                            <asp:HyperLink ID="hlkState" runat="server" Height="20px"></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandArgument='<%#Eval("UserID")%>'
                                CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

                <div id="divItems" style="visibility: hidden">
            <div style="display: inline-block" id="sub">
                <div class="triangle-up"></div>
                <div class=" details">
                    <asp:GridView ID="gvItems" runat="server" AutoGenerateColumns="false" CssClass="table table-hover">
                        <Columns>
                            <asp:BoundField DataField="ProductID" HeaderText="编号" ReadOnly="True" />
                            <asp:TemplateField HeaderText="项目">
                                <ItemTemplate>
                                    <%# Eval("ProductName") %><%#swq.Tools.AddBrackets(Eval("PackageName")) %>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="单价">
                                <ItemTemplate>
                                    <asp:Label ID="labUnitPrice" runat="server" Text='<%# Bind("UnitPrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="数量">
                                <ItemTemplate>
                                    <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount","{0:0.##}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="单位">
                                <ItemTemplate>
                                    <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="优惠">
                                <ItemTemplate>
                                    <asp:Label ID="labDiscount" runat="server" Text='<%# Eval("Discount","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="合计">
                                <ItemTemplate>
                                    <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级/仓库">
                                <ItemTemplate>
                                    <asp:Label ID="labServiceName" runat="server" Text='<%# Bind("ServiceName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
