﻿
//转换成小写
function ToLower(code) {
    var reCat = /\&lt;(.+?)\&gt;/gm;
    return code.replace(reCat, _toLower);
}

function _toLower(word) {
    if (word != null && word.length > 0) {
        word = word.toLowerCase();
        word = "<span style='color:#A31515'>" + word + "</span>";
    }
    return word;
}

//清除
function clearProperty(str) {
    //var reg1 = /(\s+\w+)\s*=\s*([^<>"\s]+)(?=[^<>]*>)/ig;
    //var reg2 = /"'([^'"]*)'"/ig;
    //str = str.replace(reg1, '$1="$2"'); //.replace(reg2, '\"$1\"');
    return str;
}



//SQL查询语法
function RenderingSource(theBox) {
    theBox.innerText = theBox.innerText;
    var code = theBox.innerText;

    code = code.replace(/\bfrom\b(\s+[a-zA-Z0-9,]+)(\s*)/ig, "from<span style='color:#2B91AF'>$1</span>$2");     //from
    code = code.replace(/([a-zA-Z0-9]+)\./ig, "<span style='color:#2B91AF'>$1</span>.");                          //table.
    code = code.replace(/\bas\b +([^, \r\n]+)/igm, "as <span style='color:#A31515'>$1</span>");                  //as

    code = code.replace(/\{\@([a-zA-Z0-9]+)\}/ig, "<span style='color:#AF5500; background-color:#FFEE62' >{@<span style='color:#000'>$1</span>}</span> ");
    code = code.replace(/\{\@([a-zA-Z0-9]+):([^\}]+)\}/ig, " <span style='color:#AF5500; background-color:#FFEE62'>{@<span style='color:#000'>$1</span>:<span style='color:#A31515'>$2</span>}</span>");

    code = code.replace(/\b(ShowKey)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey
    code = code.replace(/\b(ShowKey1)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey1
    code = code.replace(/\b(ShowKey2)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey2
    code = code.replace(/\b(ShowKey3)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey3
    code = code.replace(/\b(ShowKey4)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey4
    code = code.replace(/\b(ShowKey5)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey5
    code = code.replace(/\b(ChartText)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ChartText
    code = code.replace(/\b(ChartValue)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ChartValue
    code = code.replace(/\b(and|or|in|order|by|select|from|where|group|union|desc|asc|as|case)\b/ig, "<span style='color:#0000FF'>$1</span>");


    //麦田语法
    code = code.replace(/\@([a-zA-Z0-9]+)/ig, "<span style='color:#AF5500; background-color:#FFEE62' >@<span style='color:#000'>$1</span></span>");
    code = code.replace(/\btable *: *([a-zA-Z0-9,_]+)/ig, "<span style='color:#0000FF'>table:</span><span style='color:#2B91AF'>$1</span>");   //table
    code = code.replace(/\bcmd *:/ig, "<span style='color:#0000FF'>cmd:</span>");   //cmd
    code = code.replace(/\bgo\b/ig, "<span style='color:#0000FF'>GO</span>");   //go


    code = code.replace(/\n/ig, "<br>");
    code = "<span style='color:#000000'>" + code + "</span>";
    
    
    theBox.innerHTML = code;
}


//Xsl报表打印语法
function RenderingXsl(theBox) {
    theBox.innerText = theBox.innerText;
    var code = theBox.innerHTML;

    //<内容>
    code = code.replace(/(\&lt;\/?\??)(.+?)(\/?\??\&gt;)/gm, "$1<span style='color:#A31515'>$2</span>$3");

    //<>
    code = code.replace(/&lt;(\/?\??) */g, "<span style='color:#0000FF'>&lt;$1</span>");
    code = code.replace(/(\/?\??)&gt;/g, "<span style='color:#0000FF'>$1&gt;</span>");

    
    //select=x
    code = code.replace(/\b(select)\b( *= *)"([^"]+)"/ig, "<span style='color:#0000FF'><span style='color:#FF0000'>$1</span>$2\"<span style='color:#000000; background-color:#FFEE62'>$3</span>\"</span>");

    //select=x
    code = code.replace(/\b(test)\b( *= *)"([^"]+)"/ig, "<span style='color:#0000FF'><span style='color:#FF0000'>$1</span>$2\"<span style='color:#000000; background-color:#FFEE62'>$3</span>\"</span>");
    
    //属性
    code = code.replace(/(\b[\w:]+)\b\s*=\s*("[^"]*")/g, "<span style='color:#FF0000'>$1</span><span style='color:#0000FF'>=$2</span>");

    //xsl关键字
    code = code.replace(/\b(xsl:value-of|xsl:if|xsl:for-each|xsl:param|xsl:variable|xsl:template|xsl:stylesheet)\b/ig, "<span style='color:#2B91AF'>$1</span>");
    
    theBox.innerHTML = code;
}


//HTML查询语法
function RenderingHTML(theBox) {
    theBox.innerText = theBox.innerText;
    var code = theBox.innerHTML;


    var reCat = /\&lt;(.+?)\&gt;/gm;

    //HTML着色
    code = code.replace(reCat, Rep);
//    code = code.replace(/(style)\s*=\s*("[^"]*")/g, RepStyle); //可以给STYLE里的属性着色，暂不使用。
    code = code.replace(/(\s+\w+)\s*=\s*("[^"]*")/g, "<span style='color:#FF0000'>$1</span><span style='color:#0000FF'>=$2</span>");
    

    //处理jscript内容，做标记
    code = code.replace(/&lt;script([^&]+)&gt;(.+?)&lt;\/script&gt;/g, "&lt;<span style='color:#A31515'>script$1</span>&gt;<script_start>$2<script_end>&lt;/<span style='color:#A31515'>script</span>&gt;");

    code = code.replace(/&lt;\/ */g, "<span style='color:#0000FF'>&lt;/</span>");        //标亮</
    code = code.replace(/\/&gt;/g, "<span style='color:#0000FF'>/&gt;</span>");          //标亮/>

    code = code.replace(/(&lt;)([^%])/g, "<span style='color:#0000FF'>$1</span>$2");     //标亮<
    code = code.replace(/([^%])(&gt;)/g, "$1<span style='color:#0000FF'>$2</span>");     //标亮>

    //标亮<% ... %>
    code = code.replace(/(&lt;%)([^%]+)(%&gt;)/g, "<span style='background-color:#FFEE62; color:#000000'>$1</span><span style='color:#000000'>$2</span><span style='background-color:#FFEE62; color:#000000'>$3</span>");

    //<>
    code = code.replace(/&lt;(\/?\??) */g, "<span style='color:#0000FF'>&lt;$1</span>");
    code = code.replace(/(\/?\??)&gt;/g, "<span style='color:#0000FF'>$1&gt;</span>");

    code = code.replace(/\n/ig, "<br>");
    code = "<span style='color:#000000'>" + code + "</span>";

    //处理jscript内容
    var _reCat = /<script_start>(.+?)<script_end>/gm;
    code = code.replace(_reCat, RepScript);
    code = code.replace(/<script_start>/g, "");
    code = code.replace(/<script_end>/g, "");

    theBox.innerHTML = code;
}

function Rep(word) {
    if (word != null && word.length > 0) {
        word = "<span style='color:#A31515'>" + word + "</span>";
    }

    return word;
}

function RepStyle(word) {
    if (word != null && word.length > 0) {
        word = word.replace(/([^\:"]*):([^;"]*)/g, "<span style='color:#ff0000'>$1</span><span style='color:#0000ff'>:$2</span>");
    }

    return word;
}

function RepScript(word) {
    if (word != null && word.length > 0) {
        word = word.replace(/\<span[^\>]+\>/g, "");
        word = word.replace(/<\/span>/g, "");
        
        word = word.replace(/\b(string|object|int|return|as|throw|try|catch|finally|true|false|public|static|bool|null|new|var|if|for|function|protected|void|using|foreach|while|else|this|typeof|continue|default)\b/ig, "<span style='color:#0000FF'>$1</span>");
        word = word.replace(/\b(OleDbCommand|SqlCommand|OleDbDataAdapter|SqlDataAdapter|OleDbType|SqlDbType|DataSet|DataTable|OleDbConnection|SqlConnection|EventArgs|swq|Cache|cDateTime|DateTime|OleDbException|SqlException|db)\b/ig, "<span style='color:#2B91AF'>$1</span>");
        word = word.replace(/"([^\"]*)"/g, Clear_Ying);//处理引号内样式
        word = "<span style='color:#000'>" + word + "</span>";
    }

    return word;
}

function Clear_Ying(word) {
    if (word != null && word.length > 0) {
        word = word.replace(/\<span[^\>]+\>/g, "");
        word = word.replace(/<\/span>/g, "");
        word = word.replace(/"([^\"]*)"/g, "<span style='color:#A31515'>\"$1\"</span>");
    }

    return word;
}