﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sys_SendEvent.aspx.cs"
    Inherits="MTCUN.SMS.sys_SendEvent" Title="短信事件-短信" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .auto-style1 {
            color: #FF0000;
        }
    </style>
</head>
<body>
<!--#include file="../../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" control_bg">短信内容格式：<asp:DropDownList ID="ddlMBType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlMBType_SelectedIndexChanged">
            <asp:ListItem Value="0">自定义</asp:ListItem>
            <asp:ListItem Value="1">内置模板</asp:ListItem>
            </asp:DropDownList></div>
        <div class=" kuai-list">

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table"
                DataKeyNames="SendEventID" OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowEditing="GridView1_RowEditing"
                OnRowUpdating="GridView1_RowUpdating" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="SendEventID" HeaderText="事件编号" ReadOnly="true" />
                    <asp:BoundField DataField="SendEventName" HeaderText="事件名称" />
                    <asp:TemplateField HeaderText="发送短信">
                        <ItemTemplate>
                            <%# Rs.Items.GetYN((int)Eval("LockState"))%>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlLockState" SelectedIndex='<%# Eval("LockState") %>'>
                                <asp:ListItem Value="0" Text="否"></asp:ListItem>
                                <asp:ListItem Value="1" Text="是"></asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="短信内容" HeaderStyle-Width="350px">
                        <ItemTemplate>
                            <asp:Label ID="labContent" runat="server" Text='<%# Eval("Content") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <div id="msg2" style="color: #676767">
                            </div>
                            <asp:TextBox ID="tbxContent" runat="server" Text='<%# Eval("Content") %>' TextMode="MultiLine"
                                Height="100px" Width="180px"></asp:TextBox>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DelayMinute" HeaderText="延时发送（分钟）" />
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                                <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                                <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                                <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、<span class="auto-style1">短信内容格式选择【内置模板】，短信内容由系统控制，无需审核快速到达。</span><br />
            2、所有事件内容中都支持如下变量：<b>{学号}{姓名}{手机}{日期时间}{日期}{时间}</b>。<br />
            3、事件1、事件2，同时支持如下变量：<b>{班号}{班级名称}{讲师}{上课时间}{上课教室}{考勤状态}{课时提醒}</b>。<br />
            4、事件4，同时支持如下变量：<b>{班号}{班级名称}{讲师}{开班日期}{上课规律}{上课教室}{上课校区}</b>。<br />
            5、事件5，同时支持如下变量：<b>{单号}{付款方式}{类型}{金额}</b>。<br />
            6、事件6，同时支持如下变量：<b>{单号}{应扣金额}{优惠金额}{实扣金额}。</b><br />
        </div>
    </form>
</body>
</html>
