﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sys_SmsTemplate.aspx.cs"
    Inherits="MTCUN.SMS.sys_SmsTemplate" Title="短信模板-短信" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <table>
                    <tr>
                        <td class="mt-row">模板名称：<asp:TextBox ID="tbxSmsTemplateName" runat="server" Width="168px"></asp:TextBox>

                        </td>
                        <td class="mt-row" style="padding: 4px">模板内容：        </td>
                        <td class="mt-row">
                            <div id="msg" style="color: #676767">
                            </div>
                            <asp:TextBox ID="tbxContent" runat="server" Width="166px" TextMode="MultiLine" Height="50px"></asp:TextBox></td>
                        <td style="padding: 4px">类型：
                            <asp:DropDownList ID="ddlUserLevel" runat="server">
                                <asp:ListItem Value="0">请选择</asp:ListItem>
                                <asp:ListItem Value="1">通知</asp:ListItem>
                                <asp:ListItem Value="2">广告</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td style="padding: 4px">
                            <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click"></asp:Button></td>
                    </tr>
                </table>
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="SmsTemplateID" OnRowCancelingEdit="GridView1_RowCancelingEdit"
                OnRowCommand="GridView1_RowCommand" OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating"
                OnRowCreated="GridView1_RowCreated" OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="SmsTemplateID" ReadOnly="True" HeaderText="编号" />
                    <asp:BoundField DataField="SmsTemplateName" HeaderText="名称" />
                    <asp:TemplateField HeaderText="类别">
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlUserLevel" runat="server" SelectedValue='<%# Eval("UserLevel") %>'>
                                <asp:ListItem Value="1">通知</asp:ListItem>
                                <asp:ListItem Value="2">广告</asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labUserLevel" runat="server" Text='<%# Rs.Items.GetUserLevel(Eval("UserLevel")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="内容">
                        <EditItemTemplate>
                            <div id="msg2" style="color: #676767">
                            </div>
                            <asp:TextBox ID="tbxContent" runat="server" Text='<%# Bind("Content") %>' Width="153px"
                                TextMode="MultiLine" Height="100px"></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labContent" runat="server" Text='<%# swq.Tools.HtmlEncode(Eval("Content").ToString()) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
