﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TeacherLessons.aspx.cs" Inherits="MTCUN.Mobile.Affairs.TeacherLessons" Title="老师课时统计-教务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc1" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
    <link runat="server" href="../msg/Themes/css.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <uc1:col_Header ID="col_Header1" runat="server" />
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">
                    <div class="striking">
                        <table class="table_simple_kuan">
                            <tr>
                                <td>
                                    <div style="text-align: center">
                                        <asp:Label ID="labMonth" runat="server" Font-Bold="true"></asp:Label>
                                    </div>
                                    <asp:TextBox ID="tbxDateAndTime" runat="server" Visible="false"></asp:TextBox>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <table class="mt-table-m">
                                        <tr>
                                            <td>
                                                <asp:Button ID="btnShow" runat="server" CssClass="btn btn-default" OnClick="btnShow_Click" Text="本月" />
                                            </td>
                                            <td>
                                                <asp:Button ID="btnUp" runat="server" CssClass="btn btn-default" OnClick="btnUp_Click" Text="上月" />
                                            </td>
                                            <td>
                                                <asp:Button ID="btnDown" runat="server" CssClass="btn btn-default" OnClick="btnDown_Click" Text="下月" />
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server">
                            <ItemTemplate>
                                <div class="kuai" style="margin: 3px; margin-bottom: 10px;">
                                    <div class="inforow" style="height: 100px">
                                        <div class="logo" style='<%# string.Format("background-image:url(\"{0}\")",ShowUserFace(Eval("头像").ToString())) %>'>
                                        </div>
                                        <div class="name">
                                            <%#Eval("老师")%>
                                        </div>
                                        <div class="time">
                                            总小时：<%#Eval("总小时数")%>
                                        </div>
                                        <div class="content" style="height: 60px">
                                            总课次：<%#Eval("总课次")%><br />
                                            总课时：<%#Eval("总课时")%><br />
                                            主讲总课时费：<%#Eval("班级总课时费2","{0:c2}")%><br />
                                            消耗学员课时费：<%#Eval("消耗学费","{0:c2}")%><br />

                                        </div>

                                    </div>
                                    <asp:HyperLink ID="hlkShow" runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("TeacherLessonsShow.aspx?TeacherID={0}&DateAndTime={1}&geturl={2}",Eval("工号"), Server.UrlEncode(tbxDateAndTime.Text), swq.Web.PathAndQuery()) %>'>明细</asp:HyperLink>
                                </div>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </form>
</body>
</html>
