﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TimeConflict.aspx.cs" Inherits="MTCUN.Mobile.Affairs.TimeConflict" Title="排课冲突检测-教务" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">

                    <div id="yesc" runat="server" class="striking" style="color: red; text-align: center">冲突课次如下</div>
                    <div id="noc" runat="server" class="kuai-show" style="height: 80px; text-align: center; vertical-align: middle; line-height: 80px">未发现任何冲突</div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>
                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">
                                    <h1 style="text-align: center"><%#Eval("ClassName")%></h1>
                                    <table class=" table_simple_kuan" cellspacing="0" border="0">
                                        <tr>
                                            <td style="width: 70px"><%# (int)Eval("LeStateID") == 0 ? "<span class ='weishangke'>未上课</span>": "<span class ='yishangke'>已上课</span>"%></td>
                                            <td style="width: auto"></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">班号：</td>
                                            <td style="width: auto"><%#Eval("ClassID")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课日期：</td>
                                            <td style="width: auto">
                                                <%#Eval("StartDate","{0:d}")%><span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课时段：</td>
                                            <td style="width: auto">
                                                <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto">
                                                <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                                    runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                                    ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">讲师：</td>
                                            <td style="width: auto">
                                                <%#Eval("TeacherName")%></td>
                                        </tr>
                                        <tr>
                                            <td>教室：</td>
                                            <td>
                                                <%#Eval("ClassroomName") %>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>

                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <label class="lab_button_kuan" id="__mt_labBack" runat="server">
                        <input causesvalidation="false" type="button" runat="server" onclick="back(this)" value="返回" />
                    </label>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
