﻿<%@ Page Language="c#" CodeBehind="ClassList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Mobile.Class.ClassList"
    Title="班级列表-教务" %>

<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function OpenSearch() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
            }
        }
    </script>
</head>
<body onload="defaultSearchState()">
    <form id="Form1" method="post" runat="server">
        <uc3:col_Header ID="col_Header1" runat="server" />


        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">


                    <div class="setandsearch">
                        <ul class="mt-listitems">

                            <li>
                                <asp:DropDownList CssClass="select2" ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                                    <asp:ListItem Value="0">默认排序</asp:ListItem>
                                    <asp:ListItem Value="1">开班日期</asp:ListItem>
                                    <asp:ListItem Value="2">班级编号</asp:ListItem>
                                </asp:DropDownList>
                            </li>
                            <li>
                                <div id="setControl" onclick="OpenSearch()" class="btn btn-default">
                                    ▼搜索
                                </div>
                            </li>
                        </ul>

                        <div id="setContent" style="display: none" class="kuai-show">
                            <h1>班级快速查询</h1>
                            <table class="mt-table-m">
                                <tr>
                                    <td>校区：
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>课程分类：
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlCourseType" runat="server" DataTextField="CourseTypeName"
                                            DataValueField="CourseTypeID" AutoPostBack="True" OnSelectedIndexChanged="ddlCourseType_SelectedIndexChanged">
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>课程：
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlCourse" runat="server" DataTextField="CourseName" DataValueField="CourseID">
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>班号：
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbxClassID" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>名称：
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbxClassName" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>日期：
                                    </td>
                                    <td>
                                        <ul class="mt-listitems">
                                            <li>
                                                <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                                            </li>
                                            <li>
                                                <asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                                <tr>
                                    <td>班级类型：
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlClassType" runat="server">
                                            <asp:ListItem Value="-1" Text=""></asp:ListItem>
                                            <asp:ListItem Value="0">一对多</asp:ListItem>
                                            <asp:ListItem Value="1">一对一</asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>状态：
                                    </td>
                                    <td>
                                        <asp:DropDownList ID="ddlState" runat="server">
                                            <asp:ListItem Value="0" Text=""></asp:ListItem>
                                            <asp:ListItem Value="1" Text="未开课"></asp:ListItem>
                                            <asp:ListItem Value="2" Text="开课中"></asp:ListItem>
                                            <asp:ListItem Value="3" Text="已结束"></asp:ListItem>
                                            <asp:ListItem Selected="True" Value="4" Text="未结束"></asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <tr>
                                    <td>讲师：
                                    </td>
                                    <td>
                                        <div class="inline_block">
                                            <asp:DropDownList ID="ddlTeacher" runat="server" DataTextField="TrueName" DataValueField="UserID">
                                            </asp:DropDownList>
                                        </div>
                                        <div class="inline_block">
                                            <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <div class="lab_button">
                                            <asp:Button ID="btnSelect" runat="server" CssClass="btn btn-default" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>



                    <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" DataKeyNames="ClassID"
                        AutoGenerateColumns="False" OnRowDataBound="GridView1_RowDataBound" ShowHeader="False">
                        <Columns>
                            <asp:TemplateField>
                                <ItemTemplate>
                                </ItemTemplate>
                            </asp:TemplateField>

                        </Columns>
                    </asp:GridView>
                    <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand" OnItemDataBound="repBlock_ItemDataBound">
                        <ItemTemplate>
                            <div class="kuai">
                                <h1 class="auto_length_title">
                                    <span class="glyphicon glyphicon-home text-success"></span>
                                    <%#Eval("ClassName") %>
                                </h1>

                                <table class="mt-table-m">
                                    <tr>
                                        <td style="width: auto">班号：</td>
                                        <td style="width: auto"><%#Eval("ClassID") %></td>
                                    </tr>
                                    <tr>
                                        <td style="width: auto">开课日期：</td>
                                        <td style="width: auto"><%#Eval("StartDate","{0:d}") %></td>
                                    </tr>
                                    <tr>
                                        <td>老师：</td>
                                        <td><%#Eval("TeacherName") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课规律：</td>
                                        <td><%#Eval("TimeRule") %></td>
                                    </tr>
                                    <tr>
                                        <td>校区：</td>
                                        <td><%#Eval("SchoolName") %></td>
                                    </tr>
                                    <tr>
                                        <td>招生比例：</td>
                                        <td>
                                            <uc2:Progress ID="Progress1" runat="server" MaxNum='<%#Eval("PlanCount") %>' MinNum='<%#Eval("StuCount") %>'
                                                ProgressWidth="50px" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>上课进度：</td>
                                        <td>
                                            <uc2:Progress ID="Progress3" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                                ProgressWidth="50px" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>排课进度：</td>
                                        <td>
                                            <uc2:Progress ID="Progress2" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("ArrangeLessons") %>'
                                                ProgressWidth="50px" />
                                        </td>
                                    </tr>
                                </table>
                                <table class="mt-table-m">
                                    <tr>


                                        <td>
                                                <asp:LinkButton ID="lbnDelete" runat="server"  CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("ClassID")%>'
                                                    OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                        </td>
                                        <td>
                                                <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("PostClass.aspx?ClassID={0}&PageIndex=0&action=edit&topURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                                        </td>
                                        <td>
                                                <asp:HyperLink ID="hlkControlPanel" runat="server" CssClass="btn btn-default" Text="控制面板" NavigateUrl='<%# string.Format("Class.aspx?ClassID={0}&topURL={1}",Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <asp:HiddenField ID="hfdSearchState" Value="0" runat="server" />
    </form>
</body>
</html>
