﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ClassStudents.aspx.cs"
    Inherits="MTCUN.Mobile.Class.ClassStudents" Title="班级学员-教务" %>

<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_ReportControl.ascx" TagName="ReportControl" TagPrefix="uc2" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<%@ Register Src="../User_Col/col_ClassControlPanel.ascx" TagName="col_ClassControlPanel" TagPrefix="uc4" %>
<%@ Register Src="../../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc5" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function Checks(state) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = state;
                }
            }
        }

    </script>
    <script type="text/javascript">
        function GetSelectedValues() {
            var pID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        pID += "," + e.value;
                    }
                }
            }

            if (pID.length > 0) {
                pID = pID.substring(1, pID.length);
            }

            return pID;
        }

        function Send(type) {
            var pids = GetSelectedValues();
            if (pids.length > 0) {
                document.getElementById("StuClassID").value = pids;
                if (type == 1) {
                    document.formStudent.action = "../sms/SendToStudent.aspx?geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
                else {
                    document.formStudent.action = "../sendmsg.aspx?classid=" + ClassID + "&geturl=" + encodeURIComponent(location.href);
                    document.formStudent.submit();
                }
            }
        }
    </script>
        <script type="text/javascript">
        $(document).ready(function () {

            $("#mt-allcheck").click(function () {
                var text = jQuery(this).text();
                if (text == "全选")
                { Checks(true); jQuery(this).text("取消"); }
                else
                { Checks(false); jQuery(this).text("全选"); }
            });

        });

    </script>
</head>
<body>
    <form id="form1" runat="server">
        <uc3:col_Header ID="col_Header1" runat="server" />
        <uc5:ReportServer ID="ReportServer1" runat="server" />
        <div id="web_page_contents">
            <div class="biao_zhun_suo_jin">
                <div class="container">

                    <uc4:col_ClassControlPanel ID="col_ClassControlPanel1" runat="server" />

                    <div class=" striking" style="margin-top: 5px">
                        <table class="mt-table-m">
                            <tr>
                                <td>
                                    <label class="btn btn-default" id="mt-allcheck">全选</label>
                                </td>
                                <td>
                                    <asp:HyperLink ID="hlkWX" runat="server" CssClass="btn btn-success" NavigateUrl='<%#string.Format("javascript:Send(2);void(0);") %>'
                                        Text="发微信" />
                                </td>
                                <td>
                                    <asp:HyperLink ID="hlkSMS" runat="server" CssClass="btn btn-success" NavigateUrl='<%#string.Format("javascript:Send(1);void(0);") %>'
                                        Text="发短信" />
                                </td>
                                <td class="mt-row">
                                    <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                                        <asp:ListItem Value="0">默认</asp:ListItem>
                                        <asp:ListItem Value="1">显示全部</asp:ListItem>
                                        <asp:ListItem Value="2">状态正常</asp:ListItem>
                                        <asp:ListItem Value="3">状态异常</asp:ListItem>
                                        <asp:ListItem Value="4">课时未完</asp:ListItem>
                                        <asp:ListItem Value="5">课时上完</asp:ListItem>
                                    </asp:DropDownList></td>
                            </tr>
                        </table>
                    </div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand" OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>
                                <div class="kuai">
                                    <h1 class="auto_length_title">
                                        <span runat="server" id="spanBox">
                                            <input type="checkbox" id="id" value='<%#Eval("StuClassID")%>' /></span><%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("qywxState"), Eval("mtqywxState"), Eval("wxState"), Eval("mtwxState"))%>
                                    </h1>

                                    <table class="mt-table-m">
                                        <tr>
                                            <td style="width: auto">学号：</td>
                                            <td style="width: auto">
                                                <%# Eval("StudentID")%>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">选班状态：</td>
                                            <td style="width: auto"><%# Rs.Items.GetScState(Eval("ScStateID")) %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto"><%#Rs.Items.GetStuClassType(Eval("ContinueReg"))%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">选班日期：</td>
                                            <td style="width: auto"><%# Eval("DateAndTime") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">课时进度：</td>
                                            <td style="width: auto">
                                                <uc1:Progress ID="Progress1" runat="server" QType='<%#(QType)Eval("QType") %>' MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                                    StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>' Width="90%" />
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>总成绩：</td>
                                            <td><%#Eval("Score")%></td>
                                        </tr>
                                    </table>
                                </div>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                    <uc2:ReportControl ID="ReportControl1" runat="server" Visible="false" />
                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>


                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                </div>
            </div>
            </div>
    </form>
    <div class="printWeb">
        <iframe id="PrintWeb" width="0" height="0"></iframe>

        <!--短信Post传递参数代码S-->
        <form id="formStudent" name="formStudent" method="post">
            <input id="StuClassID" name="StuClassID" type="hidden" value="" />
        </form>
        <!--短信Post传递参数代码E-->
    </div>
</body>
</html>
